/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.IOException;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestConverters;
import org.elasticsearch.client.ccr.CcrStatsRequest;
import org.elasticsearch.client.ccr.DeleteAutoFollowPatternRequest;
import org.elasticsearch.client.ccr.FollowInfoRequest;
import org.elasticsearch.client.ccr.FollowStatsRequest;
import org.elasticsearch.client.ccr.ForgetFollowerRequest;
import org.elasticsearch.client.ccr.GetAutoFollowPatternRequest;
import org.elasticsearch.client.ccr.PauseAutoFollowPatternRequest;
import org.elasticsearch.client.ccr.PauseFollowRequest;
import org.elasticsearch.client.ccr.PutAutoFollowPatternRequest;
import org.elasticsearch.client.ccr.PutFollowRequest;
import org.elasticsearch.client.ccr.ResumeAutoFollowPatternRequest;
import org.elasticsearch.client.ccr.ResumeFollowRequest;
import org.elasticsearch.client.ccr.UnfollowRequest;

final class CcrRequestConverters {
    CcrRequestConverters() {
    }

    static Request putFollow(PutFollowRequest putFollowRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPart(putFollowRequest.getFollowerIndex()).addPathPartAsIs("_ccr", "follow").build();
        Request request = new Request("PUT", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params();
        parameters.withWaitForActiveShards(putFollowRequest.waitForActiveShards());
        request.setEntity(RequestConverters.createEntity(putFollowRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        request.addParameters(parameters.asMap());
        return request;
    }

    static Request pauseFollow(PauseFollowRequest pauseFollowRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPart(pauseFollowRequest.getFollowerIndex()).addPathPartAsIs("_ccr", "pause_follow").build();
        return new Request("POST", endpoint);
    }

    static Request resumeFollow(ResumeFollowRequest resumeFollowRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPart(resumeFollowRequest.getFollowerIndex()).addPathPartAsIs("_ccr", "resume_follow").build();
        Request request = new Request("POST", endpoint);
        request.setEntity(RequestConverters.createEntity(resumeFollowRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request unfollow(UnfollowRequest unfollowRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPart(unfollowRequest.getFollowerIndex()).addPathPartAsIs("_ccr", "unfollow").build();
        return new Request("POST", endpoint);
    }

    static Request forgetFollower(ForgetFollowerRequest forgetFollowerRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPart(forgetFollowerRequest.leaderIndex()).addPathPartAsIs("_ccr").addPathPartAsIs("forget_follower").build();
        Request request = new Request("POST", endpoint);
        request.setEntity(RequestConverters.createEntity(forgetFollowerRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request putAutoFollowPattern(PutAutoFollowPatternRequest putAutoFollowPatternRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_ccr", "auto_follow").addPathPart(putAutoFollowPatternRequest.getName()).build();
        Request request = new Request("PUT", endpoint);
        request.setEntity(RequestConverters.createEntity(putAutoFollowPatternRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request deleteAutoFollowPattern(DeleteAutoFollowPatternRequest deleteAutoFollowPatternRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_ccr", "auto_follow").addPathPart(deleteAutoFollowPatternRequest.getName()).build();
        return new Request("DELETE", endpoint);
    }

    static Request getAutoFollowPattern(GetAutoFollowPatternRequest getAutoFollowPatternRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_ccr", "auto_follow").addPathPart(getAutoFollowPatternRequest.getName()).build();
        return new Request("GET", endpoint);
    }

    static Request pauseAutoFollowPattern(PauseAutoFollowPatternRequest pauseAutoFollowPatternRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_ccr", "auto_follow").addPathPart(pauseAutoFollowPatternRequest.getName()).addPathPartAsIs("pause").build();
        return new Request("POST", endpoint);
    }

    static Request resumeAutoFollowPattern(ResumeAutoFollowPatternRequest resumeAutoFollowPatternRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_ccr", "auto_follow").addPathPart(resumeAutoFollowPatternRequest.getName()).addPathPartAsIs("resume").build();
        return new Request("POST", endpoint);
    }

    static Request getCcrStats(CcrStatsRequest ccrStatsRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_ccr", "stats").build();
        return new Request("GET", endpoint);
    }

    static Request getFollowStats(FollowStatsRequest followStatsRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPart(followStatsRequest.getFollowerIndex()).addPathPartAsIs("_ccr", "stats").build();
        return new Request("GET", endpoint);
    }

    static Request getFollowInfo(FollowInfoRequest followInfoRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPart(followInfoRequest.getFollowerIndex()).addPathPartAsIs("_ccr", "info").build();
        return new Request("GET", endpoint);
    }
}

