/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.dataframe;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.client.ml.dataframe.DataFrameAnalysis;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class OutlierDetection
implements DataFrameAnalysis {
    public static final ParseField NAME = new ParseField("outlier_detection", new String[0]);
    static final ParseField N_NEIGHBORS = new ParseField("n_neighbors", new String[0]);
    static final ParseField METHOD = new ParseField("method", new String[0]);
    public static final ParseField FEATURE_INFLUENCE_THRESHOLD = new ParseField("feature_influence_threshold", new String[0]);
    static final ParseField COMPUTE_FEATURE_INFLUENCE = new ParseField("compute_feature_influence", new String[0]);
    static final ParseField OUTLIER_FRACTION = new ParseField("outlier_fraction", new String[0]);
    static final ParseField STANDARDIZATION_ENABLED = new ParseField("standardization_enabled", new String[0]);
    private static ObjectParser<Builder, Void> PARSER = new ObjectParser(NAME.getPreferredName(), true, () -> new Builder());
    private final Integer nNeighbors;
    private final Method method;
    private final Double featureInfluenceThreshold;
    private final Boolean computeFeatureInfluence;
    private final Double outlierFraction;
    private final Boolean standardizationEnabled;

    public static OutlierDetection fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null).build();
    }

    public static OutlierDetection createDefault() {
        return OutlierDetection.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private OutlierDetection(Integer nNeighbors, Method method, Double featureInfluenceThreshold, Boolean computeFeatureInfluence, Double outlierFraction, Boolean standardizationEnabled) {
        this.nNeighbors = nNeighbors;
        this.method = method;
        this.featureInfluenceThreshold = featureInfluenceThreshold;
        this.computeFeatureInfluence = computeFeatureInfluence;
        this.outlierFraction = outlierFraction;
        this.standardizationEnabled = standardizationEnabled;
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    public Integer getNNeighbors() {
        return this.nNeighbors;
    }

    public Method getMethod() {
        return this.method;
    }

    public Double getFeatureInfluenceThreshold() {
        return this.featureInfluenceThreshold;
    }

    public Boolean getComputeFeatureInfluence() {
        return this.computeFeatureInfluence;
    }

    public Double getOutlierFraction() {
        return this.outlierFraction;
    }

    public Boolean getStandardizationEnabled() {
        return this.standardizationEnabled;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.nNeighbors != null) {
            builder.field(N_NEIGHBORS.getPreferredName(), this.nNeighbors);
        }
        if (this.method != null) {
            builder.field(METHOD.getPreferredName(), (Object)this.method);
        }
        if (this.featureInfluenceThreshold != null) {
            builder.field(FEATURE_INFLUENCE_THRESHOLD.getPreferredName(), this.featureInfluenceThreshold);
        }
        if (this.computeFeatureInfluence != null) {
            builder.field(COMPUTE_FEATURE_INFLUENCE.getPreferredName(), this.computeFeatureInfluence);
        }
        if (this.outlierFraction != null) {
            builder.field(OUTLIER_FRACTION.getPreferredName(), this.outlierFraction);
        }
        if (this.standardizationEnabled != null) {
            builder.field(STANDARDIZATION_ENABLED.getPreferredName(), this.standardizationEnabled);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutlierDetection other = (OutlierDetection)o;
        return Objects.equals(this.nNeighbors, other.nNeighbors) && Objects.equals((Object)this.method, (Object)other.method) && Objects.equals(this.featureInfluenceThreshold, other.featureInfluenceThreshold) && Objects.equals(this.computeFeatureInfluence, other.computeFeatureInfluence) && Objects.equals(this.outlierFraction, other.outlierFraction) && Objects.equals(this.standardizationEnabled, other.standardizationEnabled);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.nNeighbors, this.method, this.featureInfluenceThreshold, this.computeFeatureInfluence, this.outlierFraction, this.standardizationEnabled});
    }

    public String toString() {
        return Strings.toString(this);
    }

    static {
        PARSER.declareInt(Builder::setNNeighbors, N_NEIGHBORS);
        PARSER.declareField(Builder::setMethod, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return Method.fromString(p.text());
            }
            throw new IllegalArgumentException("Unsupported token [" + (Object)((Object)p.currentToken()) + "]");
        }, METHOD, ObjectParser.ValueType.STRING);
        PARSER.declareDouble(Builder::setFeatureInfluenceThreshold, FEATURE_INFLUENCE_THRESHOLD);
        PARSER.declareBoolean(Builder::setComputeFeatureInfluence, COMPUTE_FEATURE_INFLUENCE);
        PARSER.declareDouble(Builder::setOutlierFraction, OUTLIER_FRACTION);
        PARSER.declareBoolean(Builder::setStandardizationEnabled, STANDARDIZATION_ENABLED);
    }

    public static class Builder {
        private Integer nNeighbors;
        private Method method;
        private Double featureInfluenceThreshold;
        private Boolean computeFeatureInfluence;
        private Double outlierFraction;
        private Boolean standardizationEnabled;

        private Builder() {
        }

        public Builder setNNeighbors(Integer nNeighbors) {
            this.nNeighbors = nNeighbors;
            return this;
        }

        public Builder setMethod(Method method) {
            this.method = method;
            return this;
        }

        public Builder setFeatureInfluenceThreshold(Double featureInfluenceThreshold) {
            this.featureInfluenceThreshold = featureInfluenceThreshold;
            return this;
        }

        public Builder setComputeFeatureInfluence(Boolean computeFeatureInfluence) {
            this.computeFeatureInfluence = computeFeatureInfluence;
            return this;
        }

        public Builder setOutlierFraction(Double outlierFraction) {
            this.outlierFraction = outlierFraction;
            return this;
        }

        public Builder setStandardizationEnabled(Boolean standardizationEnabled) {
            this.standardizationEnabled = standardizationEnabled;
            return this;
        }

        public OutlierDetection build() {
            return new OutlierDetection(this.nNeighbors, this.method, this.featureInfluenceThreshold, this.computeFeatureInfluence, this.outlierFraction, this.standardizationEnabled);
        }
    }

    public static enum Method {
        LOF,
        LDOF,
        DISTANCE_KTH_NN,
        DISTANCE_KNN;


        public static Method fromString(String value) {
            return Method.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

