/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.inference.trainedmodel.tree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.client.ml.inference.trainedmodel.TargetType;
import org.elasticsearch.client.ml.inference.trainedmodel.TrainedModel;
import org.elasticsearch.client.ml.inference.trainedmodel.tree.TreeNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class Tree
implements TrainedModel {
    public static final String NAME = "tree";
    public static final ParseField FEATURE_NAMES = new ParseField("feature_names", new String[0]);
    public static final ParseField TREE_STRUCTURE = new ParseField("tree_structure", new String[0]);
    public static final ParseField TARGET_TYPE = new ParseField("target_type", new String[0]);
    public static final ParseField CLASSIFICATION_LABELS = new ParseField("classification_labels", new String[0]);
    private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("tree", true, Builder::new);
    private final List<String> featureNames;
    private final List<TreeNode> nodes;
    private final TargetType targetType;
    private final List<String> classificationLabels;

    public static Tree fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null).build();
    }

    Tree(List<String> featureNames, List<TreeNode> nodes, TargetType targetType, List<String> classificationLabels) {
        this.featureNames = featureNames;
        this.nodes = nodes;
        this.targetType = targetType;
        this.classificationLabels = classificationLabels;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public List<String> getFeatureNames() {
        return this.featureNames;
    }

    public List<TreeNode> getNodes() {
        return this.nodes;
    }

    @Nullable
    public List<String> getClassificationLabels() {
        return this.classificationLabels;
    }

    public TargetType getTargetType() {
        return this.targetType;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.featureNames != null) {
            builder.field(FEATURE_NAMES.getPreferredName(), this.featureNames);
        }
        if (this.nodes != null) {
            builder.field(TREE_STRUCTURE.getPreferredName(), this.nodes);
        }
        if (this.classificationLabels != null) {
            builder.field(CLASSIFICATION_LABELS.getPreferredName(), this.classificationLabels);
        }
        if (this.targetType != null) {
            builder.field(TARGET_TYPE.getPreferredName(), this.targetType.toString());
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tree that = (Tree)o;
        return Objects.equals(this.featureNames, that.featureNames) && Objects.equals(this.classificationLabels, that.classificationLabels) && Objects.equals((Object)this.targetType, (Object)that.targetType) && Objects.equals(this.nodes, that.nodes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.featureNames, this.nodes, this.targetType, this.classificationLabels});
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        PARSER.declareStringArray(Builder::setFeatureNames, FEATURE_NAMES);
        PARSER.declareObjectArray(Builder::setNodes, (p, c) -> TreeNode.fromXContent(p), TREE_STRUCTURE);
        PARSER.declareString((rec$, x$0) -> ((Builder)rec$).setTargetType(x$0), TARGET_TYPE);
        PARSER.declareStringArray(Builder::setClassificationLabels, CLASSIFICATION_LABELS);
    }

    public static class Builder {
        private List<String> featureNames;
        private ArrayList<TreeNode.Builder> nodes = new ArrayList();
        private int numNodes;
        private TargetType targetType;
        private List<String> classificationLabels;

        public Builder() {
            this.nodes.add(null);
            this.addLeaf(0, 0.0);
            this.numNodes = 1;
        }

        public Builder setFeatureNames(List<String> featureNames) {
            this.featureNames = featureNames;
            return this;
        }

        public Builder addNode(TreeNode.Builder node) {
            this.nodes.add(node);
            return this;
        }

        public Builder setNodes(List<TreeNode.Builder> nodes) {
            this.nodes = new ArrayList<TreeNode.Builder>(nodes);
            return this;
        }

        public Builder setNodes(TreeNode.Builder ... nodes) {
            return this.setNodes(Arrays.asList(nodes));
        }

        public Builder setTargetType(TargetType targetType) {
            this.targetType = targetType;
            return this;
        }

        public Builder setClassificationLabels(List<String> classificationLabels) {
            this.classificationLabels = classificationLabels;
            return this;
        }

        private void setTargetType(String targetType) {
            this.targetType = TargetType.fromString(targetType);
        }

        public TreeNode.Builder addJunction(int nodeIndex, int featureIndex, boolean isDefaultLeft, double decisionThreshold) {
            int leftChild = this.numNodes++;
            int rightChild = this.numNodes++;
            this.nodes.ensureCapacity(nodeIndex + 1);
            for (int i = this.nodes.size(); i < nodeIndex + 1; ++i) {
                this.nodes.add(null);
            }
            TreeNode.Builder node = TreeNode.builder(nodeIndex).setDefaultLeft(isDefaultLeft).setLeftChild(leftChild).setRightChild(rightChild).setSplitFeature(featureIndex).setThreshold(decisionThreshold);
            this.nodes.set(nodeIndex, node);
            while (this.nodes.size() <= rightChild) {
                this.nodes.add(null);
            }
            return node;
        }

        public Builder addLeaf(int nodeIndex, double value) {
            for (int i = this.nodes.size(); i < nodeIndex + 1; ++i) {
                this.nodes.add(null);
            }
            this.nodes.set(nodeIndex, TreeNode.builder(nodeIndex).setLeafValue(value));
            return this;
        }

        public Tree build() {
            return new Tree(this.featureNames, this.nodes.stream().map(TreeNode.Builder::build).collect(Collectors.toList()), this.targetType, this.classificationLabels);
        }
    }
}

