/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security.user.privileges;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.client.security.user.privileges.ApplicationResourcePrivileges;
import org.elasticsearch.client.security.user.privileges.GlobalPrivileges;
import org.elasticsearch.client.security.user.privileges.IndicesPrivileges;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;

public final class Role {
    public static final ParseField CLUSTER = new ParseField("cluster", new String[0]);
    public static final ParseField GLOBAL = new ParseField("global", new String[0]);
    public static final ParseField INDICES = new ParseField("indices", new String[0]);
    public static final ParseField APPLICATIONS = new ParseField("applications", new String[0]);
    public static final ParseField RUN_AS = new ParseField("run_as", new String[0]);
    public static final ParseField METADATA = new ParseField("metadata", new String[0]);
    public static final ParseField TRANSIENT_METADATA = new ParseField("transient_metadata", new String[0]);
    public static final ConstructingObjectParser<Tuple<Role, Map<String, Object>>, String> PARSER = new ConstructingObjectParser<Tuple, String>("role_descriptor", false, (constructorObjects, roleName) -> {
        int i = 0;
        Collection clusterPrivileges = (Collection)constructorObjects[i++];
        GlobalPrivileges globalApplicationPrivileges = (GlobalPrivileges)constructorObjects[i++];
        Collection indicesPrivileges = (Collection)constructorObjects[i++];
        Collection applicationResourcePrivileges = (Collection)constructorObjects[i++];
        Collection runAsPrivilege = (Collection)constructorObjects[i++];
        Map metadata = (Map)constructorObjects[i++];
        Map transientMetadata = (Map)constructorObjects[i];
        return new Tuple(new Role((String)roleName, clusterPrivileges, globalApplicationPrivileges, indicesPrivileges, applicationResourcePrivileges, runAsPrivilege, metadata), transientMetadata != null ? Collections.unmodifiableMap(transientMetadata) : Collections.emptyMap());
    });
    private final String name;
    private final Set<String> clusterPrivileges;
    @Nullable
    private final GlobalPrivileges globalPrivileges;
    private final Set<IndicesPrivileges> indicesPrivileges;
    private final Set<ApplicationResourcePrivileges> applicationPrivileges;
    private final Set<String> runAsPrivilege;
    private final Map<String, Object> metadata;

    private Role(String name, @Nullable Collection<String> clusterPrivileges, @Nullable GlobalPrivileges globalPrivileges, @Nullable Collection<IndicesPrivileges> indicesPrivileges, @Nullable Collection<ApplicationResourcePrivileges> applicationPrivileges, @Nullable Collection<String> runAsPrivilege, @Nullable Map<String, Object> metadata) {
        if (!Strings.hasText(name)) {
            throw new IllegalArgumentException("role name must be provided");
        }
        this.name = name;
        this.clusterPrivileges = Collections.unmodifiableSet(clusterPrivileges != null ? new HashSet<String>(clusterPrivileges) : Collections.emptySet());
        this.globalPrivileges = globalPrivileges;
        this.indicesPrivileges = Collections.unmodifiableSet(indicesPrivileges != null ? new HashSet<IndicesPrivileges>(indicesPrivileges) : Collections.emptySet());
        this.applicationPrivileges = Collections.unmodifiableSet(applicationPrivileges != null ? new HashSet<ApplicationResourcePrivileges>(applicationPrivileges) : Collections.emptySet());
        this.runAsPrivilege = Collections.unmodifiableSet(runAsPrivilege != null ? new HashSet<String>(runAsPrivilege) : Collections.emptySet());
        this.metadata = metadata != null ? Collections.unmodifiableMap(metadata) : Collections.emptyMap();
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getClusterPrivileges() {
        return this.clusterPrivileges;
    }

    public GlobalPrivileges getGlobalPrivileges() {
        return this.globalPrivileges;
    }

    public Set<IndicesPrivileges> getIndicesPrivileges() {
        return this.indicesPrivileges;
    }

    public Set<ApplicationResourcePrivileges> getApplicationPrivileges() {
        return this.applicationPrivileges;
    }

    public Set<String> getRunAsPrivilege() {
        return this.runAsPrivilege;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Role that = (Role)o;
        return this.name.equals(that.name) && this.clusterPrivileges.equals(that.clusterPrivileges) && Objects.equals(this.globalPrivileges, that.globalPrivileges) && this.indicesPrivileges.equals(that.indicesPrivileges) && this.applicationPrivileges.equals(that.applicationPrivileges) && this.runAsPrivilege.equals(that.runAsPrivilege) && this.metadata.equals(that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.clusterPrivileges, this.globalPrivileges, this.indicesPrivileges, this.applicationPrivileges, this.runAsPrivilege, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("Name=").append(this.name).append(",");
        if (!this.clusterPrivileges.isEmpty()) {
            sb.append("ClusterPrivileges=");
            sb.append(this.clusterPrivileges.toString());
            sb.append(", ");
        }
        if (this.globalPrivileges != null) {
            sb.append("GlobalPrivileges=");
            sb.append(this.globalPrivileges.toString());
            sb.append(", ");
        }
        if (!this.indicesPrivileges.isEmpty()) {
            sb.append("IndicesPrivileges=");
            sb.append(this.indicesPrivileges.toString());
            sb.append(", ");
        }
        if (!this.applicationPrivileges.isEmpty()) {
            sb.append("ApplicationPrivileges=");
            sb.append(this.applicationPrivileges.toString());
            sb.append(", ");
        }
        if (!this.runAsPrivilege.isEmpty()) {
            sb.append("RunAsPrivilege=");
            sb.append(this.runAsPrivilege.toString());
            sb.append(", ");
        }
        if (!this.metadata.isEmpty()) {
            sb.append("Metadata=[");
            sb.append(this.metadata.toString());
            sb.append("], ");
        }
        sb.append("}");
        return sb.toString();
    }

    public static Tuple<Role, Map<String, Object>> fromXContent(XContentParser parser, String name) {
        return PARSER.apply(parser, name);
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), CLUSTER);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (parser, c) -> GlobalPrivileges.PARSER.parse(parser, null), GLOBAL);
        PARSER.declareFieldArray(ConstructingObjectParser.optionalConstructorArg(), (parser, c) -> IndicesPrivileges.PARSER.parse(parser, null), INDICES, ObjectParser.ValueType.OBJECT_ARRAY);
        PARSER.declareFieldArray(ConstructingObjectParser.optionalConstructorArg(), (parser, c) -> ApplicationResourcePrivileges.PARSER.parse(parser, null), APPLICATIONS, ObjectParser.ValueType.OBJECT_ARRAY);
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), RUN_AS);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (parser, c) -> parser.map(), METADATA);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (parser, c) -> parser.map(), TRANSIENT_METADATA);
    }

    public static class IndexPrivilegeName {
        public static final String NONE = "none";
        public static final String ALL = "all";
        public static final String READ = "read";
        public static final String READ_CROSS = "read_cross_cluster";
        public static final String CREATE = "create";
        public static final String INDEX = "index";
        public static final String DELETE = "delete";
        public static final String WRITE = "write";
        public static final String MONITOR = "monitor";
        public static final String MANAGE = "manage";
        public static final String DELETE_INDEX = "delete_index";
        public static final String CREATE_INDEX = "create_index";
        public static final String VIEW_INDEX_METADATA = "view_index_metadata";
        public static final String MANAGE_FOLLOW_INDEX = "manage_follow_index";
        public static final String MANAGE_ILM = "manage_ilm";
        public static final String CREATE_DOC = "create_doc";
        public static final String[] ALL_ARRAY = new String[]{"none", "all", "read", "read_cross_cluster", "create", "index", "delete", "write", "monitor", "manage", "delete_index", "create_index", "view_index_metadata", "manage_follow_index", "manage_ilm", "create_doc"};
    }

    public static class ClusterPrivilegeName {
        public static final String NONE = "none";
        public static final String ALL = "all";
        public static final String MONITOR = "monitor";
        public static final String MONITOR_TRANSFORM_DEPRECATED = "monitor_data_frame_transforms";
        public static final String MONITOR_TRANSFORM = "monitor_transform";
        public static final String MONITOR_ML = "monitor_ml";
        public static final String MONITOR_WATCHER = "monitor_watcher";
        public static final String MONITOR_ROLLUP = "monitor_rollup";
        public static final String MANAGE = "manage";
        public static final String MANAGE_TRANSFORM_DEPRECATED = "manage_data_frame_transforms";
        public static final String MANAGE_TRANSFORM = "manage_transform";
        public static final String MANAGE_ML = "manage_ml";
        public static final String MANAGE_WATCHER = "manage_watcher";
        public static final String MANAGE_ROLLUP = "manage_rollup";
        public static final String MANAGE_INDEX_TEMPLATES = "manage_index_templates";
        public static final String MANAGE_INGEST_PIPELINES = "manage_ingest_pipelines";
        public static final String TRANSPORT_CLIENT = "transport_client";
        public static final String MANAGE_SECURITY = "manage_security";
        public static final String MANAGE_SAML = "manage_saml";
        public static final String MANAGE_OIDC = "manage_oidc";
        public static final String MANAGE_TOKEN = "manage_token";
        public static final String MANAGE_PIPELINE = "manage_pipeline";
        public static final String MANAGE_CCR = "manage_ccr";
        public static final String READ_CCR = "read_ccr";
        public static final String MANAGE_ILM = "manage_ilm";
        public static final String READ_ILM = "read_ilm";
        public static final String MANAGE_ENRICH = "manage_enrich";
        public static final String[] ALL_ARRAY = new String[]{"none", "all", "monitor", "monitor_data_frame_transforms", "monitor_transform", "monitor_ml", "monitor_watcher", "monitor_rollup", "manage", "manage_data_frame_transforms", "manage_transform", "manage_ml", "manage_watcher", "manage_rollup", "manage_index_templates", "manage_ingest_pipelines", "transport_client", "manage_security", "manage_saml", "manage_oidc", "manage_token", "manage_pipeline", "manage_ccr", "read_ccr", "manage_ilm", "read_ilm", "manage_enrich"};
    }

    public static final class Builder {
        @Nullable
        private String name = null;
        @Nullable
        private Collection<String> clusterPrivileges = null;
        @Nullable
        private GlobalPrivileges globalApplicationPrivileges = null;
        @Nullable
        private Collection<IndicesPrivileges> indicesPrivileges = null;
        @Nullable
        private Collection<ApplicationResourcePrivileges> applicationResourcePrivileges = null;
        @Nullable
        private Collection<String> runAsPrivilege = null;
        @Nullable
        private Map<String, Object> metadata = null;

        private Builder() {
        }

        public Builder name(String name) {
            if (!Strings.hasText(name)) {
                throw new IllegalArgumentException("role name must be provided");
            }
            this.name = name;
            return this;
        }

        public Builder clusterPrivileges(String ... clusterPrivileges) {
            return this.clusterPrivileges(Arrays.asList(Objects.requireNonNull(clusterPrivileges, "Cluster privileges cannot be null. Pass an empty array instead.")));
        }

        public Builder clusterPrivileges(Collection<String> clusterPrivileges) {
            this.clusterPrivileges = Objects.requireNonNull(clusterPrivileges, "Cluster privileges cannot be null. Pass an empty collection instead.");
            return this;
        }

        public Builder globalApplicationPrivileges(GlobalPrivileges globalApplicationPrivileges) {
            this.globalApplicationPrivileges = globalApplicationPrivileges;
            return this;
        }

        public Builder indicesPrivileges(IndicesPrivileges ... indicesPrivileges) {
            return this.indicesPrivileges(Arrays.asList(Objects.requireNonNull(indicesPrivileges, "Indices privileges cannot be null. Pass an empty array instead.")));
        }

        public Builder indicesPrivileges(Collection<IndicesPrivileges> indicesPrivileges) {
            this.indicesPrivileges = Objects.requireNonNull(indicesPrivileges, "Indices privileges cannot be null. Pass an empty collection instead.");
            return this;
        }

        public Builder applicationResourcePrivileges(ApplicationResourcePrivileges ... applicationResourcePrivileges) {
            return this.applicationResourcePrivileges(Arrays.asList(Objects.requireNonNull(applicationResourcePrivileges, "Application resource privileges cannot be null. Pass an empty array instead.")));
        }

        public Builder applicationResourcePrivileges(Collection<ApplicationResourcePrivileges> applicationResourcePrivileges) {
            this.applicationResourcePrivileges = Objects.requireNonNull(applicationResourcePrivileges, "Application resource privileges cannot be null. Pass an empty collection instead.");
            return this;
        }

        public Builder runAsPrivilege(String ... runAsPrivilege) {
            return this.runAsPrivilege(Arrays.asList(Objects.requireNonNull(runAsPrivilege, "Run as privilege cannot be null. Pass an empty array instead.")));
        }

        public Builder runAsPrivilege(Collection<String> runAsPrivilege) {
            this.runAsPrivilege = Objects.requireNonNull(runAsPrivilege, "Run as privilege cannot be null. Pass an empty collection instead.");
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = Objects.requireNonNull(metadata, "Metadata cannot be null. Pass an empty map instead.");
            return this;
        }

        public Role build() {
            return new Role(this.name, this.clusterPrivileges, this.globalApplicationPrivileges, this.indicesPrivileges, this.applicationResourcePrivileges, this.runAsPrivilege, this.metadata);
        }
    }
}

