/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.watcher;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.client.watcher.ExecutionPhase;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.joda.time.DateTime;

public class WatchExecutionSnapshot {
    public static final ConstructingObjectParser<WatchExecutionSnapshot, Void> PARSER = new ConstructingObjectParser<WatchExecutionSnapshot, Void>("watcher_stats_node", true, (args, c) -> new WatchExecutionSnapshot((String)args[0], (String)args[1], DateTime.parse((String)args[2]), DateTime.parse((String)args[3]), ExecutionPhase.valueOf(((String)args[4]).toUpperCase(Locale.ROOT)), args[5] == null ? null : ((List)args[5]).toArray(new String[0]), args[6] == null ? null : ((List)args[6]).toArray(new String[0])));
    private final String watchId;
    private final String watchRecordId;
    private final DateTime triggeredTime;
    private final DateTime executionTime;
    private final ExecutionPhase phase;
    private final String[] executedActions;
    private final String[] executionStackTrace;

    public WatchExecutionSnapshot(String watchId, String watchRecordId, DateTime triggeredTime, DateTime executionTime, ExecutionPhase phase, String[] executedActions, String[] executionStackTrace) {
        this.watchId = watchId;
        this.watchRecordId = watchRecordId;
        this.triggeredTime = triggeredTime;
        this.executionTime = executionTime;
        this.phase = phase;
        this.executedActions = executedActions;
        this.executionStackTrace = executionStackTrace;
    }

    public String getWatchId() {
        return this.watchId;
    }

    public String getWatchRecordId() {
        return this.watchRecordId;
    }

    public DateTime getTriggeredTime() {
        return this.triggeredTime;
    }

    public DateTime getExecutionTime() {
        return this.executionTime;
    }

    public ExecutionPhase getPhase() {
        return this.phase;
    }

    public String[] getExecutedActions() {
        return this.executedActions;
    }

    public String[] getExecutionStackTrace() {
        return this.executionStackTrace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatchExecutionSnapshot that = (WatchExecutionSnapshot)o;
        return Objects.equals(this.watchId, that.watchId) && Objects.equals(this.watchRecordId, that.watchRecordId) && Objects.equals(this.triggeredTime, that.triggeredTime) && Objects.equals(this.executionTime, that.executionTime) && this.phase == that.phase && Arrays.equals(this.executedActions, that.executedActions) && Arrays.equals(this.executionStackTrace, that.executionStackTrace);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.watchId, this.watchRecordId, this.triggeredTime, this.executionTime, this.phase});
        result = 31 * result + Arrays.hashCode(this.executedActions);
        result = 31 * result + Arrays.hashCode(this.executionStackTrace);
        return result;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("watch_id", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("watch_record_id", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("triggered_time", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("execution_time", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("execution_phase", new String[0]));
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), new ParseField("executed_actions", new String[0]));
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), new ParseField("stack_trace", new String[0]));
    }
}

