/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.elasticsearch.index.analysis.FieldNameAnalyzer;
import org.elasticsearch.index.mapper.FieldAliasMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;

public final class DocumentFieldMappers
implements Iterable<Mapper> {
    private final Map<String, Mapper> fieldMappers;
    private final FieldNameAnalyzer indexAnalyzer;

    private static void put(Map<String, Analyzer> analyzers, String key, Analyzer value, Analyzer defaultValue) {
        if (value == null) {
            value = defaultValue;
        }
        analyzers.put(key, value);
    }

    public DocumentFieldMappers(Collection<FieldMapper> mappers, Collection<FieldAliasMapper> aliasMappers, Analyzer defaultIndex, Analyzer defaultSearch, Analyzer defaultSearchQuote) {
        HashMap<String, Mapper> fieldMappers = new HashMap<String, Mapper>();
        HashMap<String, Analyzer> indexAnalyzers = new HashMap<String, Analyzer>();
        HashMap<String, Analyzer> searchAnalyzers = new HashMap<String, Analyzer>();
        HashMap<String, Analyzer> searchQuoteAnalyzers = new HashMap<String, Analyzer>();
        for (FieldMapper mapper : mappers) {
            fieldMappers.put(mapper.name(), mapper);
            MappedFieldType fieldType = mapper.fieldType();
            DocumentFieldMappers.put(indexAnalyzers, fieldType.name(), fieldType.indexAnalyzer(), defaultIndex);
            DocumentFieldMappers.put(searchAnalyzers, fieldType.name(), fieldType.searchAnalyzer(), defaultSearch);
            DocumentFieldMappers.put(searchQuoteAnalyzers, fieldType.name(), fieldType.searchQuoteAnalyzer(), defaultSearchQuote);
        }
        for (FieldAliasMapper aliasMapper : aliasMappers) {
            fieldMappers.put(aliasMapper.name(), aliasMapper);
        }
        this.fieldMappers = Collections.unmodifiableMap(fieldMappers);
        this.indexAnalyzer = new FieldNameAnalyzer(indexAnalyzers);
    }

    public Mapper getMapper(String field) {
        return this.fieldMappers.get(field);
    }

    public Analyzer indexAnalyzer() {
        return this.indexAnalyzer;
    }

    @Override
    public Iterator<Mapper> iterator() {
        return this.fieldMappers.values().iterator();
    }
}

