/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.document.FeatureField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.query.QueryShardContext;

public class RankFeatureFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "rank_feature";

    private RankFeatureFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        assert (fieldType.indexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) <= 0);
    }

    @Override
    protected RankFeatureFieldMapper clone() {
        return (RankFeatureFieldMapper)super.clone();
    }

    @Override
    public RankFeatureFieldType fieldType() {
        return (RankFeatureFieldType)super.fieldType();
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        float value;
        if (context.externalValueSet()) {
            Object v = context.externalValue();
            value = v instanceof Number ? ((Number)v).floatValue() : Float.parseFloat(v.toString());
        } else {
            if (context.parser().currentToken() == XContentParser.Token.VALUE_NULL) {
                return;
            }
            value = context.parser().floatValue();
        }
        if (context.doc().getByKey(this.name()) != null) {
            throw new IllegalArgumentException("[rank_feature] fields do not support indexing multiple values for the same field [" + this.name() + "] in the same document");
        }
        if (!this.fieldType().positiveScoreImpact()) {
            value = 1.0f / value;
        }
        context.doc().addWithKey(this.name(), new FeatureField("_feature", this.name(), value));
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || !this.fieldType().positiveScoreImpact()) {
            builder.field("positive_score_impact", this.fieldType().positiveScoreImpact());
        }
    }

    public static final class RankFeatureFieldType
    extends MappedFieldType {
        private boolean positiveScoreImpact = true;

        public RankFeatureFieldType() {
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            this.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
        }

        protected RankFeatureFieldType(RankFeatureFieldType ref) {
            super(ref);
            this.positiveScoreImpact = ref.positiveScoreImpact;
        }

        @Override
        public RankFeatureFieldType clone() {
            return new RankFeatureFieldType(this);
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            RankFeatureFieldType other = (RankFeatureFieldType)o;
            return Objects.equals(this.positiveScoreImpact, other.positiveScoreImpact);
        }

        @Override
        public int hashCode() {
            int h = super.hashCode();
            h = 31 * h + Objects.hashCode(this.positiveScoreImpact);
            return h;
        }

        @Override
        public void checkCompatibility(MappedFieldType other, List<String> conflicts) {
            super.checkCompatibility(other, conflicts);
            if (this.positiveScoreImpact != ((RankFeatureFieldType)other).positiveScoreImpact()) {
                conflicts.add("mapper [" + this.name() + "] has different [positive_score_impact] values");
            }
        }

        @Override
        public String typeName() {
            return RankFeatureFieldMapper.CONTENT_TYPE;
        }

        public boolean positiveScoreImpact() {
            return this.positiveScoreImpact;
        }

        public void setPositiveScoreImpact(boolean positiveScoreImpact) {
            this.checkIfFrozen();
            this.positiveScoreImpact = positiveScoreImpact;
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            return new TermQuery(new Term("_feature", this.name()));
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            throw new IllegalArgumentException("[rank_feature] fields do not support sorting, scripting or aggregating");
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            throw new IllegalArgumentException("Queries on [rank_feature] fields are not supported");
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (!propName.equals("positive_score_impact")) continue;
                builder.positiveScoreImpact(XContentMapValues.nodeBooleanValue(propNode));
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, RankFeatureFieldMapper> {
        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        @Override
        public RankFeatureFieldType fieldType() {
            return (RankFeatureFieldType)super.fieldType();
        }

        public Builder positiveScoreImpact(boolean v) {
            this.fieldType().setPositiveScoreImpact(v);
            return (Builder)this.builder;
        }

        @Override
        public RankFeatureFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            return new RankFeatureFieldMapper(this.name, this.fieldType, this.defaultFieldType, context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }

    public static class Defaults {
        public static final MappedFieldType FIELD_TYPE = new RankFeatureFieldType();

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.setHasDocValues(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }
}

