/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenFilter;
import org.apache.lucene.analysis.shingle.FixedShingleFilter;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.NormsFieldExistsQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.FieldMaskingSpanQuery;
import org.apache.lucene.search.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextFieldMapper;
import org.elasticsearch.index.mapper.TypeParsers;
import org.elasticsearch.index.query.QueryShardContext;

public class SearchAsYouTypeFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "search_as_you_type";
    private static final int MAX_SHINGLE_SIZE_LOWER_BOUND = 2;
    private static final int MAX_SHINGLE_SIZE_UPPER_BOUND = 4;
    private static final String PREFIX_FIELD_SUFFIX = "._index_prefix";
    private final int maxShingleSize;
    private PrefixFieldMapper prefixField;
    private final ShingleFieldMapper[] shingleFields;

    private static int countPosition(TokenStream stream) throws IOException {
        assert (stream instanceof CachingTokenFilter);
        PositionIncrementAttribute posIncAtt = stream.getAttribute(PositionIncrementAttribute.class);
        stream.reset();
        int positionCount = 0;
        while (stream.incrementToken()) {
            if (posIncAtt.getPositionIncrement() == 0) continue;
            positionCount += posIncAtt.getPositionIncrement();
        }
        return positionCount;
    }

    public SearchAsYouTypeFieldMapper(String simpleName, SearchAsYouTypeFieldType fieldType, Settings indexSettings, FieldMapper.CopyTo copyTo, int maxShingleSize, PrefixFieldMapper prefixField, ShingleFieldMapper[] shingleFields) {
        super(simpleName, fieldType, Defaults.FIELD_TYPE, indexSettings, FieldMapper.MultiFields.empty(), copyTo);
        this.prefixField = prefixField;
        this.shingleFields = shingleFields;
        this.maxShingleSize = maxShingleSize;
    }

    @Override
    public FieldMapper updateFieldType(Map<String, MappedFieldType> fullNameToFieldType) {
        SearchAsYouTypeFieldMapper fieldMapper = (SearchAsYouTypeFieldMapper)super.updateFieldType((Map)fullNameToFieldType);
        fieldMapper.prefixField = (PrefixFieldMapper)fieldMapper.prefixField.updateFieldType((Map)fullNameToFieldType);
        for (int i = 0; i < fieldMapper.shingleFields.length; ++i) {
            fieldMapper.shingleFields[i] = (ShingleFieldMapper)fieldMapper.shingleFields[i].updateFieldType((Map)fullNameToFieldType);
        }
        return fieldMapper;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        String value;
        String string = value = context.externalValueSet() ? context.externalValue().toString() : context.parser().textOrNull();
        if (value == null) {
            return;
        }
        ArrayList<IndexableField> newFields = new ArrayList<IndexableField>();
        newFields.add(new Field(this.fieldType().name(), value, (IndexableFieldType)this.fieldType()));
        for (ShingleFieldMapper subFieldMapper : this.shingleFields) {
            fields.add(new Field(subFieldMapper.fieldType().name(), value, (IndexableFieldType)subFieldMapper.fieldType()));
        }
        newFields.add(new Field(this.prefixField.fieldType().name(), value, (IndexableFieldType)this.prefixField.fieldType()));
        if (this.fieldType().omitNorms()) {
            this.createFieldNamesField(context, newFields);
        }
        fields.addAll(newFields);
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void doMerge(Mapper mergeWith) {
        super.doMerge(mergeWith);
        SearchAsYouTypeFieldMapper mw = (SearchAsYouTypeFieldMapper)mergeWith;
        if (mw.maxShingleSize != this.maxShingleSize) {
            throw new IllegalArgumentException("mapper [" + this.name() + "] has different [max_shingle_size] setting, current [" + this.maxShingleSize + "], merged [" + mw.maxShingleSize + "]");
        }
        this.prefixField = (PrefixFieldMapper)this.prefixField.merge(mw.prefixField);
        ShingleFieldMapper[] shingleFieldMappers = new ShingleFieldMapper[mw.shingleFields.length];
        for (int i = 0; i < shingleFieldMappers.length; ++i) {
            this.shingleFields[i] = (ShingleFieldMapper)this.shingleFields[i].merge(mw.shingleFields[i]);
        }
    }

    public static String getShingleFieldName(String parentField, int shingleSize) {
        return parentField + "._" + shingleSize + "gram";
    }

    @Override
    public SearchAsYouTypeFieldType fieldType() {
        return (SearchAsYouTypeFieldType)super.fieldType();
    }

    public int maxShingleSize() {
        return this.maxShingleSize;
    }

    public PrefixFieldMapper prefixField() {
        return this.prefixField;
    }

    public ShingleFieldMapper[] shingleFields() {
        return this.shingleFields;
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        this.doXContentAnalyzers(builder, includeDefaults);
        builder.field("max_shingle_size", this.maxShingleSize);
    }

    @Override
    public Iterator<Mapper> iterator() {
        ArrayList<FieldMapper> subIterators = new ArrayList<FieldMapper>();
        subIterators.add(this.prefixField);
        subIterators.addAll(Arrays.asList(this.shingleFields));
        Iterator<Mapper> concat = Iterators.concat(super.iterator(), subIterators.iterator());
        return concat;
    }

    static class SearchAsYouTypeAnalyzer
    extends AnalyzerWrapper {
        private final Analyzer delegate;
        private final int shingleSize;
        private final boolean indexPrefixes;

        private SearchAsYouTypeAnalyzer(Analyzer delegate, int shingleSize, boolean indexPrefixes) {
            super(delegate.getReuseStrategy());
            this.delegate = Objects.requireNonNull(delegate);
            this.shingleSize = shingleSize;
            this.indexPrefixes = indexPrefixes;
        }

        static SearchAsYouTypeAnalyzer withShingle(Analyzer delegate, int shingleSize) {
            return new SearchAsYouTypeAnalyzer(delegate, shingleSize, false);
        }

        static SearchAsYouTypeAnalyzer withShingleAndPrefix(Analyzer delegate, int shingleSize) {
            return new SearchAsYouTypeAnalyzer(delegate, shingleSize, true);
        }

        @Override
        protected Analyzer getWrappedAnalyzer(String fieldName) {
            return this.delegate;
        }

        @Override
        protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
            TokenStream tokenStream = components.getTokenStream();
            if (this.indexPrefixes) {
                tokenStream = new TrailingShingleTokenFilter(tokenStream, this.shingleSize - 1);
            }
            tokenStream = new FixedShingleFilter(tokenStream, this.shingleSize, " ", "");
            if (this.indexPrefixes) {
                tokenStream = new EdgeNGramTokenFilter(tokenStream, 1, 20, true);
            }
            return new Analyzer.TokenStreamComponents(components.getSource(), tokenStream);
        }

        public int shingleSize() {
            return this.shingleSize;
        }

        public boolean indexPrefixes() {
            return this.indexPrefixes;
        }

        public String toString() {
            return "<" + this.getClass().getCanonicalName() + " shingleSize=[" + this.shingleSize + "] indexPrefixes=[" + this.indexPrefixes + "]>";
        }

        private static class TrailingShingleTokenFilter
        extends TokenFilter {
            private final int extraPositionIncrements;
            private final PositionIncrementAttribute positionIncrementAttribute;

            TrailingShingleTokenFilter(TokenStream input, int extraPositionIncrements) {
                super(input);
                this.extraPositionIncrements = extraPositionIncrements;
                this.positionIncrementAttribute = this.addAttribute(PositionIncrementAttribute.class);
            }

            @Override
            public boolean incrementToken() throws IOException {
                return this.input.incrementToken();
            }

            @Override
            public void end() throws IOException {
                super.end();
                this.positionIncrementAttribute.setPositionIncrement(this.extraPositionIncrements);
            }
        }
    }

    static class ShingleFieldType
    extends StringFieldType {
        final int shingleSize;
        PrefixFieldType prefixFieldType;

        ShingleFieldType(MappedFieldType other, int shingleSize) {
            super(other);
            this.shingleSize = shingleSize;
            this.setStored(false);
        }

        ShingleFieldType(ShingleFieldType other) {
            super(other);
            this.shingleSize = other.shingleSize;
            if (other.prefixFieldType != null) {
                this.prefixFieldType = other.prefixFieldType.clone();
            }
        }

        void setPrefixFieldType(PrefixFieldType prefixFieldType) {
            this.checkIfFrozen();
            this.prefixFieldType = prefixFieldType;
        }

        @Override
        public ShingleFieldType clone() {
            return new ShingleFieldType(this);
        }

        @Override
        public String typeName() {
            return SearchAsYouTypeFieldMapper.CONTENT_TYPE;
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            if (this.omitNorms()) {
                return new TermQuery(new Term("_field_names", this.name()));
            }
            return new NormsFieldExistsQuery(this.name());
        }

        @Override
        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, QueryShardContext context) {
            if (this.prefixFieldType == null || !this.prefixFieldType.termLengthWithinBounds(value.length())) {
                return super.prefixQuery(value, method, context);
            }
            Query query = this.prefixFieldType.prefixQuery(value, method, context);
            if (method == null || method == MultiTermQuery.CONSTANT_SCORE_REWRITE || method == MultiTermQuery.CONSTANT_SCORE_BOOLEAN_REWRITE) {
                return new ConstantScoreQuery(query);
            }
            return query;
        }

        @Override
        public Query phraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements) throws IOException {
            return TextFieldMapper.createPhraseQuery(stream, this.name(), slop, enablePositionIncrements);
        }

        @Override
        public Query multiPhraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements) throws IOException {
            return TextFieldMapper.createPhraseQuery(stream, this.name(), slop, enablePositionIncrements);
        }

        @Override
        public Query phrasePrefixQuery(TokenStream stream, int slop, int maxExpansions) throws IOException {
            String prefixFieldName = slop > 0 ? null : this.prefixFieldType.name();
            return TextFieldMapper.createPhrasePrefixQuery(stream, this.name(), slop, maxExpansions, prefixFieldName, this.prefixFieldType::termLengthWithinBounds);
        }

        @Override
        public SpanQuery spanPrefixQuery(String value, SpanMultiTermQueryWrapper.SpanRewriteMethod method, QueryShardContext context) {
            if (this.prefixFieldType != null && this.prefixFieldType.termLengthWithinBounds(value.length())) {
                return new FieldMaskingSpanQuery(new SpanTermQuery(new Term(this.prefixFieldType.name(), this.indexedValueForSearch(value))), this.name());
            }
            SpanMultiTermQueryWrapper<PrefixQuery> spanMulti = new SpanMultiTermQueryWrapper<PrefixQuery>(new PrefixQuery(new Term(this.name(), this.indexedValueForSearch(value))));
            spanMulti.setRewriteMethod(method);
            return spanMulti;
        }

        @Override
        public void checkCompatibility(MappedFieldType other, List<String> conflicts) {
            super.checkCompatibility(other, conflicts);
            ShingleFieldType ft = (ShingleFieldType)other;
            if (ft.shingleSize != this.shingleSize) {
                conflicts.add("mapper [" + this.name() + "] has different [shingle_size] values");
            }
            if (!Objects.equals(this.prefixFieldType, ft.prefixFieldType)) {
                conflicts.add("mapper [" + this.name() + "] has different [index_prefixes] settings");
            }
        }

        @Override
        public boolean equals(Object otherObject) {
            if (this == otherObject) {
                return true;
            }
            if (otherObject == null || this.getClass() != otherObject.getClass()) {
                return false;
            }
            if (!super.equals(otherObject)) {
                return false;
            }
            ShingleFieldType other = (ShingleFieldType)otherObject;
            return this.shingleSize == other.shingleSize && Objects.equals(this.prefixFieldType, other.prefixFieldType);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.shingleSize, this.prefixFieldType);
        }
    }

    static final class ShingleFieldMapper
    extends FieldMapper {
        ShingleFieldMapper(ShingleFieldType fieldType, Settings indexSettings) {
            super(fieldType.name(), fieldType, fieldType, indexSettings, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
        }

        @Override
        public ShingleFieldType fieldType() {
            return (ShingleFieldType)super.fieldType();
        }

        @Override
        protected void parseCreateField(ParseContext context, List<IndexableField> fields) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected String contentType() {
            return "shingle";
        }
    }

    static final class PrefixFieldMapper
    extends FieldMapper {
        PrefixFieldMapper(PrefixFieldType fieldType, Settings indexSettings) {
            super(fieldType.name(), fieldType, fieldType, indexSettings, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
        }

        @Override
        public PrefixFieldType fieldType() {
            return (PrefixFieldType)super.fieldType();
        }

        @Override
        protected void parseCreateField(ParseContext context, List<IndexableField> fields) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected String contentType() {
            return "prefix";
        }

        public String toString() {
            return this.fieldType().toString();
        }
    }

    static final class PrefixFieldType
    extends StringFieldType {
        final int minChars;
        final int maxChars;
        final String parentField;

        PrefixFieldType(String parentField, String name, int minChars, int maxChars) {
            this.setTokenized(true);
            this.setOmitNorms(true);
            this.setStored(false);
            this.setName(name);
            this.minChars = minChars;
            this.maxChars = maxChars;
            this.parentField = parentField;
        }

        PrefixFieldType(PrefixFieldType other) {
            super(other);
            this.minChars = other.minChars;
            this.maxChars = other.maxChars;
            this.parentField = other.parentField;
        }

        boolean termLengthWithinBounds(int length) {
            return length >= this.minChars - 1 && length <= this.maxChars;
        }

        @Override
        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, QueryShardContext context) {
            if (value.length() >= this.minChars) {
                return super.termQuery(value, context);
            }
            ArrayList<Automaton> automata = new ArrayList<Automaton>();
            automata.add(Automata.makeString(value));
            for (int i = value.length(); i < this.minChars; ++i) {
                automata.add(Automata.makeAnyChar());
            }
            Automaton automaton = Operations.concatenate(automata);
            AutomatonQuery query = new AutomatonQuery(new Term(this.name(), value + "*"), automaton);
            query.setRewriteMethod(method);
            return new BooleanQuery.Builder().add(query, BooleanClause.Occur.SHOULD).add(new TermQuery(new Term(this.parentField, value)), BooleanClause.Occur.SHOULD).build();
        }

        @Override
        public PrefixFieldType clone() {
            return new PrefixFieldType(this);
        }

        @Override
        public String typeName() {
            return "prefix";
        }

        @Override
        public String toString() {
            return super.toString() + ",prefixChars=" + this.minChars + ":" + this.maxChars;
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PrefixFieldType that = (PrefixFieldType)o;
            return this.minChars == that.minChars && this.maxChars == that.maxChars;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.minChars, this.maxChars);
        }
    }

    static class SearchAsYouTypeFieldType
    extends StringFieldType {
        PrefixFieldType prefixField;
        ShingleFieldType[] shingleFields = new ShingleFieldType[0];

        SearchAsYouTypeFieldType() {
            this.setTokenized(true);
        }

        SearchAsYouTypeFieldType(SearchAsYouTypeFieldType other) {
            super(other);
            if (other.prefixField != null) {
                this.prefixField = other.prefixField.clone();
            }
            if (other.shingleFields != null) {
                this.shingleFields = new ShingleFieldType[other.shingleFields.length];
                for (int i = 0; i < this.shingleFields.length; ++i) {
                    if (other.shingleFields[i] == null) continue;
                    this.shingleFields[i] = other.shingleFields[i].clone();
                }
            }
        }

        public void setPrefixField(PrefixFieldType prefixField) {
            this.checkIfFrozen();
            this.prefixField = prefixField;
        }

        public void setShingleFields(ShingleFieldType[] shingleFields) {
            this.checkIfFrozen();
            this.shingleFields = shingleFields;
        }

        @Override
        public MappedFieldType clone() {
            return new SearchAsYouTypeFieldType(this);
        }

        @Override
        public String typeName() {
            return SearchAsYouTypeFieldMapper.CONTENT_TYPE;
        }

        private ShingleFieldType shingleFieldForPositions(int positions) {
            int indexFromShingleSize = Math.max(positions - 2, 0);
            return this.shingleFields[Math.min(indexFromShingleSize, this.shingleFields.length - 1)];
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            if (this.omitNorms()) {
                return new TermQuery(new Term("_field_names", this.name()));
            }
            return new NormsFieldExistsQuery(this.name());
        }

        @Override
        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, QueryShardContext context) {
            if (this.prefixField == null || !this.prefixField.termLengthWithinBounds(value.length())) {
                return super.prefixQuery(value, method, context);
            }
            Query query = this.prefixField.prefixQuery(value, method, context);
            if (method == null || method == MultiTermQuery.CONSTANT_SCORE_REWRITE || method == MultiTermQuery.CONSTANT_SCORE_BOOLEAN_REWRITE) {
                return new ConstantScoreQuery(query);
            }
            return query;
        }

        @Override
        public Query phraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements) throws IOException {
            int numPos = SearchAsYouTypeFieldMapper.countPosition(stream);
            if (this.shingleFields.length == 0 || slop > 0 || TextFieldMapper.TextFieldType.hasGaps(stream) || numPos <= 1) {
                return TextFieldMapper.createPhraseQuery(stream, this.name(), slop, enablePositionIncrements);
            }
            ShingleFieldType shingleField = this.shingleFieldForPositions(numPos);
            stream = new FixedShingleFilter(stream, shingleField.shingleSize);
            return shingleField.phraseQuery(stream, 0, true);
        }

        @Override
        public Query multiPhraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements) throws IOException {
            int numPos = SearchAsYouTypeFieldMapper.countPosition(stream);
            if (this.shingleFields.length == 0 || slop > 0 || TextFieldMapper.TextFieldType.hasGaps(stream) || numPos <= 1) {
                return TextFieldMapper.createPhraseQuery(stream, this.name(), slop, enablePositionIncrements);
            }
            ShingleFieldType shingleField = this.shingleFieldForPositions(numPos);
            stream = new FixedShingleFilter(stream, shingleField.shingleSize);
            return shingleField.multiPhraseQuery(stream, 0, true);
        }

        @Override
        public Query phrasePrefixQuery(TokenStream stream, int slop, int maxExpansions) throws IOException {
            int numPos = SearchAsYouTypeFieldMapper.countPosition(stream);
            if (this.shingleFields.length == 0 || slop > 0 || TextFieldMapper.TextFieldType.hasGaps(stream) || numPos <= 1) {
                return TextFieldMapper.createPhrasePrefixQuery(stream, this.name(), slop, maxExpansions, null, null);
            }
            ShingleFieldType shingleField = this.shingleFieldForPositions(numPos);
            stream = new FixedShingleFilter(stream, shingleField.shingleSize);
            return shingleField.phrasePrefixQuery(stream, 0, maxExpansions);
        }

        @Override
        public SpanQuery spanPrefixQuery(String value, SpanMultiTermQueryWrapper.SpanRewriteMethod method, QueryShardContext context) {
            if (this.prefixField != null && this.prefixField.termLengthWithinBounds(value.length())) {
                return new FieldMaskingSpanQuery(new SpanTermQuery(new Term(this.prefixField.name(), this.indexedValueForSearch(value))), this.name());
            }
            SpanMultiTermQueryWrapper<PrefixQuery> spanMulti = new SpanMultiTermQueryWrapper<PrefixQuery>(new PrefixQuery(new Term(this.name(), this.indexedValueForSearch(value))));
            spanMulti.setRewriteMethod(method);
            return spanMulti;
        }

        @Override
        public void checkCompatibility(MappedFieldType other, List<String> conflicts) {
            super.checkCompatibility(other, conflicts);
            SearchAsYouTypeFieldType otherFieldType = (SearchAsYouTypeFieldType)other;
            if (this.shingleFields.length != otherFieldType.shingleFields.length) {
                conflicts.add("mapper [" + this.name() + "] has a different [max_shingle_size]");
            } else if (!Arrays.equals(this.shingleFields, otherFieldType.shingleFields)) {
                conflicts.add("mapper [" + this.name() + "] has shingle subfields that are configured differently");
            }
            if (!Objects.equals(this.prefixField, otherFieldType.prefixField)) {
                conflicts.add("mapper [" + this.name() + "] has different [index_prefixes] settings");
            }
        }

        @Override
        public boolean equals(Object otherObject) {
            if (this == otherObject) {
                return true;
            }
            if (otherObject == null || this.getClass() != otherObject.getClass()) {
                return false;
            }
            if (!super.equals(otherObject)) {
                return false;
            }
            SearchAsYouTypeFieldType other = (SearchAsYouTypeFieldType)otherObject;
            return Objects.equals(this.prefixField, other.prefixField) && Arrays.equals(this.shingleFields, other.shingleFields);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.prefixField, Arrays.hashCode(this.shingleFields));
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, SearchAsYouTypeFieldMapper> {
        private int maxShingleSize = 3;

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        public Builder maxShingleSize(int maxShingleSize) {
            if (maxShingleSize < 2 || maxShingleSize > 4) {
                throw new MapperParsingException("[max_shingle_size] must be at least [2] and at most [4], got [" + maxShingleSize + "]");
            }
            this.maxShingleSize = maxShingleSize;
            return (Builder)this.builder;
        }

        @Override
        public SearchAsYouTypeFieldType fieldType() {
            return (SearchAsYouTypeFieldType)this.fieldType;
        }

        @Override
        public SearchAsYouTypeFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            NamedAnalyzer indexAnalyzer = this.fieldType().indexAnalyzer();
            NamedAnalyzer searchAnalyzer = this.fieldType().searchAnalyzer();
            NamedAnalyzer searchQuoteAnalyzer = this.fieldType().searchQuoteAnalyzer();
            String fullName = this.buildFullName(context);
            String prefixFieldName = fullName + SearchAsYouTypeFieldMapper.PREFIX_FIELD_SUFFIX;
            PrefixFieldType prefixFieldType = new PrefixFieldType(fullName, prefixFieldName, 1, 20);
            prefixFieldType.setIndexOptions(this.fieldType().indexOptions());
            SearchAsYouTypeAnalyzer prefixIndexWrapper = SearchAsYouTypeAnalyzer.withShingleAndPrefix(indexAnalyzer.analyzer(), this.maxShingleSize);
            SearchAsYouTypeAnalyzer prefixSearchWrapper = SearchAsYouTypeAnalyzer.withShingle(searchAnalyzer.analyzer(), this.maxShingleSize);
            prefixFieldType.setIndexAnalyzer(new NamedAnalyzer(indexAnalyzer.name(), AnalyzerScope.INDEX, prefixIndexWrapper));
            prefixFieldType.setSearchAnalyzer(new NamedAnalyzer(searchAnalyzer.name(), AnalyzerScope.INDEX, prefixSearchWrapper));
            PrefixFieldMapper prefixFieldMapper = new PrefixFieldMapper(prefixFieldType, context.indexSettings());
            ShingleFieldMapper[] shingleFieldMappers = new ShingleFieldMapper[this.maxShingleSize - 1];
            ShingleFieldType[] shingleFieldTypes = new ShingleFieldType[this.maxShingleSize - 1];
            for (int i = 0; i < shingleFieldMappers.length; ++i) {
                int shingleSize = i + 2;
                ShingleFieldType shingleFieldType = new ShingleFieldType(this.fieldType(), shingleSize);
                shingleFieldType.setName(SearchAsYouTypeFieldMapper.getShingleFieldName(this.buildFullName(context), shingleSize));
                SearchAsYouTypeAnalyzer shingleIndexWrapper = SearchAsYouTypeAnalyzer.withShingle(indexAnalyzer.analyzer(), shingleSize);
                SearchAsYouTypeAnalyzer shingleSearchWrapper = SearchAsYouTypeAnalyzer.withShingle(searchAnalyzer.analyzer(), shingleSize);
                SearchAsYouTypeAnalyzer shingleSearchQuoteWrapper = SearchAsYouTypeAnalyzer.withShingle(searchQuoteAnalyzer.analyzer(), shingleSize);
                shingleFieldType.setIndexAnalyzer(new NamedAnalyzer(indexAnalyzer.name(), AnalyzerScope.INDEX, shingleIndexWrapper));
                shingleFieldType.setSearchAnalyzer(new NamedAnalyzer(searchAnalyzer.name(), AnalyzerScope.INDEX, shingleSearchWrapper));
                shingleFieldType.setSearchQuoteAnalyzer(new NamedAnalyzer(searchQuoteAnalyzer.name(), AnalyzerScope.INDEX, shingleSearchQuoteWrapper));
                shingleFieldType.setPrefixFieldType(prefixFieldType);
                shingleFieldTypes[i] = shingleFieldType;
                shingleFieldMappers[i] = new ShingleFieldMapper(shingleFieldType, context.indexSettings());
            }
            this.fieldType().setPrefixField(prefixFieldType);
            this.fieldType().setShingleFields(shingleFieldTypes);
            return new SearchAsYouTypeFieldMapper(this.name, this.fieldType(), context.indexSettings(), this.copyTo, this.maxShingleSize, prefixFieldMapper, shingleFieldMappers);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            builder.fieldType().setIndexAnalyzer(parserContext.getIndexAnalyzers().getDefaultIndexAnalyzer());
            builder.fieldType().setSearchAnalyzer(parserContext.getIndexAnalyzers().getDefaultSearchAnalyzer());
            builder.fieldType().setSearchQuoteAnalyzer(parserContext.getIndexAnalyzers().getDefaultSearchQuoteAnalyzer());
            TypeParsers.parseTextField(builder, name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                Object fieldNode = entry.getValue();
                if (!fieldName.equals("max_shingle_size")) continue;
                builder.maxShingleSize(XContentMapValues.nodeIntegerValue(fieldNode));
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Defaults {
        public static final int MIN_GRAM = 1;
        public static final int MAX_GRAM = 20;
        public static final int MAX_SHINGLE_SIZE = 3;
        public static final MappedFieldType FIELD_TYPE = new SearchAsYouTypeFieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
            FIELD_TYPE.freeze();
        }
    }
}

