/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import org.apache.lucene.document.LatLonShape;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.geo.GeoShapeType;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryCollection;
import org.elasticsearch.geometry.GeometryVisitor;
import org.elasticsearch.geometry.Line;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.MultiLine;
import org.elasticsearch.geometry.MultiPoint;
import org.elasticsearch.geometry.MultiPolygon;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.GeoShapeFieldMapper;
import org.elasticsearch.index.mapper.GeoShapeIndexer;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;

public class VectorGeoShapeQueryProcessor
implements AbstractGeometryFieldMapper.QueryProcessor {
    @Override
    public Query process(Geometry shape, String fieldName, ShapeRelation relation, QueryShardContext context) {
        if (relation == ShapeRelation.CONTAINS) {
            throw new QueryShardException(context, ShapeRelation.CONTAINS + " query relation not supported for Field [" + fieldName + "]", new Object[0]);
        }
        return this.getVectorQueryFromShape(shape, fieldName, relation, context);
    }

    protected Query getVectorQueryFromShape(Geometry queryShape, String fieldName, ShapeRelation relation, QueryShardContext context) {
        GeoShapeIndexer geometryIndexer = new GeoShapeIndexer(true, fieldName);
        Geometry processedShape = geometryIndexer.prepareForIndexing(queryShape);
        if (processedShape == null) {
            return new MatchNoDocsQuery();
        }
        return processedShape.visit(new ShapeVisitor(context, fieldName, relation));
    }

    private class ShapeVisitor
    implements GeometryVisitor<Query, RuntimeException> {
        QueryShardContext context;
        MappedFieldType fieldType;
        String fieldName;
        ShapeRelation relation;

        ShapeVisitor(QueryShardContext context, String fieldName, ShapeRelation relation) {
            this.context = context;
            this.fieldType = context.fieldMapper(fieldName);
            this.fieldName = fieldName;
            this.relation = relation;
        }

        @Override
        public Query visit(Circle circle) {
            throw new QueryShardException(this.context, "Field [" + this.fieldName + "] found and unknown shape Circle", new Object[0]);
        }

        @Override
        public Query visit(GeometryCollection<?> collection) {
            BooleanQuery.Builder bqb = new BooleanQuery.Builder();
            this.visit(bqb, collection);
            return bqb.build();
        }

        private void visit(BooleanQuery.Builder bqb, GeometryCollection<?> collection) {
            for (Geometry shape : collection) {
                if (shape instanceof MultiPoint) {
                    this.visit(bqb, (GeometryCollection)shape);
                    continue;
                }
                bqb.add(shape.visit(this), BooleanClause.Occur.SHOULD);
            }
        }

        @Override
        public Query visit(Line line) {
            this.validateIsGeoShapeFieldType();
            return LatLonShape.newLineQuery(this.fieldName, this.relation.getLuceneRelation(), new org.apache.lucene.geo.Line(line.getY(), line.getX()));
        }

        @Override
        public Query visit(LinearRing ring) {
            throw new QueryShardException(this.context, "Field [" + this.fieldName + "] found and unsupported shape LinearRing", new Object[0]);
        }

        @Override
        public Query visit(MultiLine multiLine) {
            this.validateIsGeoShapeFieldType();
            org.apache.lucene.geo.Line[] lines = new org.apache.lucene.geo.Line[multiLine.size()];
            for (int i = 0; i < multiLine.size(); ++i) {
                lines[i] = new org.apache.lucene.geo.Line(((Line)multiLine.get(i)).getY(), ((Line)multiLine.get(i)).getX());
            }
            return LatLonShape.newLineQuery(this.fieldName, this.relation.getLuceneRelation(), lines);
        }

        @Override
        public Query visit(MultiPoint multiPoint) {
            throw new QueryShardException(this.context, "Field [" + this.fieldName + "] does not support " + (Object)((Object)GeoShapeType.MULTIPOINT) + " queries", new Object[0]);
        }

        @Override
        public Query visit(MultiPolygon multiPolygon) {
            Polygon[] polygons = new Polygon[multiPolygon.size()];
            for (int i = 0; i < multiPolygon.size(); ++i) {
                polygons[i] = GeoShapeIndexer.toLucenePolygon((org.elasticsearch.geometry.Polygon)multiPolygon.get(i));
            }
            return LatLonShape.newPolygonQuery(this.fieldName, this.relation.getLuceneRelation(), polygons);
        }

        @Override
        public Query visit(Point point) {
            this.validateIsGeoShapeFieldType();
            return LatLonShape.newBoxQuery(this.fieldName, this.relation.getLuceneRelation(), point.getY(), point.getY(), point.getX(), point.getX());
        }

        @Override
        public Query visit(org.elasticsearch.geometry.Polygon polygon) {
            return LatLonShape.newPolygonQuery(this.fieldName, this.relation.getLuceneRelation(), GeoShapeIndexer.toLucenePolygon(polygon));
        }

        @Override
        public Query visit(Rectangle r) {
            return LatLonShape.newBoxQuery(this.fieldName, this.relation.getLuceneRelation(), r.getMinY(), r.getMaxY(), r.getMinX(), r.getMaxX());
        }

        private void validateIsGeoShapeFieldType() {
            if (!(this.fieldType instanceof GeoShapeFieldMapper.GeoShapeFieldType)) {
                throw new QueryShardException(this.context, "Expected geo_shape field type for Field [" + this.fieldName + "] but found " + this.fieldType.typeName(), new Object[0]);
            }
        }
    }
}

