/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.internal.SearchContext;

public abstract class ArrayValuesSourceAggregatorFactory<VS extends ValuesSource>
extends AggregatorFactory {
    protected Map<String, ValuesSourceConfig<VS>> configs;

    public ArrayValuesSourceAggregatorFactory(String name, Map<String, ValuesSourceConfig<VS>> configs, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metaData) throws IOException {
        super(name, queryShardContext, parent, subFactoriesBuilder, metaData);
        this.configs = configs;
    }

    @Override
    public Aggregator createInternal(SearchContext searchContext, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        HashMap<String, VS> valuesSources = new HashMap<String, VS>();
        for (Map.Entry<String, ValuesSourceConfig<VS>> config : this.configs.entrySet()) {
            VS vs = config.getValue().toValuesSource(this.queryShardContext);
            if (vs == null) continue;
            valuesSources.put(config.getKey(), vs);
        }
        if (valuesSources.isEmpty()) {
            return this.createUnmapped(searchContext, parent, pipelineAggregators, metaData);
        }
        return this.doCreateInternal(valuesSources, searchContext, parent, collectsFromSingleBucket, pipelineAggregators, metaData);
    }

    protected abstract Aggregator createUnmapped(SearchContext var1, Aggregator var2, List<PipelineAggregator> var3, Map<String, Object> var4) throws IOException;

    protected abstract Aggregator doCreateInternal(Map<String, VS> var1, SearchContext var2, Aggregator var3, boolean var4, List<PipelineAggregator> var5, Map<String, Object> var6) throws IOException;
}

