/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.flink.jdbc.input;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.seatunnel.flink.jdbc.input.TypeInformationMap;

public class HiveTypeInformationMap
implements TypeInformationMap {
    private static final Map<String, TypeInformation<?>> INFORMATION_MAP = new HashMap();

    @Override
    public TypeInformation<?> getInformation(String datatype) {
        return INFORMATION_MAP.get(datatype);
    }

    static {
        INFORMATION_MAP.put("tinyint", (TypeInformation<?>)BasicTypeInfo.INT_TYPE_INFO);
        INFORMATION_MAP.put("smallint", (TypeInformation<?>)BasicTypeInfo.SHORT_TYPE_INFO);
        INFORMATION_MAP.put("int", (TypeInformation<?>)BasicTypeInfo.INT_TYPE_INFO);
        INFORMATION_MAP.put("bigint", (TypeInformation<?>)BasicTypeInfo.LONG_TYPE_INFO);
        INFORMATION_MAP.put("float", (TypeInformation<?>)BasicTypeInfo.FLOAT_TYPE_INFO);
        INFORMATION_MAP.put("double", (TypeInformation<?>)BasicTypeInfo.DOUBLE_TYPE_INFO);
        INFORMATION_MAP.put("decimal", (TypeInformation<?>)BasicTypeInfo.BIG_DEC_TYPE_INFO);
        INFORMATION_MAP.put("boolean", (TypeInformation<?>)BasicTypeInfo.BOOLEAN_TYPE_INFO);
        INFORMATION_MAP.put("char", (TypeInformation<?>)BasicTypeInfo.STRING_TYPE_INFO);
        INFORMATION_MAP.put("varchar", (TypeInformation<?>)BasicTypeInfo.STRING_TYPE_INFO);
        INFORMATION_MAP.put("binary", (TypeInformation<?>)BasicTypeInfo.STRING_TYPE_INFO);
        INFORMATION_MAP.put("string", (TypeInformation<?>)BasicTypeInfo.STRING_TYPE_INFO);
        INFORMATION_MAP.put("void", (TypeInformation<?>)BasicTypeInfo.VOID_TYPE_INFO);
        INFORMATION_MAP.put("date", (TypeInformation<?>)SqlTimeTypeInfo.DATE);
        INFORMATION_MAP.put("interval_day_time", (TypeInformation<?>)SqlTimeTypeInfo.DATE);
        INFORMATION_MAP.put("interval_year_month", (TypeInformation<?>)SqlTimeTypeInfo.DATE);
        INFORMATION_MAP.put("timestamp", (TypeInformation<?>)SqlTimeTypeInfo.TIMESTAMP);
        INFORMATION_MAP.put("map", (TypeInformation<?>)BasicTypeInfo.STRING_TYPE_INFO);
        INFORMATION_MAP.put("array", (TypeInformation<?>)BasicTypeInfo.STRING_TYPE_INFO);
        INFORMATION_MAP.put("struct", (TypeInformation<?>)BasicTypeInfo.STRING_TYPE_INFO);
    }
}

