/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.flink.jdbc.input;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Objects;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.calcite.shaded.com.google.common.base.Preconditions;
import org.apache.flink.connector.jdbc.JdbcConnectionOptions;
import org.apache.flink.connector.jdbc.internal.connection.SimpleJdbcConnectionProvider;
import org.apache.flink.connector.jdbc.split.JdbcParameterValuesProvider;
import org.apache.flink.types.Row;

public class JdbcInputFormat
extends org.apache.flink.connector.jdbc.JdbcInputFormat {
    @Override
    public Row nextRecord(Row reuse) throws IOException {
        try {
            if (!this.hasNext) {
                return null;
            }
            for (int pos = 0; pos < reuse.getArity(); ++pos) {
                Object v = this.resultSet.getObject(pos + 1);
                if (Objects.isNull(v)) {
                    reuse.setField(pos, null);
                    continue;
                }
                TypeInformation type = this.rowTypeInfo.getTypeAt(pos);
                Class clazz = type.getTypeClass();
                if (String.class == clazz) {
                    reuse.setField(pos, (Object)String.valueOf(v));
                    continue;
                }
                if (Boolean.class == clazz) {
                    reuse.setField(pos, (Object)this.resultSet.getBoolean(pos + 1));
                    continue;
                }
                if (Byte.class == clazz) {
                    reuse.setField(pos, (Object)this.resultSet.getByte(pos + 1));
                    continue;
                }
                if (Short.class == clazz) {
                    reuse.setField(pos, (Object)this.resultSet.getShort(pos + 1));
                    continue;
                }
                if (Integer.class == clazz) {
                    reuse.setField(pos, (Object)this.resultSet.getInt(pos + 1));
                    continue;
                }
                if (Long.class == clazz) {
                    reuse.setField(pos, (Object)this.resultSet.getLong(pos + 1));
                    continue;
                }
                if (Float.class == clazz) {
                    reuse.setField(pos, (Object)Float.valueOf(this.resultSet.getFloat(pos + 1)));
                    continue;
                }
                if (Double.class == clazz) {
                    reuse.setField(pos, (Object)this.resultSet.getDouble(pos + 1));
                    continue;
                }
                if (Character.class == clazz) {
                    reuse.setField(pos, (Object)this.resultSet.getString(pos + 1));
                    continue;
                }
                if (java.util.Date.class == clazz) {
                    reuse.setField(pos, (Object)this.resultSet.getDate(pos + 1));
                    continue;
                }
                if (BigInteger.class == clazz) {
                    reuse.setField(pos, (Object)this.resultSet.getString(pos + 1));
                    continue;
                }
                if (Instant.class == clazz) {
                    reuse.setField(pos, (Object)this.resultSet.getString(pos + 1));
                    continue;
                }
                if (Date.class == clazz) {
                    reuse.setField(pos, (Object)this.resultSet.getDate(pos + 1));
                    continue;
                }
                if (Time.class == clazz) {
                    reuse.setField(pos, (Object)this.resultSet.getTime(pos + 1));
                    continue;
                }
                if (BigDecimal.class == clazz) {
                    reuse.setField(pos, (Object)this.resultSet.getBigDecimal(pos + 1));
                    continue;
                }
                if (Timestamp.class == clazz) {
                    reuse.setField(pos, (Object)this.resultSet.getTimestamp(pos + 1));
                    continue;
                }
                if (byte[].class == clazz) {
                    reuse.setField(pos, (Object)this.resultSet.getBytes(pos + 1));
                    continue;
                }
                reuse.setField(pos, this.resultSet.getObject(pos + 1));
            }
            this.hasNext = this.resultSet.next();
            return reuse;
        }
        catch (SQLException se) {
            throw new IOException("Couldn't read data - " + se.getMessage(), se);
        }
        catch (NullPointerException npe) {
            throw new IOException("Couldn't access resultSet", npe);
        }
    }

    public static JdbcInputFormatBuilder buildFlinkJdbcInputFormat() {
        return new JdbcInputFormatBuilder();
    }

    static /* synthetic */ Object[][] access$502(JdbcInputFormat x0, Object[][] x1) {
        x0.parameterValues = x1;
        return x1;
    }

    public static class JdbcInputFormatBuilder {
        private final JdbcConnectionOptions.JdbcConnectionOptionsBuilder connOptionsBuilder = new JdbcConnectionOptions.JdbcConnectionOptionsBuilder();
        private final JdbcInputFormat format = new JdbcInputFormat();

        public JdbcInputFormatBuilder() {
            this.format.resultSetType = 1003;
            this.format.resultSetConcurrency = 1007;
        }

        public JdbcInputFormatBuilder setUsername(String username) {
            this.connOptionsBuilder.withUsername(username);
            return this;
        }

        public JdbcInputFormatBuilder setPassword(String password) {
            this.connOptionsBuilder.withPassword(password);
            return this;
        }

        public JdbcInputFormatBuilder setDrivername(String drivername) {
            this.connOptionsBuilder.withDriverName(drivername);
            return this;
        }

        public JdbcInputFormatBuilder setDBUrl(String dbURL) {
            this.connOptionsBuilder.withUrl(dbURL);
            return this;
        }

        public JdbcInputFormatBuilder setQuery(String query) {
            this.format.queryTemplate = query;
            return this;
        }

        public JdbcInputFormatBuilder setResultSetType(int resultSetType) {
            this.format.resultSetType = resultSetType;
            return this;
        }

        public JdbcInputFormatBuilder setResultSetConcurrency(int resultSetConcurrency) {
            this.format.resultSetConcurrency = resultSetConcurrency;
            return this;
        }

        public JdbcInputFormatBuilder setParametersProvider(JdbcParameterValuesProvider parameterValuesProvider) {
            JdbcInputFormat.access$502(this.format, parameterValuesProvider.getParameterValues());
            return this;
        }

        public JdbcInputFormatBuilder setRowTypeInfo(RowTypeInfo rowTypeInfo) {
            this.format.rowTypeInfo = rowTypeInfo;
            return this;
        }

        public JdbcInputFormatBuilder setFetchSize(int fetchSize) {
            Preconditions.checkArgument((fetchSize == Integer.MIN_VALUE || fetchSize > 0 ? 1 : 0) != 0, (String)"Illegal value %s for fetchSize, has to be positive or Integer.MIN_VALUE.", (int)fetchSize);
            this.format.fetchSize = fetchSize;
            return this;
        }

        public JdbcInputFormatBuilder setAutoCommit(Boolean autoCommit) {
            this.format.autoCommit = autoCommit;
            return this;
        }

        public JdbcInputFormat finish() {
            this.format.connectionProvider = new SimpleJdbcConnectionProvider(this.connOptionsBuilder.build());
            if (this.format.queryTemplate == null) {
                throw new NullPointerException("No query supplied");
            }
            if (this.format.rowTypeInfo == null) {
                throw new NullPointerException("No " + RowTypeInfo.class.getSimpleName() + " supplied");
            }
            if (this.format.parameterValues == null) {
                LOG.debug("No input splitting configured (data will be read with parallelism 1).");
            }
            return this.format;
        }
    }
}

