/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.flink.jdbc.sink;

import com.google.auto.service.AutoService;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.connector.jdbc.JdbcConnectionOptions;
import org.apache.flink.connector.jdbc.JdbcExecutionOptions;
import org.apache.flink.connector.jdbc.JdbcOutputFormat;
import org.apache.flink.connector.jdbc.utils.JdbcTypeUtil;
import org.apache.flink.connector.jdbc.utils.JdbcUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.table.api.Table;
import org.apache.flink.types.Row;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.flink.BaseFlinkSink;
import org.apache.seatunnel.flink.FlinkEnvironment;
import org.apache.seatunnel.flink.batch.FlinkBatchSink;
import org.apache.seatunnel.flink.stream.FlinkStreamSink;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={BaseFlinkSink.class})
public class JdbcSink
implements FlinkStreamSink,
FlinkBatchSink {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcSink.class);
    private static final long serialVersionUID = 3677571223952518115L;
    private static final int DEFAULT_BATCH_SIZE = 5000;
    private static final int DEFAULT_MAX_RETRY_TIMES = 3;
    private static final int DEFAULT_INTERVAL_MILLIS = 0;
    private static final String PARALLELISM = "parallelism";
    private Config config;
    private String driverName;
    private String dbUrl;
    private String username;
    private String password;
    private String query;
    private String preSql;
    private String postSql;
    private boolean ignorePostSqlExceptions = false;
    private int batchSize = 5000;
    private long batchIntervalMs = 0L;
    private int maxRetries = 3;

    public void setConfig(Config config) {
        this.config = config;
    }

    public Config getConfig() {
        return this.config;
    }

    public CheckResult checkConfig() {
        return CheckConfigUtil.checkAllExists((Config)this.config, (String[])new String[]{"driver", "url", "username", "query"});
    }

    public void prepare(FlinkEnvironment env) {
        this.driverName = this.config.getString("driver");
        this.dbUrl = this.config.getString("url");
        this.username = this.config.getString("username");
        this.query = this.config.getString("query");
        if (this.config.hasPath("password")) {
            this.password = this.config.getString("password");
        }
        if (this.config.hasPath("batch_size")) {
            this.batchSize = this.config.getInt("batch_size");
        }
        if (this.config.hasPath("batch_interval")) {
            this.batchIntervalMs = this.config.getLong("batch_interval");
        }
        if (this.config.hasPath("batch_max_retries")) {
            this.maxRetries = this.config.getInt("batch_max_retries");
        }
        if (this.config.hasPath("pre_sql")) {
            this.preSql = this.config.getString("pre_sql");
        }
        if (!env.isStreaming() && this.config.hasPath("post_sql")) {
            this.postSql = this.config.getString("post_sql");
        }
        if (this.config.hasPath("ignore_post_sql_exceptions")) {
            this.ignorePostSqlExceptions = this.config.getBoolean("ignore_post_sql_exceptions");
        }
    }

    public String getPluginName() {
        return "JdbcSink";
    }

    public void outputStream(FlinkEnvironment env, DataStream<Row> dataStream) {
        this.executePreSql();
        Table table = env.getStreamTableEnvironment().fromDataStream(dataStream);
        TypeInformation[] fieldTypes = table.getSchema().getFieldTypes();
        int[] types = Arrays.stream(fieldTypes).mapToInt(JdbcTypeUtil::typeInformationToSqlType).toArray();
        SinkFunction sink = org.apache.flink.connector.jdbc.JdbcSink.sink(this.query, (st, row) -> JdbcUtils.setRecordToStatement(st, types, row), JdbcExecutionOptions.builder().withBatchSize(this.batchSize).withBatchIntervalMs(this.batchIntervalMs).withMaxRetries(this.maxRetries).build(), new JdbcConnectionOptions.JdbcConnectionOptionsBuilder().withUrl(this.dbUrl).withDriverName(this.driverName).withUsername(this.username).withPassword(this.password).build());
        if (this.config.hasPath(PARALLELISM)) {
            dataStream.addSink(sink).setParallelism(this.config.getInt(PARALLELISM));
        } else {
            dataStream.addSink(sink);
        }
    }

    public void outputBatch(FlinkEnvironment env, DataSet<Row> dataSet) {
        this.executePreSql();
        Table table = env.getBatchTableEnvironment().fromDataSet(dataSet);
        TypeInformation[] fieldTypes = table.getSchema().getFieldTypes();
        int[] types = Arrays.stream(fieldTypes).mapToInt(JdbcTypeUtil::typeInformationToSqlType).toArray();
        JdbcOutputFormat format = JdbcOutputFormat.buildJdbcOutputFormat().setDrivername(this.driverName).setDBUrl(this.dbUrl).setUsername(this.username).setPassword(this.password).setQuery(this.query).setBatchSize(this.batchSize).setSqlTypes(types).finish();
        dataSet.output((OutputFormat)format);
    }

    public void close() throws Exception {
        this.executePostSql();
    }

    private void executePreSql() {
        if (StringUtils.isNotBlank((CharSequence)this.preSql)) {
            LOGGER.info("Starting to execute pre sql: \n {}", (Object)this.preSql);
            try {
                this.executeSql(this.preSql);
            }
            catch (SQLException e) {
                LOGGER.error("Execute pre sql failed, pre sql is : \n {} \n", (Object)this.preSql, (Object)e);
                throw new RuntimeException(e);
            }
        }
    }

    private void executePostSql() {
        block3: {
            if (StringUtils.isNotBlank((CharSequence)this.postSql)) {
                LOGGER.info("Starting to execute post sql: \n {}", (Object)this.postSql);
                try {
                    this.executeSql(this.postSql);
                }
                catch (SQLException e) {
                    LOGGER.error("Execute post sql failed, post sql is : \n {} \n", (Object)this.postSql, (Object)e);
                    if (this.ignorePostSqlExceptions) break block3;
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void executeSql(String sql) throws SQLException {
        try (Connection connection = DriverManager.getConnection(this.dbUrl, this.username, this.password);
             Statement statement = connection.createStatement();){
            statement.execute(sql);
            LOGGER.info("Executed sql successfully.");
        }
    }
}

