/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.flink.jdbc.source;

import com.google.auto.service.AutoService;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.connector.jdbc.split.JdbcNumericBetweenParametersProvider;
import org.apache.flink.connector.jdbc.split.JdbcParameterValuesProvider;
import org.apache.flink.types.Row;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.flink.BaseFlinkSource;
import org.apache.seatunnel.flink.FlinkEnvironment;
import org.apache.seatunnel.flink.batch.FlinkBatchSource;
import org.apache.seatunnel.flink.jdbc.input.DefaultTypeInformationMap;
import org.apache.seatunnel.flink.jdbc.input.HiveTypeInformationMap;
import org.apache.seatunnel.flink.jdbc.input.JdbcInputFormat;
import org.apache.seatunnel.flink.jdbc.input.MysqlTypeInformationMap;
import org.apache.seatunnel.flink.jdbc.input.OracleTypeInformationMap;
import org.apache.seatunnel.flink.jdbc.input.PostgresTypeInformationMap;
import org.apache.seatunnel.flink.jdbc.input.TypeInformationMap;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={BaseFlinkSource.class})
public class JdbcSource
implements FlinkBatchSource {
    private static final long serialVersionUID = -3349505356339446415L;
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcSource.class);
    private static final int DEFAULT_FETCH_SIZE = 10000;
    private Config config;
    private String password;
    private int fetchSize = 10000;
    private int parallelism = -1;
    private Map<String, TypeInformation<?>> tableFieldInfo;
    private JdbcInputFormat jdbcInputFormat;

    public DataSet<Row> getData(FlinkEnvironment env) {
        DataSource dataSource = env.getBatchEnvironment().createInput((InputFormat)this.jdbcInputFormat);
        if (this.config.hasPath("parallelism")) {
            return dataSource.setParallelism(this.config.getInt("parallelism"));
        }
        return dataSource;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public Config getConfig() {
        return this.config;
    }

    public CheckResult checkConfig() {
        return CheckConfigUtil.checkAllExists((Config)this.config, (String[])new String[]{"driver", "url", "username", "query"});
    }

    public void prepare(FlinkEnvironment env) {
        String driverName = this.config.getString("driver");
        String dbUrl = this.config.getString("url");
        String username = this.config.getString("username");
        String query = this.config.getString("query");
        if (this.config.hasPath("password")) {
            this.password = this.config.getString("password");
        }
        if (this.config.hasPath("fetch_size")) {
            this.fetchSize = this.config.getInt("fetch_size");
        }
        this.parallelism = this.config.hasPath("parallelism") ? this.config.getInt("parallelism") : env.getBatchEnvironment().getParallelism();
        try {
            Class.forName(driverName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("jdbc connection init failed.", e);
        }
        try (Connection connection = DriverManager.getConnection(dbUrl, username, this.password);){
            this.tableFieldInfo = this.initTableField(connection, query);
            RowTypeInfo rowTypeInfo = this.getRowTypeInfo();
            JdbcInputFormat.JdbcInputFormatBuilder builder = JdbcInputFormat.buildFlinkJdbcInputFormat();
            if (this.config.hasPath("partition_column")) {
                String partitionColumn = this.config.getString("partition_column");
                if (!this.tableFieldInfo.containsKey(partitionColumn)) {
                    throw new IllegalArgumentException(String.format("field %s not contain in query sql %s", partitionColumn, query));
                }
                if (!this.isNumericType(rowTypeInfo.getTypeAt(partitionColumn))) {
                    throw new IllegalArgumentException(String.format("%s is not numeric type", partitionColumn));
                }
                JdbcParameterValuesProvider jdbcParameterValuesProvider = this.initPartition(partitionColumn, connection, query);
                builder.setParametersProvider(jdbcParameterValuesProvider);
                query = String.format("SELECT * FROM (%s) tt where " + partitionColumn + " >= ? AND " + partitionColumn + " <= ?", query);
            }
            builder.setDrivername(driverName).setDBUrl(dbUrl).setUsername(username).setPassword(this.password).setQuery(query).setFetchSize(this.fetchSize).setRowTypeInfo(rowTypeInfo);
            this.jdbcInputFormat = builder.finish();
        }
        catch (SQLException e) {
            throw new RuntimeException("jdbc connection init failed.", e);
        }
    }

    public String getPluginName() {
        return "JdbcSource";
    }

    private JdbcParameterValuesProvider initPartition(String columnName, Connection connection, String query) throws SQLException {
        long max = Long.MAX_VALUE;
        long min = Long.MIN_VALUE;
        if (this.config.hasPath("partition_upper_bound") && this.config.hasPath("partition_lower_bound")) {
            max = this.config.getLong("partition_upper_bound");
            min = this.config.getLong("partition_lower_bound");
            return new JdbcNumericBetweenParametersProvider(min, max).ofBatchNum(this.parallelism * 2);
        }
        try (ResultSet rs = connection.createStatement().executeQuery(String.format("SELECT MAX(%s),MIN(%s) FROM (%s) tt", columnName, columnName, query));){
            if (rs.next()) {
                max = this.config.hasPath("partition_upper_bound") ? this.config.getLong("partition_upper_bound") : Long.parseLong(rs.getString(1));
                min = this.config.hasPath("partition_lower_bound") ? this.config.getLong("partition_lower_bound") : Long.parseLong(rs.getString(2));
            }
        }
        return new JdbcNumericBetweenParametersProvider(min, max).ofBatchNum(this.parallelism * 2);
    }

    private boolean isNumericType(TypeInformation<?> type) {
        return type.equals((Object)BasicTypeInfo.INT_TYPE_INFO) || type.equals((Object)BasicTypeInfo.SHORT_TYPE_INFO) || type.equals((Object)BasicTypeInfo.LONG_TYPE_INFO) || type.equals((Object)BasicTypeInfo.BIG_INT_TYPE_INFO);
    }

    private Map<String, TypeInformation<?>> initTableField(Connection connection, String selectSql) {
        try {
            String databaseDialect = connection.getMetaData().getDatabaseProductName();
            PreparedStatement preparedStatement = connection.prepareStatement(selectSql, 1003, 1007);
            preparedStatement.setMaxRows(1);
            try {
                ResultSetMetaData rsMeta = preparedStatement.getMetaData();
                return this.getRowInfo(rsMeta, databaseDialect);
            }
            catch (SQLException e) {
                ResultSet rs = preparedStatement.executeQuery();
                return this.getRowInfo(rs.getMetaData(), databaseDialect);
            }
        }
        catch (SQLException e) {
            LOGGER.warn("get row type info exception", (Throwable)e);
            return new LinkedHashMap();
        }
    }

    private Map<String, TypeInformation<?>> getRowInfo(ResultSetMetaData rsMeta, String databaseDialect) throws SQLException {
        LinkedHashMap map = new LinkedHashMap();
        if (rsMeta == null) {
            throw new SQLException("No result set metadata available to resolver row info!");
        }
        TypeInformationMap informationMapping = this.getTypeInformationMap(databaseDialect);
        for (int i = 1; i <= rsMeta.getColumnCount(); ++i) {
            String columnName = rsMeta.getColumnLabel(i);
            String columnTypeName = rsMeta.getColumnTypeName(i);
            if (columnTypeName == null) {
                throw new SQLException("Unsupported to get type info from result set metadata!");
            }
            map.put(columnName, informationMapping.getInformation(columnTypeName));
        }
        return map;
    }

    private RowTypeInfo getRowTypeInfo() {
        int size = this.tableFieldInfo.size();
        Set<String> fields = this.tableFieldInfo.keySet();
        TypeInformation[] typeInformation = new TypeInformation[size];
        String[] names = new String[size];
        int i = 0;
        for (String field : fields) {
            typeInformation[i] = this.tableFieldInfo.get(field);
            names[i] = field;
            ++i;
        }
        return new RowTypeInfo(typeInformation, names);
    }

    private TypeInformationMap getTypeInformationMap(String databaseDialect) {
        if (StringUtils.containsIgnoreCase((CharSequence)databaseDialect, (CharSequence)"mysql")) {
            return new MysqlTypeInformationMap();
        }
        if (StringUtils.containsIgnoreCase((CharSequence)databaseDialect, (CharSequence)"postgresql")) {
            return new PostgresTypeInformationMap();
        }
        if (StringUtils.containsIgnoreCase((CharSequence)databaseDialect, (CharSequence)"oracle")) {
            return new OracleTypeInformationMap();
        }
        if (StringUtils.containsIgnoreCase((CharSequence)databaseDialect, (CharSequence)"Hive")) {
            return new HiveTypeInformationMap();
        }
        return new DefaultTypeInformationMap();
    }
}

