/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ngram.NGramTokenizer;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenizerFactory;
import org.elasticsearch.index.analysis.CharMatcher;

public class NGramTokenizerFactory
extends AbstractTokenizerFactory {
    private final int minGram;
    private final int maxGram;
    private final CharMatcher matcher;
    static final Map<String, CharMatcher> MATCHERS;

    static CharMatcher parseTokenChars(List<String> characterClasses) {
        if (characterClasses == null || characterClasses.isEmpty()) {
            return null;
        }
        CharMatcher.Builder builder = new CharMatcher.Builder();
        for (String characterClass : characterClasses) {
            CharMatcher matcher = MATCHERS.get(characterClass = characterClass.toLowerCase(Locale.ROOT).trim());
            if (matcher == null) {
                throw new IllegalArgumentException("Unknown token type: '" + characterClass + "', must be one of " + MATCHERS.keySet());
            }
            builder.or(matcher);
        }
        return builder.build();
    }

    public NGramTokenizerFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        int maxAllowedNgramDiff = indexSettings.getMaxNgramDiff();
        this.minGram = settings.getAsInt("min_gram", 1);
        this.maxGram = settings.getAsInt("max_gram", 2);
        int ngramDiff = this.maxGram - this.minGram;
        if (ngramDiff > maxAllowedNgramDiff) {
            this.deprecationLogger.deprecated("Deprecated big difference between max_gram and min_gram in NGram Tokenizer,expected difference must be less than or equal to: [" + maxAllowedNgramDiff + "]", new Object[0]);
        }
        this.matcher = NGramTokenizerFactory.parseTokenChars(settings.getAsList("token_chars"));
    }

    @Override
    public Tokenizer create() {
        if (this.matcher == null) {
            return new NGramTokenizer(this.minGram, this.maxGram);
        }
        return new NGramTokenizer(this.minGram, this.maxGram){

            @Override
            protected boolean isTokenChar(int chr) {
                return NGramTokenizerFactory.this.matcher.isTokenChar(chr);
            }
        };
    }

    static {
        HashMap<String, CharMatcher> matchers = new HashMap<String, CharMatcher>();
        matchers.put("letter", CharMatcher.Basic.LETTER);
        matchers.put("digit", CharMatcher.Basic.DIGIT);
        matchers.put("whitespace", CharMatcher.Basic.WHITESPACE);
        matchers.put("punctuation", CharMatcher.Basic.PUNCTUATION);
        matchers.put("symbol", CharMatcher.Basic.SYMBOL);
        for (Field field : Character.class.getFields()) {
            if (field.getName().startsWith("DIRECTIONALITY") || !Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || field.getType() != Byte.TYPE) continue;
            try {
                matchers.put(field.getName().toLowerCase(Locale.ROOT), CharMatcher.ByUnicodeCategory.of(field.getByte(null)));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        MATCHERS = Collections.unmodifiableMap(matchers);
    }
}

