/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.seqno;

import com.carrotsearch.hppc.ObjectLongHashMap;
import com.carrotsearch.hppc.ObjectLongMap;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.routing.AllocationId;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ReplicationGroup;
import org.elasticsearch.index.shard.ShardId;

public class ReplicationTracker
extends AbstractIndexShardComponent
implements LongSupplier {
    final String shardAllocationId;
    volatile boolean primaryMode;
    boolean handoffInProgress;
    long appliedClusterStateVersion;
    IndexShardRoutingTable routingTable;
    final Map<String, CheckpointState> checkpoints;
    final Set<String> pendingInSync;
    volatile ReplicationGroup replicationGroup;

    public synchronized ObjectLongMap<String> getInSyncGlobalCheckpoints() {
        assert (this.primaryMode);
        assert (!this.handoffInProgress);
        ObjectLongHashMap<String> globalCheckpoints = new ObjectLongHashMap<String>(this.checkpoints.size());
        this.checkpoints.entrySet().stream().filter(e -> ((CheckpointState)e.getValue()).inSync).forEach(e -> globalCheckpoints.put((String)e.getKey(), ((CheckpointState)e.getValue()).globalCheckpoint));
        return globalCheckpoints;
    }

    public boolean isPrimaryMode() {
        return this.primaryMode;
    }

    private boolean invariant() {
        assert (this.checkpoints.get(this.shardAllocationId) != null) : "checkpoints map should always have an entry for the current shard";
        assert (this.primaryMode || this.checkpoints.values().stream().allMatch(lcps -> lcps.localCheckpoint == -2L || lcps.localCheckpoint == -3L));
        assert (this.primaryMode || this.checkpoints.entrySet().stream().filter(e -> !((String)e.getKey()).equals(this.shardAllocationId)).map(Map.Entry::getValue).allMatch(cps -> cps.globalCheckpoint == -2L || cps.globalCheckpoint == -3L));
        assert (!this.handoffInProgress || this.primaryMode);
        assert (!this.primaryMode || this.checkpoints.get((Object)this.shardAllocationId).inSync);
        assert (!this.primaryMode || this.routingTable != null && this.replicationGroup != null) : "primary mode but routing table is " + this.routingTable + " and replication group is " + this.replicationGroup;
        assert (!this.primaryMode || this.routingTable.primaryShard().allocationId().getId().equals(this.shardAllocationId) || this.routingTable.primaryShard().allocationId().getRelocationId().equals(this.shardAllocationId));
        assert (!this.handoffInProgress || this.pendingInSync.isEmpty()) : "entries blocking global checkpoint advancement during relocation handoff: " + this.pendingInSync;
        assert (this.pendingInSync.isEmpty() || this.primaryMode && !this.handoffInProgress);
        assert (!this.primaryMode || this.getGlobalCheckpoint() == ReplicationTracker.computeGlobalCheckpoint(this.pendingInSync, this.checkpoints.values(), this.getGlobalCheckpoint())) : "global checkpoint is not up-to-date, expected: " + ReplicationTracker.computeGlobalCheckpoint(this.pendingInSync, this.checkpoints.values(), this.getGlobalCheckpoint()) + " but was: " + this.getGlobalCheckpoint();
        assert (!this.primaryMode || this.getGlobalCheckpoint() <= ReplicationTracker.inSyncCheckpointStates(this.checkpoints, CheckpointState::getLocalCheckpoint, LongStream::min)) : "global checkpoint [" + this.getGlobalCheckpoint() + "] for primary mode allocation ID [" + this.shardAllocationId + "] more than in-sync local checkpoints [" + this.checkpoints + "]";
        assert (this.routingTable == null == (this.replicationGroup == null)) : "routing table is " + this.routingTable + " but replication group is " + this.replicationGroup;
        assert (this.replicationGroup == null || this.replicationGroup.equals(this.calculateReplicationGroup())) : "cached replication group out of sync: expected: " + this.calculateReplicationGroup() + " but was: " + this.replicationGroup;
        assert (this.routingTable == null || this.checkpoints.keySet().containsAll(this.routingTable.getAllAllocationIds())) : "local checkpoints " + this.checkpoints + " not in-sync with routing table " + this.routingTable;
        for (Map.Entry<String, CheckpointState> entry : this.checkpoints.entrySet()) {
            assert (!this.pendingInSync.contains(entry.getKey()) || !entry.getValue().inSync) : "shard copy " + entry.getKey() + " blocks global checkpoint advancement but is in-sync";
            assert (!entry.getValue().inSync || entry.getValue().tracked) : "shard copy " + entry.getKey() + " is in-sync but not tracked";
        }
        for (String aId : this.pendingInSync) {
            assert (this.checkpoints.get(aId) != null) : "aId [" + aId + "] is pending in sync but isn't tracked";
        }
        return true;
    }

    private static long inSyncCheckpointStates(Map<String, CheckpointState> checkpoints, ToLongFunction<CheckpointState> function, Function<LongStream, OptionalLong> reducer) {
        OptionalLong value = reducer.apply(checkpoints.values().stream().filter(cps -> cps.inSync).mapToLong(function).filter(v -> v != -3L && v != -2L));
        return value.isPresent() ? value.getAsLong() : -2L;
    }

    public ReplicationTracker(ShardId shardId, String allocationId, IndexSettings indexSettings, long globalCheckpoint) {
        super(shardId, indexSettings);
        assert (globalCheckpoint >= -2L) : "illegal initial global checkpoint: " + globalCheckpoint;
        this.shardAllocationId = allocationId;
        this.primaryMode = false;
        this.handoffInProgress = false;
        this.appliedClusterStateVersion = -1L;
        this.checkpoints = new HashMap<String, CheckpointState>(1 + indexSettings.getNumberOfReplicas());
        this.checkpoints.put(allocationId, new CheckpointState(-2L, globalCheckpoint, false, false));
        this.pendingInSync = new HashSet<String>();
        this.routingTable = null;
        this.replicationGroup = null;
        assert (this.invariant());
    }

    public ReplicationGroup getReplicationGroup() {
        assert (this.primaryMode);
        return this.replicationGroup;
    }

    private ReplicationGroup calculateReplicationGroup() {
        return new ReplicationGroup(this.routingTable, this.checkpoints.entrySet().stream().filter(e -> ((CheckpointState)e.getValue()).inSync).map(Map.Entry::getKey).collect(Collectors.toSet()), this.checkpoints.entrySet().stream().filter(e -> ((CheckpointState)e.getValue()).tracked).map(Map.Entry::getKey).collect(Collectors.toSet()));
    }

    public synchronized long getGlobalCheckpoint() {
        CheckpointState cps = this.checkpoints.get(this.shardAllocationId);
        assert (cps != null);
        return cps.globalCheckpoint;
    }

    @Override
    public long getAsLong() {
        return this.getGlobalCheckpoint();
    }

    public synchronized void updateGlobalCheckpointOnReplica(long globalCheckpoint, String reason) {
        assert (this.invariant());
        assert (!this.primaryMode);
        this.updateGlobalCheckpoint(this.shardAllocationId, globalCheckpoint, current -> this.logger.trace("updating global checkpoint from [{}] to [{}] due to [{}]", (Object)current, (Object)globalCheckpoint, (Object)reason));
        assert (this.invariant());
    }

    public synchronized void updateGlobalCheckpointForShard(String allocationId, long globalCheckpoint) {
        assert (this.primaryMode);
        assert (!this.handoffInProgress);
        assert (this.invariant());
        this.updateGlobalCheckpoint(allocationId, globalCheckpoint, current -> this.logger.trace("updating local knowledge for [{}] on the primary of the global checkpoint from [{}] to [{}]", (Object)allocationId, (Object)current, (Object)globalCheckpoint));
        assert (this.invariant());
    }

    private void updateGlobalCheckpoint(String allocationId, long globalCheckpoint, LongConsumer ifUpdated) {
        CheckpointState cps = this.checkpoints.get(allocationId);
        assert (!this.shardAllocationId.equals(allocationId) || cps != null);
        if (cps != null && globalCheckpoint > cps.globalCheckpoint) {
            ifUpdated.accept(cps.globalCheckpoint);
            cps.globalCheckpoint = globalCheckpoint;
        }
    }

    public synchronized void activatePrimaryMode(long localCheckpoint) {
        assert (this.invariant());
        assert (!this.primaryMode);
        assert (this.checkpoints.get(this.shardAllocationId) != null && this.checkpoints.get((Object)this.shardAllocationId).inSync && this.checkpoints.get((Object)this.shardAllocationId).localCheckpoint == -2L) : "expected " + this.shardAllocationId + " to have initialized entry in " + this.checkpoints + " when activating primary";
        assert (localCheckpoint >= -1L);
        this.primaryMode = true;
        this.updateLocalCheckpoint(this.shardAllocationId, this.checkpoints.get(this.shardAllocationId), localCheckpoint);
        this.updateGlobalCheckpointOnPrimary();
        assert (this.invariant());
    }

    public synchronized void updateFromMaster(long applyingClusterStateVersion, Set<String> inSyncAllocationIds, IndexShardRoutingTable routingTable, Set<String> pre60AllocationIds) {
        assert (this.invariant());
        if (applyingClusterStateVersion > this.appliedClusterStateVersion) {
            assert (!this.primaryMode || inSyncAllocationIds.stream().allMatch(inSyncId -> this.checkpoints.containsKey(inSyncId) && this.checkpoints.get((Object)inSyncId).inSync)) : "update from master in primary mode contains in-sync ids " + inSyncAllocationIds + " that have no matching entries in " + this.checkpoints;
            Set initializingAllocationIds = routingTable.getAllInitializingShards().stream().map(ShardRouting::allocationId).map(AllocationId::getId).collect(Collectors.toSet());
            boolean removedEntries = this.checkpoints.keySet().removeIf(aid -> !inSyncAllocationIds.contains(aid) && !initializingAllocationIds.contains(aid));
            if (this.primaryMode) {
                for (String initializingId : initializingAllocationIds) {
                    long localCheckpoint;
                    if (this.checkpoints.containsKey(initializingId)) continue;
                    boolean inSync = inSyncAllocationIds.contains(initializingId);
                    assert (!inSync) : "update from master in primary mode has " + initializingId + " as in-sync but it does not exist locally";
                    long globalCheckpoint = localCheckpoint = pre60AllocationIds.contains(initializingId) ? -3L : -2L;
                    this.checkpoints.put(initializingId, new CheckpointState(localCheckpoint, globalCheckpoint, inSync, inSync));
                }
                if (removedEntries) {
                    this.pendingInSync.removeIf(aId -> !this.checkpoints.containsKey(aId));
                }
            } else {
                long globalCheckpoint;
                for (String initializingId : initializingAllocationIds) {
                    long localCheckpoint;
                    if (this.shardAllocationId.equals(initializingId)) continue;
                    globalCheckpoint = localCheckpoint = pre60AllocationIds.contains(initializingId) ? -3L : -2L;
                    this.checkpoints.put(initializingId, new CheckpointState(localCheckpoint, globalCheckpoint, false, false));
                }
                for (String inSyncId2 : inSyncAllocationIds) {
                    long localCheckpoint;
                    if (this.shardAllocationId.equals(inSyncId2)) {
                        CheckpointState checkpointState = this.checkpoints.get(this.shardAllocationId);
                        checkpointState.inSync = true;
                        checkpointState.tracked = true;
                        continue;
                    }
                    globalCheckpoint = localCheckpoint = pre60AllocationIds.contains(inSyncId2) ? -3L : -2L;
                    this.checkpoints.put(inSyncId2, new CheckpointState(localCheckpoint, globalCheckpoint, true, true));
                }
            }
            this.appliedClusterStateVersion = applyingClusterStateVersion;
            this.routingTable = routingTable;
            this.replicationGroup = this.calculateReplicationGroup();
            if (this.primaryMode && removedEntries) {
                this.updateGlobalCheckpointOnPrimary();
                this.notifyAllWaiters();
            }
        }
        assert (this.invariant());
    }

    public synchronized void initiateTracking(String allocationId) {
        assert (this.invariant());
        assert (this.primaryMode);
        assert (!this.handoffInProgress);
        CheckpointState cps = this.checkpoints.get(allocationId);
        if (cps == null) {
            throw new IllegalStateException("no local checkpoint tracking information available");
        }
        cps.tracked = true;
        this.replicationGroup = this.calculateReplicationGroup();
        assert (this.invariant());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void markAllocationIdAsInSync(String allocationId, long localCheckpoint) throws InterruptedException {
        assert (this.invariant());
        assert (this.primaryMode);
        assert (!this.handoffInProgress);
        CheckpointState cps = this.checkpoints.get(allocationId);
        if (cps == null) {
            throw new IllegalStateException("no local checkpoint tracking information available for " + allocationId);
        }
        assert (localCheckpoint >= -1L) : "expected known local checkpoint for " + allocationId + " but was " + localCheckpoint;
        assert (!this.pendingInSync.contains(allocationId)) : "shard copy " + allocationId + " is already marked as pending in-sync";
        assert (cps.tracked) : "shard copy " + allocationId + " cannot be marked as in-sync as it's not tracked";
        this.updateLocalCheckpoint(allocationId, cps, localCheckpoint);
        assert (!cps.inSync || cps.localCheckpoint >= this.getGlobalCheckpoint()) : "shard copy " + allocationId + " that's already in-sync should have a local checkpoint " + cps.localCheckpoint + " that's above the global checkpoint " + this.getGlobalCheckpoint();
        if (cps.localCheckpoint < this.getGlobalCheckpoint()) {
            this.pendingInSync.add(allocationId);
            try {
                while (this.pendingInSync.contains(allocationId)) {
                    this.waitForLocalCheckpointToAdvance();
                }
            }
            finally {
                this.pendingInSync.remove(allocationId);
            }
        } else {
            cps.inSync = true;
            this.replicationGroup = this.calculateReplicationGroup();
            this.logger.trace("marked [{}] as in-sync", (Object)allocationId);
            this.updateGlobalCheckpointOnPrimary();
        }
        assert (this.invariant());
    }

    private boolean updateLocalCheckpoint(String allocationId, CheckpointState cps, long localCheckpoint) {
        assert (cps.localCheckpoint != -3L || localCheckpoint == -3L) : "pre-6.0 shard copy " + allocationId + " unexpected to send valid local checkpoint " + localCheckpoint;
        assert (localCheckpoint != -2L) : "invalid local checkpoint for shard copy [" + allocationId + "]";
        if (localCheckpoint > cps.localCheckpoint) {
            this.logger.trace("updated local checkpoint of [{}] from [{}] to [{}]", (Object)allocationId, (Object)cps.localCheckpoint, (Object)localCheckpoint);
            cps.localCheckpoint = localCheckpoint;
            return true;
        }
        this.logger.trace("skipped updating local checkpoint of [{}] from [{}] to [{}], current checkpoint is higher", (Object)allocationId, (Object)cps.localCheckpoint, (Object)localCheckpoint);
        return false;
    }

    public synchronized void updateLocalCheckpoint(String allocationId, long localCheckpoint) {
        assert (this.invariant());
        assert (this.primaryMode);
        assert (!this.handoffInProgress);
        CheckpointState cps = this.checkpoints.get(allocationId);
        if (cps == null) {
            return;
        }
        boolean increasedLocalCheckpoint = this.updateLocalCheckpoint(allocationId, cps, localCheckpoint);
        boolean pending = this.pendingInSync.contains(allocationId);
        if (pending && cps.localCheckpoint >= this.getGlobalCheckpoint()) {
            this.pendingInSync.remove(allocationId);
            pending = false;
            cps.inSync = true;
            this.replicationGroup = this.calculateReplicationGroup();
            this.logger.trace("marked [{}] as in-sync", (Object)allocationId);
            this.notifyAllWaiters();
        }
        if (increasedLocalCheckpoint && !pending) {
            this.updateGlobalCheckpointOnPrimary();
        }
        assert (this.invariant());
    }

    private static long computeGlobalCheckpoint(Set<String> pendingInSync, Collection<CheckpointState> localCheckpoints, long fallback) {
        long minLocalCheckpoint = Long.MAX_VALUE;
        if (!pendingInSync.isEmpty()) {
            return fallback;
        }
        for (CheckpointState cps : localCheckpoints) {
            if (!cps.inSync) continue;
            if (cps.localCheckpoint == -2L) {
                return fallback;
            }
            if (cps.localCheckpoint == -3L) continue;
            minLocalCheckpoint = Math.min(cps.localCheckpoint, minLocalCheckpoint);
        }
        assert (minLocalCheckpoint != Long.MAX_VALUE);
        return minLocalCheckpoint;
    }

    private synchronized void updateGlobalCheckpointOnPrimary() {
        assert (this.primaryMode);
        CheckpointState cps = this.checkpoints.get(this.shardAllocationId);
        long globalCheckpoint = cps.globalCheckpoint;
        long computedGlobalCheckpoint = ReplicationTracker.computeGlobalCheckpoint(this.pendingInSync, this.checkpoints.values(), this.getGlobalCheckpoint());
        assert (computedGlobalCheckpoint >= globalCheckpoint) : "new global checkpoint [" + computedGlobalCheckpoint + "] is lower than previous one [" + globalCheckpoint + "]";
        if (globalCheckpoint != computedGlobalCheckpoint) {
            this.logger.trace("global checkpoint updated to [{}]", (Object)computedGlobalCheckpoint);
            cps.globalCheckpoint = computedGlobalCheckpoint;
        }
    }

    public synchronized PrimaryContext startRelocationHandoff() {
        assert (this.invariant());
        assert (this.primaryMode);
        assert (!this.handoffInProgress);
        assert (this.pendingInSync.isEmpty()) : "relocation handoff started while there are still shard copies pending in-sync: " + this.pendingInSync;
        this.handoffInProgress = true;
        HashMap<String, CheckpointState> localCheckpointsCopy = new HashMap<String, CheckpointState>();
        for (Map.Entry<String, CheckpointState> entry : this.checkpoints.entrySet()) {
            localCheckpointsCopy.put(entry.getKey(), entry.getValue().copy());
        }
        assert (this.invariant());
        return new PrimaryContext(this.appliedClusterStateVersion, localCheckpointsCopy, this.routingTable);
    }

    public synchronized void abortRelocationHandoff() {
        assert (this.invariant());
        assert (this.primaryMode);
        assert (this.handoffInProgress);
        this.handoffInProgress = false;
        assert (this.invariant());
    }

    public synchronized void completeRelocationHandoff() {
        assert (this.invariant());
        assert (this.primaryMode);
        assert (this.handoffInProgress);
        this.primaryMode = false;
        this.handoffInProgress = false;
        this.checkpoints.entrySet().stream().forEach(e -> {
            CheckpointState cps = (CheckpointState)e.getValue();
            if (cps.localCheckpoint != -2L && cps.localCheckpoint != -3L) {
                cps.localCheckpoint = -2L;
            }
            if (!((String)e.getKey()).equals(this.shardAllocationId) && cps.globalCheckpoint != -2L && cps.globalCheckpoint != -3L) {
                cps.globalCheckpoint = -2L;
            }
        });
        assert (this.invariant());
    }

    public synchronized void activateWithPrimaryContext(PrimaryContext primaryContext) {
        assert (this.invariant());
        assert (!this.primaryMode);
        Runnable runAfter = this.getMasterUpdateOperationFromCurrentState();
        this.primaryMode = true;
        this.appliedClusterStateVersion = primaryContext.clusterStateVersion();
        this.checkpoints.clear();
        for (Map.Entry entry : primaryContext.checkpoints.entrySet()) {
            this.checkpoints.put((String)entry.getKey(), ((CheckpointState)entry.getValue()).copy());
        }
        this.routingTable = primaryContext.getRoutingTable();
        this.replicationGroup = this.calculateReplicationGroup();
        this.updateGlobalCheckpointOnPrimary();
        runAfter.run();
        assert (this.invariant());
    }

    private Runnable getMasterUpdateOperationFromCurrentState() {
        assert (!this.primaryMode);
        long lastAppliedClusterStateVersion = this.appliedClusterStateVersion;
        HashSet inSyncAllocationIds = new HashSet();
        HashSet pre60AllocationIds = new HashSet();
        this.checkpoints.entrySet().forEach(entry -> {
            if (((CheckpointState)entry.getValue()).inSync) {
                inSyncAllocationIds.add((String)entry.getKey());
            }
            if (((CheckpointState)entry.getValue()).getLocalCheckpoint() == -3L) {
                pre60AllocationIds.add((String)entry.getKey());
            }
        });
        IndexShardRoutingTable lastAppliedRoutingTable = this.routingTable;
        return () -> this.updateFromMaster(lastAppliedClusterStateVersion, inSyncAllocationIds, lastAppliedRoutingTable, pre60AllocationIds);
    }

    public synchronized boolean pendingInSync() {
        assert (this.primaryMode);
        return !this.pendingInSync.isEmpty();
    }

    public synchronized CheckpointState getTrackedLocalCheckpointForShard(String allocationId) {
        assert (this.primaryMode);
        return this.checkpoints.get(allocationId);
    }

    @SuppressForbidden(reason="Object#notifyAll waiters for local checkpoint advancement")
    private synchronized void notifyAllWaiters() {
        this.notifyAll();
    }

    @SuppressForbidden(reason="Object#wait for local checkpoint advancement")
    private synchronized void waitForLocalCheckpointToAdvance() throws InterruptedException {
        this.wait();
    }

    public static class PrimaryContext
    implements Writeable {
        private final long clusterStateVersion;
        private final Map<String, CheckpointState> checkpoints;
        private final IndexShardRoutingTable routingTable;

        public PrimaryContext(long clusterStateVersion, Map<String, CheckpointState> checkpoints, IndexShardRoutingTable routingTable) {
            this.clusterStateVersion = clusterStateVersion;
            this.checkpoints = checkpoints;
            this.routingTable = routingTable;
        }

        public PrimaryContext(StreamInput in) throws IOException {
            this.clusterStateVersion = in.readVLong();
            this.checkpoints = in.readMap(StreamInput::readString, CheckpointState::new);
            this.routingTable = IndexShardRoutingTable.Builder.readFrom(in);
        }

        public long clusterStateVersion() {
            return this.clusterStateVersion;
        }

        public Map<String, CheckpointState> getCheckpointStates() {
            return this.checkpoints;
        }

        public IndexShardRoutingTable getRoutingTable() {
            return this.routingTable;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.clusterStateVersion);
            out.writeMap(this.checkpoints, (streamOutput, s) -> out.writeString((String)s), (streamOutput, cps) -> cps.writeTo(out));
            IndexShardRoutingTable.Builder.writeTo(this.routingTable, out);
        }

        public String toString() {
            return "PrimaryContext{clusterStateVersion=" + this.clusterStateVersion + ", checkpoints=" + this.checkpoints + ", routingTable=" + this.routingTable + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PrimaryContext that = (PrimaryContext)o;
            if (this.clusterStateVersion != that.clusterStateVersion) {
                return false;
            }
            if (this.routingTable.equals(that.routingTable)) {
                return false;
            }
            return this.routingTable.equals(that.routingTable);
        }

        public int hashCode() {
            int result = Long.hashCode(this.clusterStateVersion);
            result = 31 * result + this.checkpoints.hashCode();
            result = 31 * result + this.routingTable.hashCode();
            return result;
        }
    }

    public static class CheckpointState
    implements Writeable {
        long localCheckpoint;
        long globalCheckpoint;
        boolean inSync;
        boolean tracked;

        public CheckpointState(long localCheckpoint, long globalCheckpoint, boolean inSync, boolean tracked) {
            this.localCheckpoint = localCheckpoint;
            this.globalCheckpoint = globalCheckpoint;
            this.inSync = inSync;
            this.tracked = tracked;
        }

        public CheckpointState(StreamInput in) throws IOException {
            this.localCheckpoint = in.readZLong();
            this.globalCheckpoint = in.readZLong();
            this.inSync = in.readBoolean();
            this.tracked = in.getVersion().onOrAfter(Version.V_6_3_0) ? in.readBoolean() : this.inSync;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeZLong(this.localCheckpoint);
            out.writeZLong(this.globalCheckpoint);
            out.writeBoolean(this.inSync);
            if (out.getVersion().onOrAfter(Version.V_6_3_0)) {
                out.writeBoolean(this.tracked);
            }
        }

        public CheckpointState copy() {
            return new CheckpointState(this.localCheckpoint, this.globalCheckpoint, this.inSync, this.tracked);
        }

        public long getLocalCheckpoint() {
            return this.localCheckpoint;
        }

        public long getGlobalCheckpoint() {
            return this.globalCheckpoint;
        }

        public String toString() {
            return "LocalCheckpointState{localCheckpoint=" + this.localCheckpoint + ", globalCheckpoint=" + this.globalCheckpoint + ", inSync=" + this.inSync + ", tracked=" + this.tracked + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CheckpointState that = (CheckpointState)o;
            if (this.localCheckpoint != that.localCheckpoint) {
                return false;
            }
            if (this.globalCheckpoint != that.globalCheckpoint) {
                return false;
            }
            if (this.inSync != that.inSync) {
                return false;
            }
            return this.tracked == that.tracked;
        }

        public int hashCode() {
            int result = Long.hashCode(this.localCheckpoint);
            result = 31 * result + Long.hashCode(this.globalCheckpoint);
            result = 31 * result + Boolean.hashCode(this.inSync);
            result = 31 * result + Boolean.hashCode(this.tracked);
            return result;
        }
    }
}

