/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.indices.TypeMissingException;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;

public class RestGetMappingAction
extends BaseRestHandler {
    public RestGetMappingAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_mapping", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mappings", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mapping", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mappings/{type}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mapping/{type}", this);
        controller.registerHandler(RestRequest.Method.HEAD, "/{index}/_mapping/{type}", this);
        controller.registerHandler(RestRequest.Method.GET, "/_mapping/{type}", this);
    }

    @Override
    public String getName() {
        return "get_mapping_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        final String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        final String[] types = request.paramAsStringArrayOrEmptyIfAll("type");
        GetMappingsRequest getMappingsRequest = new GetMappingsRequest();
        ((GetMappingsRequest)getMappingsRequest.indices(indices)).types(types);
        getMappingsRequest.indicesOptions(IndicesOptions.fromRequest(request, getMappingsRequest.indicesOptions()));
        getMappingsRequest.local(request.paramAsBoolean("local", getMappingsRequest.local()));
        return channel -> client.admin().indices().getMappings(getMappingsRequest, (ActionListener<GetMappingsResponse>)new RestBuilderListener<GetMappingsResponse>(channel){

            @Override
            public RestResponse buildResponse(GetMappingsResponse response, XContentBuilder builder) throws Exception {
                RestStatus status;
                ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>> mappingsByIndex = response.getMappings();
                if (mappingsByIndex.isEmpty() && (indices.length != 0 || types.length != 0)) {
                    if (indices.length != 0 && types.length == 0) {
                        builder.close();
                        return new BytesRestResponse(this.channel, new IndexNotFoundException(String.join((CharSequence)",", indices)));
                    }
                    builder.close();
                    return new BytesRestResponse(this.channel, new TypeMissingException("_all", String.join((CharSequence)",", types)));
                }
                HashSet<String> typeNames = new HashSet<String>();
                for (ObjectCursor<ImmutableOpenMap<String, MappingMetaData>> objectCursor : mappingsByIndex.values()) {
                    for (ObjectCursor inner : ((ImmutableOpenMap)objectCursor.value).keys()) {
                        typeNames.add((String)inner.value);
                    }
                }
                SortedSet<String> difference = Sets.sortedDifference(Arrays.stream(types).collect(Collectors.toSet()), typeNames);
                ArrayList<String> arrayList = new ArrayList<String>();
                block2: for (String pattern : difference) {
                    if (!pattern.contains("*")) continue;
                    for (String typeName : typeNames) {
                        if (!Regex.simpleMatch(pattern, typeName)) continue;
                        arrayList.add(pattern);
                        continue block2;
                    }
                }
                difference.removeAll(arrayList);
                builder.startObject();
                if (difference.isEmpty()) {
                    status = RestStatus.OK;
                } else {
                    status = RestStatus.NOT_FOUND;
                    String message = difference.size() == 1 ? String.format(Locale.ROOT, "type [%s] missing", RestGetMappingAction.toNamesString(new String[]{(String)difference.iterator().next()})) : String.format(Locale.ROOT, "types [%s] missing", RestGetMappingAction.toNamesString(difference.toArray(new String[0])));
                    builder.field("error", message);
                    builder.field("status", status.getStatus());
                }
                for (ObjectObjectCursor<String, ImmutableOpenMap<String, MappingMetaData>> objectObjectCursor : mappingsByIndex) {
                    builder.startObject((String)objectObjectCursor.key);
                    builder.startObject("mappings");
                    for (ObjectObjectCursor typeEntry : (ImmutableOpenMap)objectObjectCursor.value) {
                        builder.field((String)typeEntry.key, ((MappingMetaData)typeEntry.value).sourceAsMap());
                    }
                    builder.endObject();
                    builder.endObject();
                }
                builder.endObject();
                return new BytesRestResponse(status, builder);
            }
        });
    }

    private static String toNamesString(String ... names) {
        return Arrays.stream(names).collect(Collectors.joining(","));
    }
}

