/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.dfs;

import com.carrotsearch.hppc.ObjectHashSet;
import com.carrotsearch.hppc.ObjectObjectHashMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.io.IOException;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.TermStatistics;
import org.elasticsearch.common.collect.HppcMaps;
import org.elasticsearch.search.SearchPhase;
import org.elasticsearch.search.dfs.DfsPhaseExecutionException;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.rescore.RescoreContext;
import org.elasticsearch.tasks.TaskCancelledException;

public class DfsPhase
implements SearchPhase {
    @Override
    public void preProcess(SearchContext context) {
    }

    @Override
    public void execute(SearchContext context) {
        ObjectHashSet termsSet = new ObjectHashSet();
        try {
            context.searcher().createNormalizedWeight(context.query(), true).extractTerms(new DelegateSet(termsSet));
            for (RescoreContext rescoreContext : context.rescore()) {
                try {
                    rescoreContext.rescorer().extractTerms(context.searcher(), rescoreContext, new DelegateSet(termsSet));
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to extract terms", e);
                }
            }
            Term[] terms = (Term[])termsSet.toArray(Term.class);
            TermStatistics[] termStatistics = new TermStatistics[terms.length];
            IndexReaderContext indexReaderContext = context.searcher().getTopReaderContext();
            for (int i = 0; i < terms.length; ++i) {
                if (context.isCancelled()) {
                    throw new TaskCancelledException("cancelled");
                }
                TermContext termContext = TermContext.build(indexReaderContext, terms[i]);
                termStatistics[i] = context.searcher().termStatistics(terms[i], termContext);
            }
            ObjectObjectHashMap<String, CollectionStatistics> fieldStatistics = HppcMaps.newNoNullKeysMap();
            for (Term term : terms) {
                assert (term.field() != null) : "field is null";
                if (fieldStatistics.containsKey(term.field())) continue;
                CollectionStatistics collectionStatistics = context.searcher().collectionStatistics(term.field());
                fieldStatistics.put(term.field(), collectionStatistics);
                if (!context.isCancelled()) continue;
                throw new TaskCancelledException("cancelled");
            }
            context.dfsResult().termsStatistics(terms, termStatistics).fieldStatistics(fieldStatistics).maxDoc(context.searcher().getIndexReader().maxDoc());
        }
        catch (Exception e) {
            throw new DfsPhaseExecutionException(context, "Exception during dfs phase", (Throwable)e);
        }
        finally {
            termsSet.clear();
        }
    }

    private static class DelegateSet
    extends AbstractSet<Term> {
        private final ObjectHashSet<Term> delegate;

        private DelegateSet(ObjectHashSet<Term> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean add(Term term) {
            return this.delegate.add(term);
        }

        @Override
        public boolean addAll(Collection<? extends Term> terms) {
            boolean result = false;
            for (Term term : terms) {
                result = this.delegate.add(term);
            }
            return result;
        }

        @Override
        public Iterator<Term> iterator() {
            final Iterator<ObjectCursor<Term>> iterator = this.delegate.iterator();
            return new Iterator<Term>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Term next() {
                    return (Term)((ObjectCursor)iterator.next()).value;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return this.delegate.size();
        }
    }
}

