/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonzou.jmockdata;

import com.github.jsonzou.jmockdata.BeanMockerInterceptor;
import com.github.jsonzou.jmockdata.DataConfig;
import com.github.jsonzou.jmockdata.Mocker;
import com.github.jsonzou.jmockdata.annotation.MockIgnore;
import com.github.jsonzou.jmockdata.mocker.BigDecimalMocker;
import com.github.jsonzou.jmockdata.mocker.BigIntegerMocker;
import com.github.jsonzou.jmockdata.mocker.BooleanMocker;
import com.github.jsonzou.jmockdata.mocker.ByteMocker;
import com.github.jsonzou.jmockdata.mocker.CharacterMocker;
import com.github.jsonzou.jmockdata.mocker.DateMocker;
import com.github.jsonzou.jmockdata.mocker.DoubleMocker;
import com.github.jsonzou.jmockdata.mocker.FloatMocker;
import com.github.jsonzou.jmockdata.mocker.IntegerMocker;
import com.github.jsonzou.jmockdata.mocker.LocalDateMocker;
import com.github.jsonzou.jmockdata.mocker.LocalDateTimeMocker;
import com.github.jsonzou.jmockdata.mocker.LocalTimeMocker;
import com.github.jsonzou.jmockdata.mocker.LongMocker;
import com.github.jsonzou.jmockdata.mocker.ShortMocker;
import com.github.jsonzou.jmockdata.mocker.StringMocker;
import com.github.jsonzou.jmockdata.mocker.TimestampMocker;
import com.github.jsonzou.jmockdata.util.FieldMatchingResolver;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MockConfig {
    private static final ByteMocker BYTE_MOCKER = new ByteMocker();
    private static final BooleanMocker BOOLEAN_MOCKER = new BooleanMocker();
    private static final CharacterMocker CHARACTER_MOCKER = new CharacterMocker();
    private static final ShortMocker SHORT_MOCKER = new ShortMocker();
    private static final IntegerMocker INTEGER_MOCKER = new IntegerMocker();
    private static final LongMocker LONG_MOCKER = new LongMocker();
    private static final FloatMocker FLOAT_MOCKER = new FloatMocker();
    private static final DoubleMocker DOUBLE_MOCKER = new DoubleMocker();
    private static final BigIntegerMocker BIG_INTEGER_MOCKER = new BigIntegerMocker();
    private static final BigDecimalMocker BIG_DECIMAL_MOCKER = new BigDecimalMocker();
    private static final StringMocker STRING_MOCKER = new StringMocker();
    private static final DateMocker DATE_MOCKER = new DateMocker();
    private static final LocalDateTimeMocker LOCAL_DATE_TIME_MOCKER = new LocalDateTimeMocker();
    private static final LocalDateMocker LOCAL_DATE_MOCKER = new LocalDateMocker();
    private static final LocalTimeMocker LOCAL_TIME_MOCKER = new LocalTimeMocker();
    private static final TimestampMocker TIMESTAMP_MOCKER = new TimestampMocker();
    private boolean enabledCircle = false;
    private boolean enabledStatic = false;
    private boolean enabledPublic = true;
    private boolean enabledProtected = true;
    private boolean enabledPrivate = true;
    private Map<String, Object> beanCache = new HashMap<String, Object>(16);
    private Map<String, Type> typeVariableCache = new HashMap<String, Type>(8);
    private Map<String, Enum[]> enumCache = new HashMap<String, Enum[]>(4);
    private Map<Class<?>, Mocker> mockerContext = new HashMap(32);
    private Map<Class<?>, BeanMockerInterceptor> beanMockerInterceptors = new HashMap(4);
    private DataConfig GLOBAL_DATA_CONFIG = new DataConfig(this);
    private Map<String, DataConfig> partDataConfig = new HashMap<String, DataConfig>(16);
    private Map<Class<?>, List<String>> excludeConfig = new HashMap(4);

    public MockConfig() {
        this.registerMocker(BYTE_MOCKER, Byte.TYPE, Byte.class);
        this.registerMocker(BOOLEAN_MOCKER, Boolean.TYPE, Boolean.class);
        this.registerMocker(CHARACTER_MOCKER, Character.TYPE, Character.class);
        this.registerMocker(SHORT_MOCKER, Short.TYPE, Short.class);
        this.registerMocker(INTEGER_MOCKER, Integer.class, Integer.TYPE);
        this.registerMocker(LONG_MOCKER, Long.TYPE, Long.class);
        this.registerMocker(FLOAT_MOCKER, Float.TYPE, Float.class);
        this.registerMocker(DOUBLE_MOCKER, Double.TYPE, Double.class);
        this.registerMocker(BIG_INTEGER_MOCKER, BigInteger.class);
        this.registerMocker(BIG_DECIMAL_MOCKER, BigDecimal.class);
        this.registerMocker(STRING_MOCKER, String.class);
        this.registerMocker(DATE_MOCKER, Date.class);
        this.registerMocker(LOCAL_DATE_TIME_MOCKER, LocalDateTime.class);
        this.registerMocker(LOCAL_DATE_MOCKER, LocalDate.class);
        this.registerMocker(LOCAL_TIME_MOCKER, LocalTime.class);
        this.registerMocker(TIMESTAMP_MOCKER, Timestamp.class);
    }

    public static MockConfig newInstance() {
        return new MockConfig();
    }

    public void cacheBean(String name, Object bean) {
        this.beanCache.put(name, bean);
    }

    public Object getcacheBean(String beanClassName) {
        return this.beanCache.get(beanClassName);
    }

    public void cacheEnum(String name, Enum[] enums) {
        this.enumCache.put(name, enums);
    }

    public Enum[] getcacheEnum(String enumClassName) {
        return this.enumCache.get(enumClassName);
    }

    public MockConfig init(Type type) {
        if (type instanceof ParameterizedType) {
            Class clazz = (Class)((ParameterizedType)type).getRawType();
            Type[] types = ((ParameterizedType)type).getActualTypeArguments();
            TypeVariable<Class<T>>[] typeVariables = clazz.getTypeParameters();
            if (typeVariables != null && typeVariables.length > 0) {
                for (int index = 0; index < typeVariables.length; ++index) {
                    this.typeVariableCache.put(typeVariables[index].getName(), types[index]);
                }
            }
        }
        return this;
    }

    public boolean isEnabledCircle() {
        return this.enabledCircle;
    }

    public MockConfig setEnabledCircle(boolean enabledCircle) {
        this.enabledCircle = enabledCircle;
        return this;
    }

    public MockConfig setEnabledStatic(boolean enabledStatic) {
        this.enabledStatic = enabledStatic;
        return this;
    }

    public boolean isEnabledStatic() {
        return this.enabledStatic;
    }

    public MockConfig setEnabledPublic(boolean enabledPublic) {
        this.enabledPublic = enabledPublic;
        return this;
    }

    public boolean isEnabledPublic() {
        return this.enabledPublic;
    }

    public MockConfig setEnabledProtected(boolean enabledProtected) {
        this.enabledProtected = enabledProtected;
        return this;
    }

    public boolean isEnabledProtected() {
        return this.enabledProtected;
    }

    public MockConfig setEnabledPrivate(boolean enabledPrivate) {
        this.enabledPrivate = enabledPrivate;
        return this;
    }

    public boolean isEnabledPrivate() {
        return this.enabledPrivate;
    }

    public Type getVariableType(String name) {
        return this.typeVariableCache.get(name);
    }

    public <T> void registerMocker(Mocker mocker, Class<T> ... clazzs) {
        for (Class<T> clazz : clazzs) {
            this.mockerContext.put(clazz, mocker);
        }
    }

    public <T> MockConfig registerBeanMockerInterceptor(Class<T> clazz, BeanMockerInterceptor bi) {
        this.beanMockerInterceptors.put(clazz, bi);
        return this;
    }

    public <T> MockConfig registerBeanMockerInterceptor(BeanMockerInterceptor bi) {
        this.beanMockerInterceptors.put(MockConfig.class, bi);
        return this;
    }

    public <T> BeanMockerInterceptor getBeanMockerInterceptor(Class<T> clazz) {
        if (this.beanMockerInterceptors.size() == 0) {
            return null;
        }
        BeanMockerInterceptor bi = this.beanMockerInterceptors.get(clazz);
        if (bi == null) {
            return this.beanMockerInterceptors.get(MockConfig.class);
        }
        return bi;
    }

    public <T> Mocker<T> getMocker(Class<T> clazz) {
        return this.mockerContext.get(clazz);
    }

    public MockConfig globalConfig() {
        return this;
    }

    public DataConfig subConfig(String ... fieldNames) {
        return this.subConfig(DataConfig.class, fieldNames);
    }

    public <T> DataConfig subConfig(Class<T> clazz, String ... fieldNames) {
        String clazzName = clazz.getName();
        DataConfig config = this.partDataConfig.get(clazzName);
        if (fieldNames.length == 0) {
            if (config == null) {
                config = new DataConfig(this);
                this.partDataConfig.put(clazzName, config);
            }
            return config;
        }
        config = null;
        for (String fieldName : fieldNames) {
            config = this.partDataConfig.get(clazzName + "#" + fieldName);
            if (config != null) break;
        }
        if (config == null) {
            config = new DataConfig(this);
        }
        for (String fieldName : fieldNames) {
            this.partDataConfig.put(clazzName + "#" + fieldName, config);
        }
        return config;
    }

    public <T> DataConfig getDataConfig(Class<T> clazz, String fieldName) {
        Set<String> configKeys = this.partDataConfig.keySet();
        String clazzName = clazz.getName();
        if (fieldName == null) {
            return this.partDataConfig.get(clazzName) == null ? this.GLOBAL_DATA_CONFIG : this.partDataConfig.get(clazzName);
        }
        DataConfig config = this.partDataConfig.get(clazzName + "#" + fieldName);
        if (config == null) {
            for (String fieldPatternKey : configKeys) {
                if (!fieldPatternKey.startsWith(clazzName + "#") || !FieldMatchingResolver.isMatchPattern(fieldName, fieldPatternKey.split("#")[1])) continue;
                return this.partDataConfig.get(fieldPatternKey);
            }
        }
        if (config == null) {
            clazzName = DataConfig.class.getName();
            config = this.partDataConfig.get(clazzName + "#" + fieldName);
        }
        if (config == null) {
            config = this.partDataConfig.get(clazzName);
        }
        if (config == null) {
            for (String fieldPatternKey : configKeys) {
                if (!fieldPatternKey.startsWith(clazzName + "#") || !FieldMatchingResolver.isMatchPattern(fieldName, fieldPatternKey.split("#")[1])) continue;
                return this.partDataConfig.get(fieldPatternKey);
            }
        }
        if (config == null) {
            config = this.GLOBAL_DATA_CONFIG;
        }
        return config;
    }

    public DataConfig globalDataConfig() {
        return this.GLOBAL_DATA_CONFIG;
    }

    public <T> MockConfig excludes(Class<T> clazz, String ... fieldName) {
        this.excludeConfig.put(clazz, Arrays.asList(fieldName));
        return this;
    }

    public MockConfig excludes(String ... fieldNames) {
        this.excludeConfig.put(MockIgnore.class, Arrays.asList(fieldNames));
        return this;
    }

    public <T> boolean isConfigExcludeMock(Class<T> clazz) {
        return this.excludeConfig.get(clazz) != null && this.excludeConfig.get(clazz).size() == 0;
    }

    public <T> boolean isConfigExcludeMock(Class<T> clazz, String fieldName) {
        List<String> fieldsConfig1 = this.excludeConfig.get(clazz);
        List<String> fieldsConfig2 = this.excludeConfig.get(MockIgnore.class);
        ArrayList<String> fieldsConfig = new ArrayList<String>();
        if (fieldsConfig1 != null) {
            fieldsConfig.addAll(fieldsConfig1);
        }
        if (fieldsConfig2 != null) {
            fieldsConfig.addAll(fieldsConfig2);
        }
        if (fieldsConfig.contains(fieldName)) {
            return true;
        }
        boolean isExclude = false;
        for (String fieldPattern : fieldsConfig) {
            isExclude = FieldMatchingResolver.isMatchPattern(fieldName, fieldPattern);
            if (!isExclude) continue;
            return isExclude;
        }
        return isExclude;
    }

    public MockConfig byteRange(byte min, byte max) {
        this.GLOBAL_DATA_CONFIG.byteRange(min, max);
        return this;
    }

    public MockConfig booleanSeed(boolean ... booleanSeed) {
        this.GLOBAL_DATA_CONFIG.booleanSeed(booleanSeed);
        return this;
    }

    public MockConfig shortRange(short min, short max) {
        this.GLOBAL_DATA_CONFIG.shortRange(min, max);
        return this;
    }

    public MockConfig intRange(int min, int max) {
        this.GLOBAL_DATA_CONFIG.intRange(min, max);
        return this;
    }

    public MockConfig floatRange(float min, float max) {
        this.GLOBAL_DATA_CONFIG.floatRange(min, max);
        return this;
    }

    public MockConfig doubleRange(double min, double max) {
        this.GLOBAL_DATA_CONFIG.doubleRange(min, max);
        return this;
    }

    public MockConfig decimalScale(int scale) {
        this.GLOBAL_DATA_CONFIG.decimalScale(scale);
        return this;
    }

    public MockConfig longRange(long min, long max) {
        this.GLOBAL_DATA_CONFIG.longRange(min, max);
        return this;
    }

    public MockConfig dateRange(String min, String max) {
        this.GLOBAL_DATA_CONFIG.dateRange(min, max);
        return this;
    }

    public MockConfig timeRange(int minHour, int maxHour, int minMinute, int maxMinute, int minSecond, int maxSecond) {
        this.GLOBAL_DATA_CONFIG.timeRange(minHour, maxHour, minMinute, maxMinute, minSecond, maxSecond);
        return this;
    }

    public MockConfig sizeRange(int min, int max) {
        this.GLOBAL_DATA_CONFIG.sizeRange(min, max);
        return this;
    }

    public MockConfig stringSeed(String ... stringSeed) {
        this.GLOBAL_DATA_CONFIG.stringSeed(stringSeed);
        return this;
    }

    public MockConfig charSeed(char ... charSeed) {
        this.GLOBAL_DATA_CONFIG.charSeed(charSeed);
        return this;
    }

    @Deprecated
    public MockConfig numberXeger(String numberRegex) {
        this.GLOBAL_DATA_CONFIG.numberXeger(numberRegex);
        return this;
    }

    public MockConfig numberRegex(String numberRegex) {
        this.GLOBAL_DATA_CONFIG.numberRegex(numberRegex);
        return this;
    }

    @Deprecated
    public MockConfig stringXeger(String stringRegex) {
        this.GLOBAL_DATA_CONFIG.stringXeger(stringRegex);
        return this;
    }

    public MockConfig stringRegex(String stringRegex) {
        this.GLOBAL_DATA_CONFIG.stringRegex(stringRegex);
        return this;
    }

    public byte[] byteRange() {
        return this.GLOBAL_DATA_CONFIG.byteRange();
    }

    public boolean[] booleanSeed() {
        return this.GLOBAL_DATA_CONFIG.booleanSeed();
    }

    public short[] shortRange() {
        return this.GLOBAL_DATA_CONFIG.shortRange();
    }

    public int[] intRange() {
        return this.GLOBAL_DATA_CONFIG.intRange();
    }

    public float[] floatRange() {
        return this.GLOBAL_DATA_CONFIG.floatRange();
    }

    public double[] doubleRange() {
        return this.GLOBAL_DATA_CONFIG.doubleRange();
    }

    public int decimalScale() {
        return this.GLOBAL_DATA_CONFIG.decimalScale();
    }

    public long[] longRange() {
        return this.GLOBAL_DATA_CONFIG.longRange();
    }

    public String[] dateRange() {
        return this.GLOBAL_DATA_CONFIG.dateRange();
    }

    public int[] timeRange() {
        return this.GLOBAL_DATA_CONFIG.timeRange();
    }

    public int[] sizeRange() {
        return this.GLOBAL_DATA_CONFIG.sizeRange();
    }

    public String[] stringSeed() {
        return this.GLOBAL_DATA_CONFIG.stringSeed();
    }

    public char[] charSeed() {
        return this.GLOBAL_DATA_CONFIG.charSeed();
    }

    public String numberRegex() {
        return this.GLOBAL_DATA_CONFIG.numberRegex();
    }

    public String stringRegex() {
        return this.GLOBAL_DATA_CONFIG.stringRegex();
    }
}

