/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonzou.jmockdata.util.randomstring;

import com.github.jsonzou.jmockdata.util.randomstring.DigitLetter;
import com.github.jsonzou.jmockdata.util.randomstring.LowerCaseLetter;
import com.github.jsonzou.jmockdata.util.randomstring.RandomLetterPicker;
import com.github.jsonzou.jmockdata.util.randomstring.SymbolLetter;
import com.github.jsonzou.jmockdata.util.randomstring.UpperCaseLetter;
import java.util.ArrayList;
import java.util.Random;

class RandomLetterPickers {
    private final RandomLetterPicker upperCase;
    private final RandomLetterPicker lowerCase;
    private final RandomLetterPicker digit;
    private final RandomLetterPicker symbol;
    private final RandomLetterPicker any;
    private final RandomLetterPicker salt;
    private final RandomLetterPicker binary;
    private final RandomLetterPicker word;
    private final RandomLetterPicker notWord;
    private final RandomLetterPicker notDigit;
    private final RandomLetterPicker space;

    public RandomLetterPickers(Random random) {
        this.upperCase = RandomLetterPicker.builder().setRandom(random).addAllByEnum(UpperCaseLetter.class).build();
        this.lowerCase = RandomLetterPicker.builder().setRandom(random).addAllByEnum(LowerCaseLetter.class).build();
        this.digit = RandomLetterPicker.builder().setRandom(random).addAllByEnum(DigitLetter.class).build();
        this.symbol = RandomLetterPicker.builder().setRandom(random).addAllByEnum(SymbolLetter.class).build();
        this.any = RandomLetterPicker.builder().setRandom(random).addAllByEnum(UpperCaseLetter.class).addAllByEnum(LowerCaseLetter.class).addAllByEnum(DigitLetter.class).addAllByEnum(SymbolLetter.class).build();
        this.salt = RandomLetterPicker.builder().setRandom(random).addAllByEnum(UpperCaseLetter.class).addAllByEnum(LowerCaseLetter.class).addAllByEnum(DigitLetter.class).add(".").add("/").build();
        ArrayList<String> bynaryCharts = new ArrayList<String>(256);
        for (int i = 0; i < 255; i = (int)((short)(i + 1))) {
            bynaryCharts.add(Character.toString((char)i));
        }
        this.binary = RandomLetterPicker.builder().setRandom(random).addAll(bynaryCharts).build();
        this.word = RandomLetterPicker.builder().setRandom(random).addAllByEnum(UpperCaseLetter.class).addAllByEnum(LowerCaseLetter.class).addAllByEnum(DigitLetter.class).add("_").build();
        this.notWord = RandomLetterPicker.builder().setRandom(random).addAllByEnum(SymbolLetter.class).remove("_").build();
        this.notDigit = RandomLetterPicker.builder().setRandom(random).addAllByEnum(UpperCaseLetter.class).addAllByEnum(LowerCaseLetter.class).addAllByEnum(SymbolLetter.class).build();
        this.space = RandomLetterPicker.builder().setRandom(random).add(" ").add("\t").build();
    }

    public RandomLetterPicker getUpperCase() {
        return this.upperCase;
    }

    public RandomLetterPicker getLowerCase() {
        return this.lowerCase;
    }

    public RandomLetterPicker getDigit() {
        return this.digit;
    }

    public RandomLetterPicker getSymbol() {
        return this.symbol;
    }

    public RandomLetterPicker getAny() {
        return this.any;
    }

    public RandomLetterPicker getSalt() {
        return this.salt;
    }

    public RandomLetterPicker getBinary() {
        return this.binary;
    }

    public RandomLetterPicker getWord() {
        return this.word;
    }

    public RandomLetterPicker getNotWord() {
        return this.notWord;
    }

    public RandomLetterPicker getNotDigit() {
        return this.notDigit;
    }

    public RandomLetterPicker getSpace() {
        return this.space;
    }
}

