/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.flink.fake.source;

import com.google.auto.service.AutoService;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.types.Row;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.config.TypesafeConfigUtils;
import org.apache.seatunnel.flink.BaseFlinkSource;
import org.apache.seatunnel.flink.FlinkEnvironment;
import org.apache.seatunnel.flink.batch.FlinkBatchSource;
import org.apache.seatunnel.flink.fake.source.MockSchema;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

@AutoService(value={BaseFlinkSource.class})
public class FakeSource
implements FlinkBatchSource {
    private Config config;
    private List<MockSchema> mockDataSchema;
    private int mockDataSize;

    public void setConfig(Config config) {
        this.config = config;
    }

    public Config getConfig() {
        return this.config;
    }

    public void prepare(FlinkEnvironment env) {
        this.mockDataSchema = MockSchema.resolveConfig(this.config);
        this.mockDataSize = (Integer)TypesafeConfigUtils.getConfig((Config)this.config, (String)"mock_data_size", (Object)10);
    }

    public CheckResult checkConfig() {
        return CheckResult.success();
    }

    public String getPluginName() {
        return "FakeSource";
    }

    public DataSet<Row> getData(FlinkEnvironment env) {
        ArrayList<Row> dataSet = new ArrayList<Row>(this.mockDataSize);
        for (long index = 0L; index < (long)this.mockDataSize; ++index) {
            dataSet.add(MockSchema.mockRowData(this.mockDataSchema));
        }
        return env.getBatchEnvironment().fromCollection(dataSet, (TypeInformation)MockSchema.mockRowTypeInfo(this.mockDataSchema));
    }
}

