/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.flink.fake.source;

import com.google.auto.service.AutoService;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.functions.source.RichParallelSourceFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.types.Row;
import org.apache.seatunnel.common.config.TypesafeConfigUtils;
import org.apache.seatunnel.flink.BaseFlinkSource;
import org.apache.seatunnel.flink.FlinkEnvironment;
import org.apache.seatunnel.flink.fake.source.MockSchema;
import org.apache.seatunnel.flink.stream.FlinkStreamSource;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

@AutoService(value={BaseFlinkSource.class})
public class FakeSourceStream
extends RichParallelSourceFunction<Row>
implements FlinkStreamSource {
    private static final long serialVersionUID = -3026082767246767679L;
    private volatile boolean running = true;
    private static final String PARALLELISM = "parallelism";
    private Config config;
    private List<MockSchema> mockDataSchema;
    private long mockDataInterval;

    public DataStream<Row> getData(FlinkEnvironment env) {
        DataStreamSource source = env.getStreamExecutionEnvironment().addSource((SourceFunction)this);
        if (this.config.hasPath(PARALLELISM)) {
            source = source.setParallelism(this.config.getInt(PARALLELISM));
        }
        return source.returns((TypeInformation)MockSchema.mockRowTypeInfo(this.mockDataSchema));
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public Config getConfig() {
        return this.config;
    }

    public void prepare(FlinkEnvironment env) {
        this.mockDataSchema = MockSchema.resolveConfig(this.config);
        this.mockDataInterval = (Long)TypesafeConfigUtils.getConfig((Config)this.config, (String)"mock_data_interval", (Object)1L);
    }

    public String getPluginName() {
        return "FakeSourceStream";
    }

    public void run(SourceFunction.SourceContext<Row> ctx) throws Exception {
        while (this.running) {
            Row rowData = MockSchema.mockRowData(this.mockDataSchema);
            ctx.collect((Object)rowData);
            TimeUnit.SECONDS.sleep(this.mockDataInterval);
        }
    }

    public void cancel() {
        this.running = false;
    }
}

