/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.provider.redis;

import com.redislabs.provider.redis.RedisConfig$;
import com.redislabs.provider.redis.RedisEndpoint;
import com.redislabs.provider.redis.RedisEndpoint$;
import com.redislabs.provider.redis.RedisNode;
import java.util.List;
import org.apache.spark.SparkConf;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.util.JedisClusterCRC16;
import redis.clients.jedis.util.SafeEncoder;
import scala.Array$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ms!B\u0001\u0003\u0011\u0003Y\u0011a\u0003*fI&\u001c8i\u001c8gS\u001eT!a\u0001\u0003\u0002\u000bI,G-[:\u000b\u0005\u00151\u0011\u0001\u00039s_ZLG-\u001a:\u000b\u0005\u001dA\u0011!\u0003:fI&\u001cH.\u00192t\u0015\u0005I\u0011aA2p[\u000e\u0001\u0001C\u0001\u0007\u000e\u001b\u0005\u0011a!\u0002\b\u0003\u0011\u0003y!a\u0003*fI&\u001c8i\u001c8gS\u001e\u001c2!\u0004\t\u0017!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011\u0011cF\u0005\u00031I\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQAG\u0007\u0005\u0002m\ta\u0001P5oSRtD#A\u0006\t\u000buiA\u0011\u0001\u0010\u0002\u001b\u0019\u0014x.\\*qCJ\\7i\u001c8g)\ry\u0012Q\u0005\t\u0003\u0019\u00012AA\u0004\u0002\u0001CM\u0019\u0001\u0005\u0005\f\t\u0011\r\u0002#Q1A\u0005\u0002\u0011\n1\"\u001b8ji&\fG\u000eS8tiV\tQ\u0005\u0005\u0002\rM%\u0011qE\u0001\u0002\u000e%\u0016$\u0017n]#oIB|\u0017N\u001c;\t\u0011%\u0002#\u0011!Q\u0001\n\u0015\nA\"\u001b8ji&\fG\u000eS8ti\u0002BQA\u0007\u0011\u0005\u0002-\"\"a\b\u0017\t\u000b\rR\u0003\u0019A\u0013\t\u000f9\u0002#\u0019!C\u0001_\u0005Y\u0011N\\5uS\u0006d\u0017\t\u001a3s+\u0005\u0001\u0004CA\u00195\u001d\t\t\"'\u0003\u00024%\u00051\u0001K]3eK\u001aL!!\u000e\u001c\u0003\rM#(/\u001b8h\u0015\t\u0019$\u0003\u0003\u00049A\u0001\u0006I\u0001M\u0001\rS:LG/[1m\u0003\u0012$'\u000f\t\u0005\bu\u0001\u0012\r\u0011\"\u0001<\u0003\u0015Awn\u001d;t+\u0005a\u0004cA\t>\u007f%\u0011aH\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u0019\u0001K!!\u0011\u0002\u0003\u0013I+G-[:O_\u0012,\u0007BB\"!A\u0003%A(\u0001\u0004i_N$8\u000f\t\u0005\b\u000b\u0002\u0012\r\u0011\"\u0001<\u0003\u0015qw\u000eZ3t\u0011\u00199\u0005\u0005)A\u0005y\u00051an\u001c3fg\u0002BQ!\u0013\u0011\u0005\u0002=\nqaZ3u\u0003V$\b\u000eC\u0003LA\u0011\u0005A*A\u0003hKR$%)F\u0001N!\t\tb*\u0003\u0002P%\t\u0019\u0011J\u001c;\t\u000bE\u0003C\u0011\u0001*\u0002\u001b\u001d,GOU1oI>lgj\u001c3f)\u0005y\u0004\"\u0002+!\t\u0003)\u0016aD4fi:{G-Z:CsNcw\u000e^:\u0015\u0007q2\u0006\fC\u0003X'\u0002\u0007Q*\u0001\u0003t!>\u001c\b\"B-T\u0001\u0004i\u0015\u0001B3Q_NDQa\u0017\u0011\u0005\u0002q\u000b\u0001cY8o]\u0016\u001cG/[8o\r>\u00148*Z=\u0015\u0005u3\u0007C\u00010e\u001b\u0005y&B\u00011b\u0003\u0015QW\rZ5t\u0015\t\u00117-A\u0004dY&,g\u000e^:\u000b\u0003\rI!!Z0\u0003\u000b)+G-[:\t\u000b\u001dT\u0006\u0019\u0001\u0019\u0002\u0007-,\u0017\u0010C\u0003\\A\u0011\u0005\u0011\u000e\u0006\u0002^U\")q\r\u001ba\u0001WB\u0019\u0011#\u00107\u0011\u0005Ei\u0017B\u00018\u0013\u0005\u0011\u0011\u0015\u0010^3\t\u000bA\u0004C\u0011B9\u0002\u001d\rdWo\u001d;fe\u0016s\u0017M\u00197fIR\u0011!/\u001e\t\u0003#ML!\u0001\u001e\n\u0003\u000f\t{w\u000e\\3b]\")1e\u001ca\u0001K!)q\u000f\tC\u0001q\u00069q-\u001a;I_N$HCA z\u0011\u00159g\u000f1\u00011\u0011\u00159\b\u0005\"\u0001|)\tyD\u0010C\u0003hu\u0002\u00071\u000eC\u0003\u007fA\u0011%q0A\u0007hKRDun\u001d;CsNcw\u000e\u001e\u000b\u0004\u007f\u0005\u0005\u0001BBA\u0002{\u0002\u0007Q*\u0001\u0003tY>$\bbBA\u0004A\u0011%\u0011\u0011B\u0001\tO\u0016$\bj\\:ugR\u0019A(a\u0003\t\r\r\n)\u00011\u0001&\u0011\u001d\ty\u0001\tC\u0005\u0003#\t!cZ3u\u001d>t7\t\\;ti\u0016\u0014hj\u001c3fgR\u0019A(a\u0005\t\r\r\ni\u00011\u0001&\u0011\u001d\t9\u0002\tC\u0005\u00033\tqbZ3u\u00072,8\u000f^3s\u001d>$Wm\u001d\u000b\u0004y\u0005m\u0001BB\u0012\u0002\u0016\u0001\u0007Q\u0005C\u0004\u0002 \u0001\"\t!!\t\u0002\u0011\u001d,GOT8eKN$2\u0001PA\u0012\u0011\u0019\u0019\u0013Q\u0004a\u0001K!9\u0011q\u0005\u000fA\u0002\u0005%\u0012\u0001B2p]\u001a\u0004B!a\u000b\u0002:5\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t$A\u0003ta\u0006\u00148N\u0003\u0003\u00024\u0005U\u0012AB1qC\u000eDWM\u0003\u0002\u00028\u0005\u0019qN]4\n\t\u0005m\u0012Q\u0006\u0002\n'B\f'o[\"p]\u001aD\u0011\"a\u0010\u000e\u0003\u0003%I!!\u0011\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u0007\u0002B!!\u0012\u0002P5\u0011\u0011q\t\u0006\u0005\u0003\u0013\nY%\u0001\u0003mC:<'BAA'\u0003\u0011Q\u0017M^1\n\t\u0005E\u0013q\t\u0002\u0007\u001f\nTWm\u0019;")
public class RedisConfig
implements Serializable {
    private final RedisEndpoint initialHost;
    private final String initialAddr;
    private final RedisNode[] hosts;
    private final RedisNode[] nodes;

    public static RedisConfig fromSparkConf(SparkConf sparkConf) {
        return RedisConfig$.MODULE$.fromSparkConf(sparkConf);
    }

    public RedisEndpoint initialHost() {
        return this.initialHost;
    }

    public String initialAddr() {
        return this.initialAddr;
    }

    public RedisNode[] hosts() {
        return this.hosts;
    }

    public RedisNode[] nodes() {
        return this.nodes;
    }

    public String getAuth() {
        return this.initialHost().auth();
    }

    public int getDB() {
        return this.initialHost().dbNum();
    }

    public RedisNode getRandomNode() {
        int rnd = RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(Random$.MODULE$.nextInt())) % this.hosts().length;
        return this.hosts()[rnd];
    }

    public RedisNode[] getNodesBySlots(int sPos, int ePos) {
        return (RedisNode[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.nodes()).filter(new Serializable(this, sPos, ePos){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RedisConfig $outer;
            private final int sPos$1;
            private final int ePos$1;

            public final boolean apply(RedisNode node) {
                return this.$outer.com$redislabs$provider$redis$RedisConfig$$inter$1(this.sPos$1, this.ePos$1, node.startSlot(), node.endSlot());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sPos$1 = sPos$1;
                this.ePos$1 = ePos$1;
            }
        })).filter(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(RedisNode x$1) {
                return x$1.idx() == 0;
            }
        });
    }

    public Jedis connectionForKey(String key) {
        return this.getHost(key).connect();
    }

    public Jedis connectionForKey(byte[] key) {
        return this.getHost(key).connect();
    }

    private boolean clusterEnabled(RedisEndpoint initialHost) {
        Jedis conn = initialHost.connect();
        String[] info2 = conn.info().split("\n");
        String version = ((String[])Predef$.MODULE$.refArrayOps((Object[])info2).filter(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return x$2.contains("redis_version:");
            }
        }))[0];
        String[] clusterEnable = (String[])Predef$.MODULE$.refArrayOps((Object[])info2).filter(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$3) {
                return x$3.contains("cluster_enabled:");
            }
        });
        int mainVersion = new StringOps(Predef$.MODULE$.augmentString(version.substring(14, version.indexOf(".")))).toInt();
        boolean res = mainVersion > 2 && clusterEnable.length > 0 && clusterEnable[0].contains("1");
        conn.close();
        return res;
    }

    public RedisNode getHost(String key) {
        int slot = JedisClusterCRC16.getSlot(key);
        return this.getHostBySlot(slot);
    }

    public RedisNode getHost(byte[] key) {
        int slot = JedisClusterCRC16.getSlot(key);
        return this.getHostBySlot(slot);
    }

    private RedisNode getHostBySlot(int slot) {
        return ((RedisNode[])Predef$.MODULE$.refArrayOps((Object[])this.hosts()).filter(new Serializable(this, slot){
            public static final long serialVersionUID = 0L;
            private final int slot$1;

            public final boolean apply(RedisNode host) {
                return host.startSlot() <= this.slot$1 && host.endSlot() >= this.slot$1;
            }
            {
                this.slot$1 = slot$1;
            }
        }))[0];
    }

    private RedisNode[] getHosts(RedisEndpoint initialHost) {
        return (RedisNode[])Predef$.MODULE$.refArrayOps((Object[])this.getNodes(initialHost)).filter(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(RedisNode x$4) {
                return x$4.idx() == 0;
            }
        });
    }

    private RedisNode[] getNonClusterNodes(RedisEndpoint initialHost) {
        String[] replinfo;
        Tuple2<String, Integer> master;
        while (true) {
            master = new Tuple2<String, Integer>(initialHost.host(), BoxesRunTime.boxToInteger(initialHost.port()));
            Jedis conn = initialHost.connect();
            replinfo = conn.info("Replication").split("\n");
            conn.close();
            if (!Predef$.MODULE$.refArrayOps((Object[])replinfo).exists(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$5) {
                    return x$5.contains("role:slave");
                }
            })) break;
            String host = ((String[])Predef$.MODULE$.refArrayOps((Object[])replinfo).filter(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$6) {
                    return x$6.contains("master_host:");
                }
            }))[0].trim().substring(12);
            int port = new StringOps(Predef$.MODULE$.augmentString(((String[])Predef$.MODULE$.refArrayOps((Object[])replinfo).filter(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$7) {
                    return x$7.contains("master_port:");
                }
            }))[0].trim().substring(12))).toInt();
            String x$15 = host;
            int x$16 = port;
            String x$17 = initialHost.auth();
            int x$18 = initialHost.dbNum();
            boolean x$19 = initialHost.ssl();
            int x$20 = RedisEndpoint$.MODULE$.$lessinit$greater$default$5();
            initialHost = new RedisEndpoint(x$15, x$16, x$17, x$18, x$20, x$19);
        }
        Tuple2[] slaves = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])replinfo).filter(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x) {
                return x.contains("slave") && x.contains("online");
            }
        })).map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(String rl) {
                String[] content = rl.substring(rl.indexOf(58) + 1).split(",");
                String ip = content[0];
                String port = content[1];
                return new Tuple2<String, Object>(ip.substring(ip.indexOf(61) + 1), BoxesRunTime.boxToInteger(new StringOps(Predef$.MODULE$.augmentString(port.substring(port.indexOf(61) + 1))).toInt()));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        Tuple2<String, Integer> tuple2 = master;
        Tuple2[] nodes2 = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])slaves).$plus$colon(tuple2, ClassTag$.MODULE$.apply(Tuple2.class));
        int range2 = nodes2.length;
        return (RedisNode[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), range2).map(new Serializable(this, initialHost, nodes2, range2){
            public static final long serialVersionUID = 0L;
            private final RedisEndpoint initialHost$1;
            private final Tuple2[] nodes$1;
            private final int range$1;

            public final RedisNode apply(int i) {
                return new RedisNode(new RedisEndpoint((String)this.nodes$1[i]._1(), this.nodes$1[i]._2$mcI$sp(), this.initialHost$1.auth(), this.initialHost$1.dbNum(), this.initialHost$1.timeout(), this.initialHost$1.ssl()), 0, 16383, i, this.range$1);
            }
            {
                this.initialHost$1 = initialHost$1;
                this.nodes$1 = nodes$1;
                this.range$1 = range$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(RedisNode.class));
    }

    /*
     * WARNING - void declaration
     */
    private RedisNode[] getClusterNodes(RedisEndpoint initialHost) {
        void var3_3;
        Jedis conn = initialHost.connect();
        RedisNode[] res = (RedisNode[])((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(conn.clusterSlots()).flatMap(new Serializable(this, initialHost){
            public static final long serialVersionUID = 0L;
            public final RedisEndpoint initialHost$2;

            public final IndexedSeq<RedisNode> apply(Object slotInfoObj) {
                List slotInfo = (List)slotInfoObj;
                int sPos = new StringOps(Predef$.MODULE$.augmentString(slotInfo.get(0).toString())).toInt();
                int ePos = new StringOps(Predef$.MODULE$.augmentString(slotInfo.get(1).toString())).toInt();
                return RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), slotInfo.size() - 2).map(new Serializable(this, slotInfo, sPos, ePos){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;
                    private final List slotInfo$1;
                    private final int sPos$2;
                    private final int ePos$2;

                    public final RedisNode apply(int i) {
                        List node = (List)JavaConversions$.MODULE$.asScalaBuffer(this.slotInfo$1).apply(i + 2);
                        String host = SafeEncoder.encode((byte[])node.get(0));
                        int port = new StringOps(Predef$.MODULE$.augmentString(node.get(1).toString())).toInt();
                        return new RedisNode(new RedisEndpoint(host, port, this.$outer.initialHost$2.auth(), this.$outer.initialHost$2.dbNum(), this.$outer.initialHost$2.timeout(), this.$outer.initialHost$2.ssl()), this.sPos$2, this.ePos$2, i, this.slotInfo$1.size() - 2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.slotInfo$1 = slotInfo$1;
                        this.sPos$2 = sPos$2;
                        this.ePos$2 = ePos$2;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.initialHost$2 = initialHost$2;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(RedisNode.class));
        conn.close();
        return var3_3;
    }

    public RedisNode[] getNodes(RedisEndpoint initialHost) {
        return this.clusterEnabled(initialHost) ? this.getClusterNodes(initialHost) : this.getNonClusterNodes(initialHost);
    }

    public final boolean com$redislabs$provider$redis$RedisConfig$$inter$1(int sPos1, int ePos1, int sPos2, int ePos2) {
        return sPos1 <= sPos2 ? ePos1 >= sPos2 : ePos2 >= sPos1;
    }

    public RedisConfig(RedisEndpoint initialHost) {
        this.initialHost = initialHost;
        this.initialAddr = initialHost.host();
        this.hosts = this.getHosts(initialHost);
        this.nodes = this.getNodes(initialHost);
    }
}

