/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.proxy;

import java.lang.reflect.Method;
import org.apache.commons.pool2.UsageTracking;

class BaseProxyHandler<T> {
    private T pooledObject;
    private final UsageTracking<T> usageTracking;

    BaseProxyHandler(T pooledObject, UsageTracking<T> usageTracking) {
        this.pooledObject = pooledObject;
        this.usageTracking = usageTracking;
    }

    T getPooledObject() {
        return this.pooledObject;
    }

    T disableProxy() {
        T result2 = this.pooledObject;
        this.pooledObject = null;
        return result2;
    }

    void validateProxiedObject() {
        if (this.pooledObject == null) {
            throw new IllegalStateException("This object may no longer be used as it has been returned to the Object Pool.");
        }
    }

    Object doInvoke(Method method, Object[] args2) throws Throwable {
        this.validateProxiedObject();
        T object = this.getPooledObject();
        if (this.usageTracking != null) {
            this.usageTracking.use(object);
        }
        return method.invoke(object, args2);
    }
}

