/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

public class GeoCoordinate {
    private double longitude;
    private double latitude;

    public GeoCoordinate(double longitude, double latitude) {
        this.longitude = longitude;
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeoCoordinate)) {
            return false;
        }
        GeoCoordinate that = (GeoCoordinate)o;
        if (Double.compare(that.longitude, this.longitude) != 0) {
            return false;
        }
        return Double.compare(that.latitude, this.latitude) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.longitude);
        int result2 = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.latitude);
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        return result2;
    }

    public String toString() {
        return "(" + this.longitude + "," + this.latitude + ")";
    }
}

