/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.List;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClusterConnectionHandler;
import redis.clients.jedis.JedisClusterHostAndPortMap;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.exceptions.JedisNoReachableClusterNodeException;

public class JedisSlotBasedConnectionHandler
extends JedisClusterConnectionHandler {
    public JedisSlotBasedConnectionHandler(Set<HostAndPort> nodes2, GenericObjectPoolConfig poolConfig, int timeout) {
        this(nodes2, poolConfig, timeout, timeout);
    }

    public JedisSlotBasedConnectionHandler(Set<HostAndPort> nodes2, GenericObjectPoolConfig poolConfig, int connectionTimeout, int soTimeout) {
        super(nodes2, poolConfig, connectionTimeout, soTimeout, null);
    }

    public JedisSlotBasedConnectionHandler(Set<HostAndPort> nodes2, GenericObjectPoolConfig poolConfig, int connectionTimeout, int soTimeout, String password) {
        super(nodes2, poolConfig, connectionTimeout, soTimeout, password);
    }

    public JedisSlotBasedConnectionHandler(Set<HostAndPort> nodes2, GenericObjectPoolConfig poolConfig, int connectionTimeout, int soTimeout, String password, String clientName) {
        super(nodes2, poolConfig, connectionTimeout, soTimeout, password, clientName);
    }

    public JedisSlotBasedConnectionHandler(Set<HostAndPort> nodes2, GenericObjectPoolConfig poolConfig, int connectionTimeout, int soTimeout, String password, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, JedisClusterHostAndPortMap portMap) {
        super(nodes2, poolConfig, connectionTimeout, soTimeout, password, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier, portMap);
    }

    @Override
    public Jedis getConnection() {
        List<JedisPool> pools = this.cache.getShuffledNodesPool();
        for (JedisPool pool : pools) {
            Jedis jedis = null;
            try {
                jedis = pool.getResource();
                if (jedis == null) continue;
                String result2 = jedis.ping();
                if (result2.equalsIgnoreCase("pong")) {
                    return jedis;
                }
                jedis.close();
            }
            catch (JedisException ex) {
                if (jedis == null) continue;
                jedis.close();
            }
        }
        throw new JedisNoReachableClusterNodeException("No reachable node in cluster");
    }

    @Override
    public Jedis getConnectionFromSlot(int slot) {
        JedisPool connectionPool = this.cache.getSlotPool(slot);
        if (connectionPool != null) {
            return connectionPool.getResource();
        }
        this.renewSlotCache();
        connectionPool = this.cache.getSlotPool(slot);
        if (connectionPool != null) {
            return connectionPool.getResource();
        }
        return this.getConnection();
    }
}

