/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.util.SafeEncoder;

public class SortingParams {
    private List<byte[]> params = new ArrayList<byte[]>();

    public SortingParams by(String pattern) {
        return this.by(SafeEncoder.encode(pattern));
    }

    public SortingParams by(byte[] pattern) {
        this.params.add(Protocol.Keyword.BY.raw);
        this.params.add(pattern);
        return this;
    }

    public SortingParams nosort() {
        this.params.add(Protocol.Keyword.BY.raw);
        this.params.add(Protocol.Keyword.NOSORT.raw);
        return this;
    }

    public Collection<byte[]> getParams() {
        return Collections.unmodifiableCollection(this.params);
    }

    public SortingParams desc() {
        this.params.add(Protocol.Keyword.DESC.raw);
        return this;
    }

    public SortingParams asc() {
        this.params.add(Protocol.Keyword.ASC.raw);
        return this;
    }

    public SortingParams limit(int start2, int count2) {
        this.params.add(Protocol.Keyword.LIMIT.raw);
        this.params.add(Protocol.toByteArray(start2));
        this.params.add(Protocol.toByteArray(count2));
        return this;
    }

    public SortingParams alpha() {
        this.params.add(Protocol.Keyword.ALPHA.raw);
        return this;
    }

    public SortingParams get(String ... patterns2) {
        for (String pattern : patterns2) {
            this.params.add(Protocol.Keyword.GET.raw);
            this.params.add(SafeEncoder.encode(pattern));
        }
        return this;
    }

    public SortingParams get(byte[] ... patterns2) {
        for (byte[] pattern : patterns2) {
            this.params.add(Protocol.Keyword.GET.raw);
            this.params.add(pattern);
        }
        return this;
    }
}

