/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.util.SafeEncoder;

public abstract class Params {
    private Map<String, Object> params;

    public <T> T getParam(String name) {
        if (this.params == null) {
            return null;
        }
        return (T)this.params.get(name);
    }

    public byte[][] getByteParams() {
        if (this.params == null) {
            return new byte[0][];
        }
        ArrayList<byte[]> byteParams = new ArrayList<byte[]>();
        for (Map.Entry<String, Object> param2 : this.params.entrySet()) {
            byteParams.add(SafeEncoder.encode(param2.getKey()));
            Object value2 = param2.getValue();
            if (value2 == null) continue;
            if (value2 instanceof byte[]) {
                byteParams.add((byte[])value2);
                continue;
            }
            if (value2 instanceof Boolean) {
                byteParams.add(Protocol.toByteArray((Boolean)value2));
                continue;
            }
            if (value2 instanceof Integer) {
                byteParams.add(Protocol.toByteArray((Integer)value2));
                continue;
            }
            if (value2 instanceof Long) {
                byteParams.add(Protocol.toByteArray((Long)value2));
                continue;
            }
            if (value2 instanceof Double) {
                byteParams.add(Protocol.toByteArray((Double)value2));
                continue;
            }
            byteParams.add(SafeEncoder.encode(String.valueOf(value2)));
        }
        return (byte[][])byteParams.toArray((T[])new byte[byteParams.size()][]);
    }

    protected boolean contains(String name) {
        if (this.params == null) {
            return false;
        }
        return this.params.containsKey(name);
    }

    protected void addParam(String name, Object value2) {
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        }
        this.params.put(name, value2);
    }

    protected void addParam(String name) {
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        }
        this.params.put(name, null);
    }
}

