/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

public abstract class HeaderFooter
implements org.apache.poi.ss.usermodel.HeaderFooter {
    protected HeaderFooter() {
    }

    protected abstract String getRawText();

    private String[] splitParts() {
        String text2 = this.getRawText();
        String _left = "";
        String _center = "";
        String _right = "";
        block5: while (text2.length() > 1) {
            if (text2.charAt(0) != '&') {
                _center = text2;
                break;
            }
            int pos = text2.length();
            switch (text2.charAt(1)) {
                case 'L': {
                    if (text2.contains("&C")) {
                        pos = Math.min(pos, text2.indexOf("&C"));
                    }
                    if (text2.contains("&R")) {
                        pos = Math.min(pos, text2.indexOf("&R"));
                    }
                    _left = text2.substring(2, pos);
                    text2 = text2.substring(pos);
                    continue block5;
                }
                case 'C': {
                    if (text2.contains("&L")) {
                        pos = Math.min(pos, text2.indexOf("&L"));
                    }
                    if (text2.contains("&R")) {
                        pos = Math.min(pos, text2.indexOf("&R"));
                    }
                    _center = text2.substring(2, pos);
                    text2 = text2.substring(pos);
                    continue block5;
                }
                case 'R': {
                    if (text2.contains("&C")) {
                        pos = Math.min(pos, text2.indexOf("&C"));
                    }
                    if (text2.contains("&L")) {
                        pos = Math.min(pos, text2.indexOf("&L"));
                    }
                    _right = text2.substring(2, pos);
                    text2 = text2.substring(pos);
                    continue block5;
                }
            }
            _center = text2;
            break;
        }
        return new String[]{_left, _center, _right};
    }

    @Override
    public final String getLeft() {
        return this.splitParts()[0];
    }

    @Override
    public final void setLeft(String newLeft) {
        this.updatePart(0, newLeft);
    }

    @Override
    public final String getCenter() {
        return this.splitParts()[1];
    }

    @Override
    public final void setCenter(String newCenter) {
        this.updatePart(1, newCenter);
    }

    @Override
    public final String getRight() {
        return this.splitParts()[2];
    }

    @Override
    public final void setRight(String newRight) {
        this.updatePart(2, newRight);
    }

    private void updatePart(int partIndex, String newValue) {
        String[] parts = this.splitParts();
        parts[partIndex] = newValue == null ? "" : newValue;
        this.updateHeaderFooterText(parts);
    }

    private void updateHeaderFooterText(String[] parts) {
        String _left = parts[0];
        String _center = parts[1];
        String _right = parts[2];
        if (_center.length() < 1 && _left.length() < 1 && _right.length() < 1) {
            this.setHeaderFooterText("");
            return;
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append("&C");
        sb.append(_center);
        sb.append("&L");
        sb.append(_left);
        sb.append("&R");
        sb.append(_right);
        String text2 = sb.toString();
        this.setHeaderFooterText(text2);
    }

    protected abstract void setHeaderFooterText(String var1);

    public static String fontSize(short size2) {
        return "&" + size2;
    }

    public static String font(String font, String style) {
        return "&\"" + font + "," + style + "\"";
    }

    public static String page() {
        return MarkupTag.PAGE_FIELD.getRepresentation();
    }

    public static String numPages() {
        return MarkupTag.NUM_PAGES_FIELD.getRepresentation();
    }

    public static String date() {
        return MarkupTag.DATE_FIELD.getRepresentation();
    }

    public static String time() {
        return MarkupTag.TIME_FIELD.getRepresentation();
    }

    public static String file() {
        return MarkupTag.FILE_FIELD.getRepresentation();
    }

    public static String tab() {
        return MarkupTag.SHEET_NAME_FIELD.getRepresentation();
    }

    public static String startBold() {
        return MarkupTag.BOLD_FIELD.getRepresentation();
    }

    public static String endBold() {
        return MarkupTag.BOLD_FIELD.getRepresentation();
    }

    public static String startUnderline() {
        return MarkupTag.UNDERLINE_FIELD.getRepresentation();
    }

    public static String endUnderline() {
        return MarkupTag.UNDERLINE_FIELD.getRepresentation();
    }

    public static String startDoubleUnderline() {
        return MarkupTag.DOUBLE_UNDERLINE_FIELD.getRepresentation();
    }

    public static String endDoubleUnderline() {
        return MarkupTag.DOUBLE_UNDERLINE_FIELD.getRepresentation();
    }

    public static String stripFields(String pText) {
        if (pText == null || pText.length() == 0) {
            return pText;
        }
        String text2 = pText;
        for (MarkupTag mt : MarkupTag.values()) {
            int pos;
            String seq = mt.getRepresentation();
            while ((pos = text2.indexOf(seq)) >= 0) {
                text2 = text2.substring(0, pos) + text2.substring(pos + seq.length());
            }
        }
        text2 = text2.replaceAll("\\&\\d+", "");
        text2 = text2.replaceAll("\\&\".*?,.*?\"", "");
        return text2;
    }

    private static enum MarkupTag {
        SHEET_NAME_FIELD("&A", false),
        DATE_FIELD("&D", false),
        FILE_FIELD("&F", false),
        FULL_FILE_FIELD("&Z", false),
        PAGE_FIELD("&P", false),
        TIME_FIELD("&T", false),
        NUM_PAGES_FIELD("&N", false),
        PICTURE_FIELD("&G", false),
        BOLD_FIELD("&B", true),
        ITALIC_FIELD("&I", true),
        STRIKETHROUGH_FIELD("&S", true),
        SUBSCRIPT_FIELD("&Y", true),
        SUPERSCRIPT_FIELD("&X", true),
        UNDERLINE_FIELD("&U", true),
        DOUBLE_UNDERLINE_FIELD("&E", true);

        private final String _representation;
        private final boolean _occursInPairs;

        private MarkupTag(String sequence2, boolean occursInPairs) {
            this._representation = sequence2;
            this._occursInPairs = occursInPairs;
        }

        public String getRepresentation() {
            return this._representation;
        }

        public boolean occursPairs() {
            return this._occursInPairs;
        }
    }
}

