/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ooxml.extractor;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import org.apache.poi.ooxml.POIXMLDocument;
import org.apache.poi.ooxml.extractor.POIXMLTextExtractor;
import org.apache.poi.openxml4j.opc.internal.PackagePropertiesPart;
import org.apache.poi.util.LocaleUtil;
import org.openxmlformats.schemas.officeDocument.x2006.customProperties.CTProperties;
import org.openxmlformats.schemas.officeDocument.x2006.customProperties.CTProperty;

public class POIXMLPropertiesTextExtractor
extends POIXMLTextExtractor {
    private final DateFormat dateFormat;

    public POIXMLPropertiesTextExtractor(POIXMLDocument doc) {
        super(doc);
        DateFormatSymbols dfs = DateFormatSymbols.getInstance(Locale.ROOT);
        this.dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", dfs);
        this.dateFormat.setTimeZone(LocaleUtil.TIMEZONE_UTC);
    }

    public POIXMLPropertiesTextExtractor(POIXMLTextExtractor otherExtractor) {
        this(otherExtractor.getDocument());
    }

    private void appendIfPresent(StringBuilder text2, String thing, boolean value) {
        this.appendIfPresent(text2, thing, Boolean.toString(value));
    }

    private void appendIfPresent(StringBuilder text2, String thing, int value) {
        this.appendIfPresent(text2, thing, Integer.toString(value));
    }

    private void appendDateIfPresent(StringBuilder text2, String thing, Optional<Date> value) {
        if (!value.isPresent()) {
            return;
        }
        this.appendIfPresent(text2, thing, this.dateFormat.format(value.get()));
    }

    private void appendIfPresent(StringBuilder text2, String thing, Optional<String> value) {
        if (!value.isPresent()) {
            return;
        }
        this.appendIfPresent(text2, thing, value.get());
    }

    private void appendIfPresent(StringBuilder text2, String thing, String value) {
        if (value == null) {
            return;
        }
        text2.append(thing);
        text2.append(" = ");
        text2.append(value);
        text2.append('\n');
    }

    public String getCorePropertiesText() {
        POIXMLDocument document2 = this.getDocument();
        if (document2 == null) {
            return "";
        }
        StringBuilder text2 = new StringBuilder(64);
        PackagePropertiesPart props = document2.getProperties().getCoreProperties().getUnderlyingProperties();
        this.appendIfPresent(text2, "Category", props.getCategoryProperty());
        this.appendIfPresent(text2, "Category", props.getCategoryProperty());
        this.appendIfPresent(text2, "ContentStatus", props.getContentStatusProperty());
        this.appendIfPresent(text2, "ContentType", props.getContentTypeProperty());
        this.appendDateIfPresent(text2, "Created", props.getCreatedProperty());
        this.appendIfPresent(text2, "CreatedString", props.getCreatedPropertyString());
        this.appendIfPresent(text2, "Creator", props.getCreatorProperty());
        this.appendIfPresent(text2, "Description", props.getDescriptionProperty());
        this.appendIfPresent(text2, "Identifier", props.getIdentifierProperty());
        this.appendIfPresent(text2, "Keywords", props.getKeywordsProperty());
        this.appendIfPresent(text2, "Language", props.getLanguageProperty());
        this.appendIfPresent(text2, "LastModifiedBy", props.getLastModifiedByProperty());
        this.appendDateIfPresent(text2, "LastPrinted", props.getLastPrintedProperty());
        this.appendIfPresent(text2, "LastPrintedString", props.getLastPrintedPropertyString());
        this.appendDateIfPresent(text2, "Modified", props.getModifiedProperty());
        this.appendIfPresent(text2, "ModifiedString", props.getModifiedPropertyString());
        this.appendIfPresent(text2, "Revision", props.getRevisionProperty());
        this.appendIfPresent(text2, "Subject", props.getSubjectProperty());
        this.appendIfPresent(text2, "Title", props.getTitleProperty());
        this.appendIfPresent(text2, "Version", props.getVersionProperty());
        return text2.toString();
    }

    public String getExtendedPropertiesText() {
        POIXMLDocument document2 = this.getDocument();
        if (document2 == null) {
            return "";
        }
        StringBuilder text2 = new StringBuilder(64);
        org.openxmlformats.schemas.officeDocument.x2006.extendedProperties.CTProperties props = document2.getProperties().getExtendedProperties().getUnderlyingProperties();
        this.appendIfPresent(text2, "Application", props.getApplication());
        this.appendIfPresent(text2, "AppVersion", props.getAppVersion());
        this.appendIfPresent(text2, "Characters", props.getCharacters());
        this.appendIfPresent(text2, "CharactersWithSpaces", props.getCharactersWithSpaces());
        this.appendIfPresent(text2, "Company", props.getCompany());
        this.appendIfPresent(text2, "HyperlinkBase", props.getHyperlinkBase());
        this.appendIfPresent(text2, "HyperlinksChanged", props.getHyperlinksChanged());
        this.appendIfPresent(text2, "Lines", props.getLines());
        this.appendIfPresent(text2, "LinksUpToDate", props.getLinksUpToDate());
        this.appendIfPresent(text2, "Manager", props.getManager());
        this.appendIfPresent(text2, "Pages", props.getPages());
        this.appendIfPresent(text2, "Paragraphs", props.getParagraphs());
        this.appendIfPresent(text2, "PresentationFormat", props.getPresentationFormat());
        this.appendIfPresent(text2, "Template", props.getTemplate());
        this.appendIfPresent(text2, "TotalTime", props.getTotalTime());
        return text2.toString();
    }

    public String getCustomPropertiesText() {
        POIXMLDocument document2 = this.getDocument();
        if (document2 == null) {
            return "";
        }
        StringBuilder text2 = new StringBuilder();
        CTProperties props = document2.getProperties().getCustomProperties().getUnderlyingProperties();
        for (CTProperty property : props.getPropertyList()) {
            String val = "(not implemented!)";
            if (property.isSetLpwstr()) {
                val = property.getLpwstr();
            } else if (property.isSetLpstr()) {
                val = property.getLpstr();
            } else if (property.isSetDate()) {
                val = property.getDate().toString();
            } else if (property.isSetFiletime()) {
                val = property.getFiletime().toString();
            } else if (property.isSetBool()) {
                val = Boolean.toString(property.getBool());
            } else if (property.isSetI1()) {
                val = Integer.toString(property.getI1());
            } else if (property.isSetI2()) {
                val = Integer.toString(property.getI2());
            } else if (property.isSetI4()) {
                val = Integer.toString(property.getI4());
            } else if (property.isSetI8()) {
                val = Long.toString(property.getI8());
            } else if (property.isSetInt()) {
                val = Integer.toString(property.getInt());
            } else if (property.isSetUi1()) {
                val = Integer.toString(property.getUi1());
            } else if (property.isSetUi2()) {
                val = Integer.toString(property.getUi2());
            } else if (property.isSetUi4()) {
                val = Long.toString(property.getUi4());
            } else if (property.isSetUi8()) {
                val = property.getUi8().toString();
            } else if (property.isSetUint()) {
                val = Long.toString(property.getUint());
            } else if (property.isSetR4()) {
                val = Float.toString(property.getR4());
            } else if (property.isSetR8()) {
                val = Double.toString(property.getR8());
            } else if (property.isSetDecimal()) {
                BigDecimal d = property.getDecimal();
                val = d == null ? null : d.toPlainString();
            }
            text2.append(property.getName()).append(" = ").append(val).append("\n");
        }
        return text2.toString();
    }

    @Override
    public String getText() {
        try {
            return this.getCorePropertiesText() + this.getExtendedPropertiesText() + this.getCustomPropertiesText();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public POIXMLPropertiesTextExtractor getMetadataTextExtractor() {
        throw new IllegalStateException("You already have the Metadata Text Extractor, not recursing!");
    }
}

