/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.formula.FormulaParser;
import org.apache.poi.ss.formula.FormulaParsingWorkbook;
import org.apache.poi.ss.formula.OperationEvaluationContext;
import org.apache.poi.ss.formula.eval.BlankEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.MissingArgEval;
import org.apache.poi.ss.formula.eval.OperandResolver;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.FreeRefFunction;
import org.apache.poi.ss.formula.ptg.Area3DPxg;
import org.apache.poi.ss.usermodel.Table;

public final class Indirect
implements FreeRefFunction {
    public static final FreeRefFunction instance = new Indirect();

    private Indirect() {
    }

    @Override
    public ValueEval evaluate(ValueEval[] args, OperationEvaluationContext ec) {
        boolean isA1style;
        String text2;
        if (args.length < 1) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            ValueEval ve = OperandResolver.getSingleValue(args[0], ec.getRowIndex(), ec.getColumnIndex());
            text2 = OperandResolver.coerceValueToString(ve);
            switch (args.length) {
                case 1: {
                    isA1style = true;
                    break;
                }
                case 2: {
                    isA1style = Indirect.evaluateBooleanArg(args[1], ec);
                    break;
                }
                default: {
                    return ErrorEval.VALUE_INVALID;
                }
            }
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        return Indirect.evaluateIndirect(ec, text2, isA1style);
    }

    private static boolean evaluateBooleanArg(ValueEval arg, OperationEvaluationContext ec) throws EvaluationException {
        ValueEval ve = OperandResolver.getSingleValue(arg, ec.getRowIndex(), ec.getColumnIndex());
        if (ve == BlankEval.instance || ve == MissingArgEval.instance) {
            return false;
        }
        return OperandResolver.coerceValueToBoolean(ve, false);
    }

    private static ValueEval evaluateIndirect(OperationEvaluationContext ec, String text2, boolean isA1style) {
        String refStrPart2;
        String refStrPart1;
        String refText;
        String sheetName2;
        String workbookName;
        int plingPos = text2.lastIndexOf(33);
        if (plingPos < 0) {
            workbookName = null;
            sheetName2 = null;
            refText = text2;
        } else {
            String[] parts = Indirect.parseWorkbookAndSheetName(text2.subSequence(0, plingPos));
            if (parts == null) {
                return ErrorEval.REF_INVALID;
            }
            workbookName = parts[0];
            sheetName2 = parts[1];
            refText = text2.substring(plingPos + 1);
        }
        if (Table.isStructuredReference.matcher(refText).matches()) {
            Area3DPxg areaPtg = null;
            try {
                areaPtg = FormulaParser.parseStructuredReference(refText, (FormulaParsingWorkbook)((Object)ec.getWorkbook()), ec.getRowIndex());
            }
            catch (FormulaParseException e) {
                return ErrorEval.REF_INVALID;
            }
            return ec.getArea3DEval(areaPtg);
        }
        int colonPos = refText.indexOf(58);
        if (colonPos < 0) {
            refStrPart1 = refText.trim();
            refStrPart2 = null;
        } else {
            refStrPart1 = refText.substring(0, colonPos).trim();
            refStrPart2 = refText.substring(colonPos + 1).trim();
        }
        return ec.getDynamicReference(workbookName, sheetName2, refStrPart1, refStrPart2, isA1style);
    }

    private static String[] parseWorkbookAndSheetName(CharSequence text2) {
        int lastIx = text2.length() - 1;
        if (lastIx < 0) {
            return null;
        }
        if (Indirect.canTrim(text2)) {
            return null;
        }
        char firstChar = text2.charAt(0);
        if (Character.isWhitespace(firstChar)) {
            return null;
        }
        if (firstChar == '\'') {
            int sheetStartPos;
            String wbName;
            if (text2.charAt(lastIx) != '\'') {
                return null;
            }
            firstChar = text2.charAt(1);
            if (Character.isWhitespace(firstChar)) {
                return null;
            }
            if (firstChar == '[') {
                int rbPos = text2.toString().lastIndexOf(93);
                if (rbPos < 0) {
                    return null;
                }
                wbName = Indirect.unescapeString(text2.subSequence(2, rbPos));
                if (wbName == null || Indirect.canTrim(wbName)) {
                    return null;
                }
                sheetStartPos = rbPos + 1;
            } else {
                wbName = null;
                sheetStartPos = 1;
            }
            String sheetName2 = Indirect.unescapeString(text2.subSequence(sheetStartPos, lastIx));
            if (sheetName2 == null) {
                return null;
            }
            return new String[]{wbName, sheetName2};
        }
        if (firstChar == '[') {
            int rbPos = text2.toString().lastIndexOf(93);
            if (rbPos < 0) {
                return null;
            }
            CharSequence wbName = text2.subSequence(1, rbPos);
            if (Indirect.canTrim(wbName)) {
                return null;
            }
            CharSequence sheetName3 = text2.subSequence(rbPos + 1, text2.length());
            if (Indirect.canTrim(sheetName3)) {
                return null;
            }
            return new String[]{wbName.toString(), sheetName3.toString()};
        }
        return new String[]{null, text2.toString()};
    }

    private static String unescapeString(CharSequence text2) {
        int len = text2.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char ch = text2.charAt(i);
            if (ch == '\'') {
                if (++i >= len) {
                    return null;
                }
                ch = text2.charAt(i);
                if (ch != '\'') {
                    return null;
                }
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private static boolean canTrim(CharSequence text2) {
        int lastIx = text2.length() - 1;
        if (lastIx < 0) {
            return false;
        }
        if (Character.isWhitespace(text2.charAt(0))) {
            return true;
        }
        return Character.isWhitespace(text2.charAt(lastIx));
    }
}

