/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.util.LocaleID;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public final class DateFormatConverter {
    private static POILogger logger = POILogFactory.getLogger(DateFormatConverter.class);
    private static Map<String, String> tokenConversions = DateFormatConverter.prepareTokenConversions();

    private DateFormatConverter() {
    }

    private static Map<String, String> prepareTokenConversions() {
        HashMap<String, String> result2 = new HashMap<String, String>();
        result2.put("EEEE", "dddd");
        result2.put("EEE", "ddd");
        result2.put("EE", "ddd");
        result2.put("E", "d");
        result2.put("Z", "");
        result2.put("z", "");
        result2.put("a", "am/pm");
        result2.put("A", "AM/PM");
        result2.put("K", "H");
        result2.put("KK", "HH");
        result2.put("k", "h");
        result2.put("kk", "hh");
        result2.put("S", "0");
        result2.put("SS", "00");
        result2.put("SSS", "000");
        return result2;
    }

    public static String getPrefixForLocale(Locale locale) {
        String languageTag = locale.toLanguageTag();
        if ("".equals(languageTag)) {
            return "[$-0409]";
        }
        LocaleID loc = LocaleID.lookupByLanguageTag(languageTag);
        if (loc == null) {
            String cmpTag = languageTag.indexOf(95) > -1 ? languageTag.replace('_', '-') : languageTag;
            int idx = languageTag.length();
            while (loc == null && (idx = cmpTag.lastIndexOf(45, idx - 1)) > 0) {
                loc = LocaleID.lookupByLanguageTag(languageTag.substring(0, idx));
            }
            if (loc == null) {
                logger.log(7, "Unable to find prefix for Locale '" + languageTag + "' or its parent locales.");
                return "";
            }
        }
        return String.format(Locale.ROOT, "[$-%04X]", loc.getLcid());
    }

    public static String convert(Locale locale, DateFormat df) {
        String ptrn = ((SimpleDateFormat)df).toPattern();
        return DateFormatConverter.convert(locale, ptrn);
    }

    public static String convert(Locale locale, String format2) {
        String token;
        StringBuilder result2 = new StringBuilder();
        result2.append(DateFormatConverter.getPrefixForLocale(locale));
        DateFormatTokenizer tokenizer = new DateFormatTokenizer(format2);
        while ((token = tokenizer.getNextToken()) != null) {
            if (token.startsWith("'")) {
                result2.append(token.replaceAll("'", "\""));
                continue;
            }
            if (!Character.isLetter(token.charAt(0))) {
                result2.append(token);
                continue;
            }
            String mappedToken = tokenConversions.get(token);
            result2.append(mappedToken == null ? token : mappedToken);
        }
        result2.append(";@");
        return result2.toString().trim();
    }

    public static String getJavaDatePattern(int style, Locale locale) {
        DateFormat df = DateFormat.getDateInstance(style, locale);
        if (df instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)df).toPattern();
        }
        switch (style) {
            case 3: {
                return "d/MM/yy";
            }
            case 1: {
                return "MMMM d, yyyy";
            }
            case 0: {
                return "dddd, MMMM d, yyyy";
            }
        }
        return "MMM d, yyyy";
    }

    public static String getJavaTimePattern(int style, Locale locale) {
        DateFormat df = DateFormat.getTimeInstance(style, locale);
        if (df instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)df).toPattern();
        }
        switch (style) {
            case 3: {
                return "h:mm a";
            }
        }
        return "h:mm:ss a";
    }

    public static String getJavaDateTimePattern(int style, Locale locale) {
        DateFormat df = DateFormat.getDateTimeInstance(style, style, locale);
        if (df instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)df).toPattern();
        }
        switch (style) {
            case 3: {
                return "M/d/yy h:mm a";
            }
            case 1: {
                return "MMMM d, yyyy h:mm:ss a";
            }
            case 0: {
                return "dddd, MMMM d, yyyy h:mm:ss a";
            }
        }
        return "MMM d, yyyy h:mm:ss a";
    }

    public static class DateFormatTokenizer {
        String format;
        int pos;

        public DateFormatTokenizer(String format2) {
            this.format = format2;
        }

        public String getNextToken() {
            if (this.pos >= this.format.length()) {
                return null;
            }
            int subStart = this.pos;
            char curChar = this.format.charAt(this.pos);
            ++this.pos;
            if (curChar == '\'') {
                while (this.pos < this.format.length() && this.format.charAt(this.pos) != '\'') {
                    ++this.pos;
                }
                if (this.pos < this.format.length()) {
                    ++this.pos;
                }
            } else {
                while (this.pos < this.format.length() && this.format.charAt(this.pos) == curChar) {
                    ++this.pos;
                }
            }
            return this.format.substring(subStart, this.pos);
        }

        public static String[] tokenize(String format2) {
            String token;
            ArrayList<String> result2 = new ArrayList<String>();
            DateFormatTokenizer tokenizer = new DateFormatTokenizer(format2);
            while ((token = tokenizer.getNextToken()) != null) {
                result2.add(token);
            }
            return result2.toArray(new String[0]);
        }

        public String toString() {
            String token;
            StringBuilder result2 = new StringBuilder();
            DateFormatTokenizer tokenizer = new DateFormatTokenizer(this.format);
            while ((token = tokenizer.getNextToken()) != null) {
                if (result2.length() > 0) {
                    result2.append(", ");
                }
                result2.append("[").append(token).append("]");
            }
            return result2.toString();
        }
    }
}

