/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.BorderExtent;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellUtil;

public final class PropertyTemplate {
    private Map<CellAddress, Map<String, Object>> _propertyTemplate = new HashMap<CellAddress, Map<String, Object>>();

    public PropertyTemplate() {
    }

    public PropertyTemplate(PropertyTemplate template) {
        this();
        for (Map.Entry<CellAddress, Map<String, Object>> entry : template.getTemplate().entrySet()) {
            this._propertyTemplate.put(new CellAddress(entry.getKey()), PropertyTemplate.cloneCellProperties(entry.getValue()));
        }
    }

    private Map<CellAddress, Map<String, Object>> getTemplate() {
        return this._propertyTemplate;
    }

    private static Map<String, Object> cloneCellProperties(Map<String, Object> properties) {
        HashMap<String, Object> newProperties = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            newProperties.put(entry.getKey(), entry.getValue());
        }
        return newProperties;
    }

    public void drawBorders(CellRangeAddress range2, BorderStyle borderType, BorderExtent extent) {
        switch (extent) {
            case NONE: {
                this.removeBorders(range2);
                break;
            }
            case ALL: {
                this.drawHorizontalBorders(range2, borderType, BorderExtent.ALL);
                this.drawVerticalBorders(range2, borderType, BorderExtent.ALL);
                break;
            }
            case INSIDE: {
                this.drawHorizontalBorders(range2, borderType, BorderExtent.INSIDE);
                this.drawVerticalBorders(range2, borderType, BorderExtent.INSIDE);
                break;
            }
            case OUTSIDE: {
                this.drawOutsideBorders(range2, borderType, BorderExtent.ALL);
                break;
            }
            case TOP: {
                this.drawTopBorder(range2, borderType);
                break;
            }
            case BOTTOM: {
                this.drawBottomBorder(range2, borderType);
                break;
            }
            case LEFT: {
                this.drawLeftBorder(range2, borderType);
                break;
            }
            case RIGHT: {
                this.drawRightBorder(range2, borderType);
                break;
            }
            case HORIZONTAL: {
                this.drawHorizontalBorders(range2, borderType, BorderExtent.ALL);
                break;
            }
            case INSIDE_HORIZONTAL: {
                this.drawHorizontalBorders(range2, borderType, BorderExtent.INSIDE);
                break;
            }
            case OUTSIDE_HORIZONTAL: {
                this.drawOutsideBorders(range2, borderType, BorderExtent.HORIZONTAL);
                break;
            }
            case VERTICAL: {
                this.drawVerticalBorders(range2, borderType, BorderExtent.ALL);
                break;
            }
            case INSIDE_VERTICAL: {
                this.drawVerticalBorders(range2, borderType, BorderExtent.INSIDE);
                break;
            }
            case OUTSIDE_VERTICAL: {
                this.drawOutsideBorders(range2, borderType, BorderExtent.VERTICAL);
            }
        }
    }

    public void drawBorders(CellRangeAddress range2, BorderStyle borderType, short color, BorderExtent extent) {
        this.drawBorders(range2, borderType, extent);
        if (borderType != BorderStyle.NONE) {
            this.drawBorderColors(range2, color, extent);
        }
    }

    private void drawTopBorder(CellRangeAddress range2, BorderStyle borderType) {
        int row = range2.getFirstRow();
        int firstCol = range2.getFirstColumn();
        int lastCol = range2.getLastColumn();
        for (int i = firstCol; i <= lastCol; ++i) {
            this.addProperty(row, i, "borderTop", (Object)borderType);
            if (borderType != BorderStyle.NONE || row <= 0) continue;
            this.addProperty(row - 1, i, "borderBottom", (Object)borderType);
        }
    }

    private void drawBottomBorder(CellRangeAddress range2, BorderStyle borderType) {
        int row = range2.getLastRow();
        int firstCol = range2.getFirstColumn();
        int lastCol = range2.getLastColumn();
        for (int i = firstCol; i <= lastCol; ++i) {
            this.addProperty(row, i, "borderBottom", (Object)borderType);
            if (borderType != BorderStyle.NONE || row >= SpreadsheetVersion.EXCEL2007.getMaxRows() - 1) continue;
            this.addProperty(row + 1, i, "borderTop", (Object)borderType);
        }
    }

    private void drawLeftBorder(CellRangeAddress range2, BorderStyle borderType) {
        int firstRow = range2.getFirstRow();
        int lastRow = range2.getLastRow();
        int col = range2.getFirstColumn();
        for (int i = firstRow; i <= lastRow; ++i) {
            this.addProperty(i, col, "borderLeft", (Object)borderType);
            if (borderType != BorderStyle.NONE || col <= 0) continue;
            this.addProperty(i, col - 1, "borderRight", (Object)borderType);
        }
    }

    private void drawRightBorder(CellRangeAddress range2, BorderStyle borderType) {
        int firstRow = range2.getFirstRow();
        int lastRow = range2.getLastRow();
        int col = range2.getLastColumn();
        for (int i = firstRow; i <= lastRow; ++i) {
            this.addProperty(i, col, "borderRight", (Object)borderType);
            if (borderType != BorderStyle.NONE || col >= SpreadsheetVersion.EXCEL2007.getMaxColumns() - 1) continue;
            this.addProperty(i, col + 1, "borderLeft", (Object)borderType);
        }
    }

    private void drawOutsideBorders(CellRangeAddress range2, BorderStyle borderType, BorderExtent extent) {
        switch (extent) {
            case ALL: 
            case HORIZONTAL: 
            case VERTICAL: {
                if (extent == BorderExtent.ALL || extent == BorderExtent.HORIZONTAL) {
                    this.drawTopBorder(range2, borderType);
                    this.drawBottomBorder(range2, borderType);
                }
                if (extent != BorderExtent.ALL && extent != BorderExtent.VERTICAL) break;
                this.drawLeftBorder(range2, borderType);
                this.drawRightBorder(range2, borderType);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported PropertyTemplate.Extent, valid Extents are ALL, HORIZONTAL, and VERTICAL");
            }
        }
    }

    private void drawHorizontalBorders(CellRangeAddress range2, BorderStyle borderType, BorderExtent extent) {
        switch (extent) {
            case ALL: 
            case INSIDE: {
                int firstRow = range2.getFirstRow();
                int lastRow = range2.getLastRow();
                int firstCol = range2.getFirstColumn();
                int lastCol = range2.getLastColumn();
                for (int i = firstRow; i <= lastRow; ++i) {
                    CellRangeAddress row = new CellRangeAddress(i, i, firstCol, lastCol);
                    if (extent == BorderExtent.ALL || i > firstRow) {
                        this.drawTopBorder(row, borderType);
                    }
                    if (extent != BorderExtent.ALL && i >= lastRow) continue;
                    this.drawBottomBorder(row, borderType);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported PropertyTemplate.Extent, valid Extents are ALL and INSIDE");
            }
        }
    }

    private void drawVerticalBorders(CellRangeAddress range2, BorderStyle borderType, BorderExtent extent) {
        switch (extent) {
            case ALL: 
            case INSIDE: {
                int firstRow = range2.getFirstRow();
                int lastRow = range2.getLastRow();
                int firstCol = range2.getFirstColumn();
                int lastCol = range2.getLastColumn();
                for (int i = firstCol; i <= lastCol; ++i) {
                    CellRangeAddress row = new CellRangeAddress(firstRow, lastRow, i, i);
                    if (extent == BorderExtent.ALL || i > firstCol) {
                        this.drawLeftBorder(row, borderType);
                    }
                    if (extent != BorderExtent.ALL && i >= lastCol) continue;
                    this.drawRightBorder(row, borderType);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported PropertyTemplate.Extent, valid Extents are ALL and INSIDE");
            }
        }
    }

    private void removeBorders(CellRangeAddress range2) {
        HashSet<String> properties = new HashSet<String>();
        properties.add("borderTop");
        properties.add("borderBottom");
        properties.add("borderLeft");
        properties.add("borderRight");
        for (int row = range2.getFirstRow(); row <= range2.getLastRow(); ++row) {
            for (int col = range2.getFirstColumn(); col <= range2.getLastColumn(); ++col) {
                this.removeProperties(row, col, properties);
            }
        }
        this.removeBorderColors(range2);
    }

    public void applyBorders(Sheet sheet) {
        Workbook wb = sheet.getWorkbook();
        for (Map.Entry<CellAddress, Map<String, Object>> entry : this._propertyTemplate.entrySet()) {
            CellAddress cellAddress = entry.getKey();
            if (cellAddress.getRow() >= wb.getSpreadsheetVersion().getMaxRows() || cellAddress.getColumn() >= wb.getSpreadsheetVersion().getMaxColumns()) continue;
            Map<String, Object> properties = entry.getValue();
            Row row = CellUtil.getRow(cellAddress.getRow(), sheet);
            Cell cell = CellUtil.getCell(row, cellAddress.getColumn());
            CellUtil.setCellStyleProperties(cell, properties);
        }
    }

    public void drawBorderColors(CellRangeAddress range2, short color, BorderExtent extent) {
        switch (extent) {
            case NONE: {
                this.removeBorderColors(range2);
                break;
            }
            case ALL: {
                this.drawHorizontalBorderColors(range2, color, BorderExtent.ALL);
                this.drawVerticalBorderColors(range2, color, BorderExtent.ALL);
                break;
            }
            case INSIDE: {
                this.drawHorizontalBorderColors(range2, color, BorderExtent.INSIDE);
                this.drawVerticalBorderColors(range2, color, BorderExtent.INSIDE);
                break;
            }
            case OUTSIDE: {
                this.drawOutsideBorderColors(range2, color, BorderExtent.ALL);
                break;
            }
            case TOP: {
                this.drawTopBorderColor(range2, color);
                break;
            }
            case BOTTOM: {
                this.drawBottomBorderColor(range2, color);
                break;
            }
            case LEFT: {
                this.drawLeftBorderColor(range2, color);
                break;
            }
            case RIGHT: {
                this.drawRightBorderColor(range2, color);
                break;
            }
            case HORIZONTAL: {
                this.drawHorizontalBorderColors(range2, color, BorderExtent.ALL);
                break;
            }
            case INSIDE_HORIZONTAL: {
                this.drawHorizontalBorderColors(range2, color, BorderExtent.INSIDE);
                break;
            }
            case OUTSIDE_HORIZONTAL: {
                this.drawOutsideBorderColors(range2, color, BorderExtent.HORIZONTAL);
                break;
            }
            case VERTICAL: {
                this.drawVerticalBorderColors(range2, color, BorderExtent.ALL);
                break;
            }
            case INSIDE_VERTICAL: {
                this.drawVerticalBorderColors(range2, color, BorderExtent.INSIDE);
                break;
            }
            case OUTSIDE_VERTICAL: {
                this.drawOutsideBorderColors(range2, color, BorderExtent.VERTICAL);
            }
        }
    }

    private void drawTopBorderColor(CellRangeAddress range2, short color) {
        int row = range2.getFirstRow();
        int firstCol = range2.getFirstColumn();
        int lastCol = range2.getLastColumn();
        for (int i = firstCol; i <= lastCol; ++i) {
            if (this.getBorderStyle(row, i, "borderTop") == BorderStyle.NONE) {
                this.drawTopBorder(new CellRangeAddress(row, row, i, i), BorderStyle.THIN);
            }
            this.addProperty(row, i, "topBorderColor", color);
        }
    }

    private void drawBottomBorderColor(CellRangeAddress range2, short color) {
        int row = range2.getLastRow();
        int firstCol = range2.getFirstColumn();
        int lastCol = range2.getLastColumn();
        for (int i = firstCol; i <= lastCol; ++i) {
            if (this.getBorderStyle(row, i, "borderBottom") == BorderStyle.NONE) {
                this.drawBottomBorder(new CellRangeAddress(row, row, i, i), BorderStyle.THIN);
            }
            this.addProperty(row, i, "bottomBorderColor", color);
        }
    }

    private void drawLeftBorderColor(CellRangeAddress range2, short color) {
        int firstRow = range2.getFirstRow();
        int lastRow = range2.getLastRow();
        int col = range2.getFirstColumn();
        for (int i = firstRow; i <= lastRow; ++i) {
            if (this.getBorderStyle(i, col, "borderLeft") == BorderStyle.NONE) {
                this.drawLeftBorder(new CellRangeAddress(i, i, col, col), BorderStyle.THIN);
            }
            this.addProperty(i, col, "leftBorderColor", color);
        }
    }

    private void drawRightBorderColor(CellRangeAddress range2, short color) {
        int firstRow = range2.getFirstRow();
        int lastRow = range2.getLastRow();
        int col = range2.getLastColumn();
        for (int i = firstRow; i <= lastRow; ++i) {
            if (this.getBorderStyle(i, col, "borderRight") == BorderStyle.NONE) {
                this.drawRightBorder(new CellRangeAddress(i, i, col, col), BorderStyle.THIN);
            }
            this.addProperty(i, col, "rightBorderColor", color);
        }
    }

    private void drawOutsideBorderColors(CellRangeAddress range2, short color, BorderExtent extent) {
        switch (extent) {
            case ALL: 
            case HORIZONTAL: 
            case VERTICAL: {
                if (extent == BorderExtent.ALL || extent == BorderExtent.HORIZONTAL) {
                    this.drawTopBorderColor(range2, color);
                    this.drawBottomBorderColor(range2, color);
                }
                if (extent != BorderExtent.ALL && extent != BorderExtent.VERTICAL) break;
                this.drawLeftBorderColor(range2, color);
                this.drawRightBorderColor(range2, color);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported PropertyTemplate.Extent, valid Extents are ALL, HORIZONTAL, and VERTICAL");
            }
        }
    }

    private void drawHorizontalBorderColors(CellRangeAddress range2, short color, BorderExtent extent) {
        switch (extent) {
            case ALL: 
            case INSIDE: {
                int firstRow = range2.getFirstRow();
                int lastRow = range2.getLastRow();
                int firstCol = range2.getFirstColumn();
                int lastCol = range2.getLastColumn();
                for (int i = firstRow; i <= lastRow; ++i) {
                    CellRangeAddress row = new CellRangeAddress(i, i, firstCol, lastCol);
                    if (extent == BorderExtent.ALL || i > firstRow) {
                        this.drawTopBorderColor(row, color);
                    }
                    if (extent != BorderExtent.ALL && i >= lastRow) continue;
                    this.drawBottomBorderColor(row, color);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported PropertyTemplate.Extent, valid Extents are ALL and INSIDE");
            }
        }
    }

    private void drawVerticalBorderColors(CellRangeAddress range2, short color, BorderExtent extent) {
        switch (extent) {
            case ALL: 
            case INSIDE: {
                int firstRow = range2.getFirstRow();
                int lastRow = range2.getLastRow();
                int firstCol = range2.getFirstColumn();
                int lastCol = range2.getLastColumn();
                for (int i = firstCol; i <= lastCol; ++i) {
                    CellRangeAddress row = new CellRangeAddress(firstRow, lastRow, i, i);
                    if (extent == BorderExtent.ALL || i > firstCol) {
                        this.drawLeftBorderColor(row, color);
                    }
                    if (extent != BorderExtent.ALL && i >= lastCol) continue;
                    this.drawRightBorderColor(row, color);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported PropertyTemplate.Extent, valid Extents are ALL and INSIDE");
            }
        }
    }

    private void removeBorderColors(CellRangeAddress range2) {
        HashSet<String> properties = new HashSet<String>();
        properties.add("topBorderColor");
        properties.add("bottomBorderColor");
        properties.add("leftBorderColor");
        properties.add("rightBorderColor");
        for (int row = range2.getFirstRow(); row <= range2.getLastRow(); ++row) {
            for (int col = range2.getFirstColumn(); col <= range2.getLastColumn(); ++col) {
                this.removeProperties(row, col, properties);
            }
        }
    }

    private void addProperty(int row, int col, String property, short value) {
        this.addProperty(row, col, property, (Object)value);
    }

    private void addProperty(int row, int col, String property, Object value) {
        CellAddress cell = new CellAddress(row, col);
        Map<String, Object> cellProperties = this._propertyTemplate.get(cell);
        if (cellProperties == null) {
            cellProperties = new HashMap<String, Object>();
        }
        cellProperties.put(property, value);
        this._propertyTemplate.put(cell, cellProperties);
    }

    private void removeProperties(int row, int col, Set<String> properties) {
        CellAddress cell = new CellAddress(row, col);
        Map<String, Object> cellProperties = this._propertyTemplate.get(cell);
        if (cellProperties != null) {
            cellProperties.keySet().removeAll(properties);
            if (cellProperties.isEmpty()) {
                this._propertyTemplate.remove(cell);
            } else {
                this._propertyTemplate.put(cell, cellProperties);
            }
        }
    }

    public int getNumBorders(CellAddress cell) {
        Map<String, Object> cellProperties = this._propertyTemplate.get(cell);
        if (cellProperties == null) {
            return 0;
        }
        int count2 = 0;
        for (String property : cellProperties.keySet()) {
            if (property.equals("borderTop")) {
                ++count2;
            }
            if (property.equals("borderBottom")) {
                ++count2;
            }
            if (property.equals("borderLeft")) {
                ++count2;
            }
            if (!property.equals("borderRight")) continue;
            ++count2;
        }
        return count2;
    }

    public int getNumBorders(int row, int col) {
        return this.getNumBorders(new CellAddress(row, col));
    }

    public int getNumBorderColors(CellAddress cell) {
        Map<String, Object> cellProperties = this._propertyTemplate.get(cell);
        if (cellProperties == null) {
            return 0;
        }
        int count2 = 0;
        for (String property : cellProperties.keySet()) {
            if (property.equals("topBorderColor")) {
                ++count2;
            }
            if (property.equals("bottomBorderColor")) {
                ++count2;
            }
            if (property.equals("leftBorderColor")) {
                ++count2;
            }
            if (!property.equals("rightBorderColor")) continue;
            ++count2;
        }
        return count2;
    }

    public int getNumBorderColors(int row, int col) {
        return this.getNumBorderColors(new CellAddress(row, col));
    }

    public BorderStyle getBorderStyle(CellAddress cell, String property) {
        Object obj;
        BorderStyle value = BorderStyle.NONE;
        Map<String, Object> cellProperties = this._propertyTemplate.get(cell);
        if (cellProperties != null && (obj = cellProperties.get(property)) instanceof BorderStyle) {
            value = (BorderStyle)((Object)obj);
        }
        return value;
    }

    public BorderStyle getBorderStyle(int row, int col, String property) {
        return this.getBorderStyle(new CellAddress(row, col), property);
    }

    public short getTemplateProperty(CellAddress cell, String property) {
        Object obj;
        short value = 0;
        Map<String, Object> cellProperties = this._propertyTemplate.get(cell);
        if (cellProperties != null && (obj = cellProperties.get(property)) != null) {
            value = PropertyTemplate.getShort(obj);
        }
        return value;
    }

    public short getTemplateProperty(int row, int col, String property) {
        return this.getTemplateProperty(new CellAddress(row, col), property);
    }

    private static short getShort(Object value) {
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        return 0;
    }
}

