/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.xssf.model.StylesTable;

public class XSSFDataFormat
implements DataFormat {
    private final StylesTable stylesSource;

    protected XSSFDataFormat(StylesTable stylesSource) {
        this.stylesSource = stylesSource;
    }

    @Override
    public short getFormat(String format2) {
        int idx = BuiltinFormats.getBuiltinFormat(format2);
        if (idx == -1) {
            idx = this.stylesSource.putNumberFormat(format2);
        }
        return (short)idx;
    }

    @Override
    public String getFormat(short index) {
        String fmt = this.stylesSource.getNumberFormatAt(index);
        if (fmt == null) {
            fmt = BuiltinFormats.getBuiltinFormat(index);
        }
        return fmt;
    }

    public void putFormat(short index, String format2) {
        this.stylesSource.putNumberFormat(index, format2);
    }
}

