/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.extractor;

import java.io.IOException;
import java.util.List;
import org.apache.poi.extractor.POITextExtractor;
import org.apache.poi.ooxml.POIXMLDocument;
import org.apache.poi.ooxml.extractor.POIXMLTextExtractor;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xwpf.model.XWPFCommentsDecorator;
import org.apache.poi.xwpf.model.XWPFHeaderFooterPolicy;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.ICell;
import org.apache.poi.xwpf.usermodel.IRunElement;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFHyperlink;
import org.apache.poi.xwpf.usermodel.XWPFHyperlinkRun;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFSDT;
import org.apache.poi.xwpf.usermodel.XWPFSDTCell;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;

public class XWPFWordExtractor
extends POIXMLTextExtractor {
    public static final XWPFRelation[] SUPPORTED_TYPES = new XWPFRelation[]{XWPFRelation.DOCUMENT, XWPFRelation.TEMPLATE, XWPFRelation.MACRO_DOCUMENT, XWPFRelation.MACRO_TEMPLATE_DOCUMENT};
    private XWPFDocument document;
    private boolean fetchHyperlinks;
    private boolean concatenatePhoneticRuns = true;

    public XWPFWordExtractor(OPCPackage container) throws XmlException, OpenXML4JException, IOException {
        this(new XWPFDocument(container));
    }

    public XWPFWordExtractor(XWPFDocument document2) {
        super(document2);
        this.document = document2;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Use:");
            System.err.println("  XWPFWordExtractor <filename.docx>");
            System.exit(1);
        }
        XWPFWordExtractor extractor = new XWPFWordExtractor(POIXMLDocument.openPackage(args[0]));
        System.out.println(((POITextExtractor)extractor).getText());
        extractor.close();
    }

    public void setFetchHyperlinks(boolean fetch) {
        this.fetchHyperlinks = fetch;
    }

    public void setConcatenatePhoneticRuns(boolean concatenatePhoneticRuns) {
        this.concatenatePhoneticRuns = concatenatePhoneticRuns;
    }

    @Override
    public String getText() {
        StringBuilder text2 = new StringBuilder(64);
        XWPFHeaderFooterPolicy hfPolicy = this.document.getHeaderFooterPolicy();
        this.extractHeaders(text2, hfPolicy);
        for (IBodyElement e : this.document.getBodyElements()) {
            this.appendBodyElementText(text2, e);
            text2.append('\n');
        }
        this.extractFooters(text2, hfPolicy);
        return text2.toString();
    }

    public void appendBodyElementText(StringBuilder text2, IBodyElement e) {
        if (e instanceof XWPFParagraph) {
            this.appendParagraphText(text2, (XWPFParagraph)e);
        } else if (e instanceof XWPFTable) {
            this.appendTableText(text2, (XWPFTable)e);
        } else if (e instanceof XWPFSDT) {
            text2.append(((XWPFSDT)e).getContent().getText());
        }
    }

    public void appendParagraphText(StringBuilder text2, XWPFParagraph paragraph) {
        String footnameText;
        CTSectPr ctSectPr = null;
        if (paragraph.getCTP().getPPr() != null) {
            ctSectPr = paragraph.getCTP().getPPr().getSectPr();
        }
        XWPFHeaderFooterPolicy headerFooterPolicy = null;
        if (ctSectPr != null) {
            headerFooterPolicy = new XWPFHeaderFooterPolicy(this.document, ctSectPr);
            this.extractHeaders(text2, headerFooterPolicy);
        }
        for (IRunElement iRunElement : paragraph.getRuns()) {
            XWPFHyperlink link;
            if (!this.concatenatePhoneticRuns && iRunElement instanceof XWPFRun) {
                text2.append(((XWPFRun)iRunElement).text());
            } else {
                text2.append(iRunElement);
            }
            if (!(iRunElement instanceof XWPFHyperlinkRun) || !this.fetchHyperlinks || (link = ((XWPFHyperlinkRun)iRunElement).getHyperlink(this.document)) == null) continue;
            text2.append(" <").append(link.getURL()).append(">");
        }
        XWPFCommentsDecorator decorator = new XWPFCommentsDecorator(paragraph, null);
        String string2 = decorator.getCommentText();
        if (string2.length() > 0) {
            text2.append(string2).append('\n');
        }
        if ((footnameText = paragraph.getFootnoteText()) != null && footnameText.length() > 0) {
            text2.append(footnameText).append('\n');
        }
        if (ctSectPr != null) {
            this.extractFooters(text2, headerFooterPolicy);
        }
    }

    private void appendTableText(StringBuilder text2, XWPFTable table) {
        for (XWPFTableRow row : table.getRows()) {
            List<ICell> cells = row.getTableICells();
            for (int i = 0; i < cells.size(); ++i) {
                ICell cell = cells.get(i);
                if (cell instanceof XWPFTableCell) {
                    text2.append(((XWPFTableCell)cell).getTextRecursively());
                } else if (cell instanceof XWPFSDTCell) {
                    text2.append(((XWPFSDTCell)cell).getContent().getText());
                }
                if (i >= cells.size() - 1) continue;
                text2.append("\t");
            }
            text2.append('\n');
        }
    }

    private void extractFooters(StringBuilder text2, XWPFHeaderFooterPolicy hfPolicy) {
        if (hfPolicy == null) {
            return;
        }
        if (hfPolicy.getFirstPageFooter() != null) {
            text2.append(hfPolicy.getFirstPageFooter().getText());
        }
        if (hfPolicy.getEvenPageFooter() != null) {
            text2.append(hfPolicy.getEvenPageFooter().getText());
        }
        if (hfPolicy.getDefaultFooter() != null) {
            text2.append(hfPolicy.getDefaultFooter().getText());
        }
    }

    private void extractHeaders(StringBuilder text2, XWPFHeaderFooterPolicy hfPolicy) {
        if (hfPolicy == null) {
            return;
        }
        if (hfPolicy.getFirstPageHeader() != null) {
            text2.append(hfPolicy.getFirstPageHeader().getText());
        }
        if (hfPolicy.getEvenPageHeader() != null) {
            text2.append(hfPolicy.getEvenPageHeader().getText());
        }
        if (hfPolicy.getDefaultHeader() != null) {
            text2.append(hfPolicy.getDefaultHeader().getText());
        }
    }
}

