/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.BucketAutoOptions;
import com.mongodb.client.model.BucketOptions;
import com.mongodb.client.model.BuildersHelper;
import com.mongodb.client.model.Facet;
import com.mongodb.client.model.Field;
import com.mongodb.client.model.GraphLookupOptions;
import com.mongodb.client.model.UnwindOptions;
import java.util.Arrays;
import java.util.List;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.assertions.Assertions;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class Aggregates {
    public static Bson addFields(Field<?> ... fields) {
        return Aggregates.addFields(Arrays.asList(fields));
    }

    public static Bson addFields(List<Field<?>> fields) {
        return new AddFieldsStage(fields);
    }

    public static <TExpression, Boundary> Bson bucket(TExpression groupBy2, List<Boundary> boundaries) {
        return Aggregates.bucket(groupBy2, boundaries, new BucketOptions());
    }

    public static <TExpression, TBoundary> Bson bucket(TExpression groupBy2, List<TBoundary> boundaries, BucketOptions options) {
        return new BucketStage<TExpression, TBoundary>(groupBy2, boundaries, options);
    }

    public static <TExpression> Bson bucketAuto(TExpression groupBy2, int buckets) {
        return Aggregates.bucketAuto(groupBy2, buckets, new BucketAutoOptions());
    }

    public static <TExpression> Bson bucketAuto(TExpression groupBy2, int buckets, BucketAutoOptions options) {
        return new BucketAutoStage<TExpression>(groupBy2, buckets, options);
    }

    public static Bson count() {
        return Aggregates.count("count");
    }

    public static Bson count(String field2) {
        return new BsonDocument("$count", new BsonString(field2));
    }

    public static Bson match(Bson filter2) {
        return new SimplePipelineStage("$match", filter2);
    }

    public static Bson project(Bson projection) {
        return new SimplePipelineStage("$project", projection);
    }

    public static Bson sort(Bson sort) {
        return new SimplePipelineStage("$sort", sort);
    }

    public static <TExpression> Bson sortByCount(TExpression filter2) {
        return new SortByCountStage<TExpression>(filter2);
    }

    public static Bson skip(int skip) {
        return new BsonDocument("$skip", new BsonInt32(skip));
    }

    public static Bson limit(int limit) {
        return new BsonDocument("$limit", new BsonInt32(limit));
    }

    public static Bson lookup(String from2, String localField, String foreignField, String as) {
        return new BsonDocument("$lookup", new BsonDocument("from", new BsonString(from2)).append("localField", new BsonString(localField)).append("foreignField", new BsonString(foreignField)).append("as", new BsonString(as)));
    }

    public static Bson facet(List<Facet> facets) {
        return new FacetStage(facets);
    }

    public static Bson facet(Facet ... facets) {
        return new FacetStage(Arrays.asList(facets));
    }

    public static <TExpression> Bson graphLookup(String from2, TExpression startWith, String connectFromField, String connectToField, String as) {
        return Aggregates.graphLookup(from2, startWith, connectFromField, connectToField, as, new GraphLookupOptions());
    }

    public static <TExpression> Bson graphLookup(String from2, TExpression startWith, String connectFromField, String connectToField, String as, GraphLookupOptions options) {
        Assertions.notNull("options", options);
        return new GraphLookupStage(from2, startWith, connectFromField, connectToField, as, options);
    }

    public static <TExpression> Bson group(TExpression id, BsonField ... fieldAccumulators) {
        return Aggregates.group(id, Arrays.asList(fieldAccumulators));
    }

    public static <TExpression> Bson group(TExpression id, List<BsonField> fieldAccumulators) {
        return new GroupStage<TExpression>(id, fieldAccumulators);
    }

    public static Bson unwind(String fieldName) {
        return new BsonDocument("$unwind", new BsonString(fieldName));
    }

    public static Bson unwind(String fieldName, UnwindOptions unwindOptions) {
        Assertions.notNull("unwindOptions", unwindOptions);
        BsonDocument options = new BsonDocument("path", new BsonString(fieldName));
        if (unwindOptions.isPreserveNullAndEmptyArrays() != null) {
            options.append("preserveNullAndEmptyArrays", BsonBoolean.valueOf(unwindOptions.isPreserveNullAndEmptyArrays()));
        }
        if (unwindOptions.getIncludeArrayIndex() != null) {
            options.append("includeArrayIndex", new BsonString(unwindOptions.getIncludeArrayIndex()));
        }
        return new BsonDocument("$unwind", options);
    }

    public static Bson out(String collectionName) {
        return new BsonDocument("$out", new BsonString(collectionName));
    }

    public static <TExpression> Bson replaceRoot(TExpression value) {
        return new ReplaceRootStage<TExpression>(value);
    }

    public static Bson sample(int size2) {
        return new BsonDocument("$sample", new BsonDocument("size", new BsonInt32(size2)));
    }

    static void writeBucketOutput(CodecRegistry codecRegistry2, BsonDocumentWriter writer, List<BsonField> output) {
        if (output != null) {
            writer.writeName("output");
            writer.writeStartDocument();
            for (BsonField field2 : output) {
                writer.writeName(field2.getName());
                BuildersHelper.encodeValue(writer, field2.getValue(), codecRegistry2);
            }
            writer.writeEndDocument();
        }
    }

    private Aggregates() {
    }

    private static class ReplaceRootStage<TExpression>
    implements Bson {
        private final TExpression value;

        ReplaceRootStage(TExpression value) {
            this.value = value;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry2) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeName("$replaceRoot");
            writer.writeStartDocument();
            writer.writeName("newRoot");
            BuildersHelper.encodeValue(writer, this.value, codecRegistry2);
            writer.writeEndDocument();
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public String toString() {
            return "Stage{name='$replaceRoot', value=" + this.value + '}';
        }
    }

    private static class AddFieldsStage
    implements Bson {
        private final List<Field<?>> fields;

        AddFieldsStage(List<Field<?>> fields) {
            this.fields = fields;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry2) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeName("$addFields");
            writer.writeStartDocument();
            for (Field<?> field2 : this.fields) {
                writer.writeName(field2.getName());
                BuildersHelper.encodeValue(writer, field2.getValue(), codecRegistry2);
            }
            writer.writeEndDocument();
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public String toString() {
            return "Stage{name='$addFields', fields=" + this.fields + '}';
        }
    }

    private static class FacetStage
    implements Bson {
        private final List<Facet> facets;

        FacetStage(List<Facet> facets) {
            this.facets = facets;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry2) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeName("$facet");
            writer.writeStartDocument();
            for (Facet facet : this.facets) {
                writer.writeName(facet.getName());
                writer.writeStartArray();
                for (Bson bson : facet.getPipeline()) {
                    BuildersHelper.encodeValue(writer, bson, codecRegistry2);
                }
                writer.writeEndArray();
            }
            writer.writeEndDocument();
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public String toString() {
            return "Stage{name='$fact', facets=" + this.facets + '}';
        }
    }

    private static class SortByCountStage<TExpression>
    implements Bson {
        private final TExpression filter;

        SortByCountStage(TExpression filter2) {
            this.filter = filter2;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry2) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeName("$sortByCount");
            BuildersHelper.encodeValue(writer, this.filter, codecRegistry2);
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public String toString() {
            return "Stage{name='$sortByCount', id=" + this.filter + '}';
        }
    }

    private static class GroupStage<TExpression>
    implements Bson {
        private final TExpression id;
        private final List<BsonField> fieldAccumulators;

        GroupStage(TExpression id, List<BsonField> fieldAccumulators) {
            this.id = id;
            this.fieldAccumulators = fieldAccumulators;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry2) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeStartDocument("$group");
            writer.writeName("_id");
            BuildersHelper.encodeValue(writer, this.id, codecRegistry2);
            for (BsonField fieldAccumulator : this.fieldAccumulators) {
                writer.writeName(fieldAccumulator.getName());
                BuildersHelper.encodeValue(writer, fieldAccumulator.getValue(), codecRegistry2);
            }
            writer.writeEndDocument();
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public String toString() {
            return "Stage{name='$group', id=" + this.id + ", fieldAccumulators=" + this.fieldAccumulators + '}';
        }
    }

    private static final class GraphLookupStage<TExpression>
    implements Bson {
        private final String from;
        private final TExpression startWith;
        private final String connectFromField;
        private final String connectToField;
        private final String as;
        private final GraphLookupOptions options;

        private GraphLookupStage(String from2, TExpression startWith, String connectFromField, String connectToField, String as, GraphLookupOptions options) {
            this.from = from2;
            this.startWith = startWith;
            this.connectFromField = connectFromField;
            this.connectToField = connectToField;
            this.as = as;
            this.options = options;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry2) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeStartDocument("$graphLookup");
            writer.writeString("from", this.from);
            writer.writeName("startWith");
            BuildersHelper.encodeValue(writer, this.startWith, codecRegistry2);
            writer.writeString("connectFromField", this.connectFromField);
            writer.writeString("connectToField", this.connectToField);
            writer.writeString("as", this.as);
            if (this.options.getMaxDepth() != null) {
                writer.writeInt32("maxDepth", this.options.getMaxDepth());
            }
            if (this.options.getDepthField() != null) {
                writer.writeString("depthField", this.options.getDepthField());
            }
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public String toString() {
            return "Stage{name='$graphLookup'as='" + this.as + '\'' + ", connectFromField='" + this.connectFromField + '\'' + ", connectToField='" + this.connectToField + '\'' + ", from='" + this.from + '\'' + ", options=" + this.options + ", startWith=" + this.startWith + '}';
        }
    }

    private static final class BucketAutoStage<TExpression>
    implements Bson {
        private final TExpression groupBy;
        private final int buckets;
        private final BucketAutoOptions options;

        BucketAutoStage(TExpression groupBy2, int buckets, BucketAutoOptions options) {
            Assertions.notNull("options", options);
            this.groupBy = groupBy2;
            this.buckets = buckets;
            this.options = options;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry2) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeStartDocument("$bucketAuto");
            writer.writeName("groupBy");
            BuildersHelper.encodeValue(writer, this.groupBy, codecRegistry2);
            writer.writeInt32("buckets", this.buckets);
            Aggregates.writeBucketOutput(codecRegistry2, writer, this.options.getOutput());
            if (this.options.getGranularity() != null) {
                writer.writeString("granularity", this.options.getGranularity().getValue());
            }
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public String toString() {
            return "Stage{name='$bucketAuto'buckets=" + this.buckets + ", groupBy=" + this.groupBy + ", options=" + this.options + '}';
        }
    }

    private static final class BucketStage<TExpression, TBoundary>
    implements Bson {
        private final TExpression groupBy;
        private final List<TBoundary> boundaries;
        private final BucketOptions options;

        BucketStage(TExpression groupBy2, List<TBoundary> boundaries, BucketOptions options) {
            Assertions.notNull("options", options);
            this.groupBy = groupBy2;
            this.boundaries = boundaries;
            this.options = options;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry2) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeStartDocument("$bucket");
            writer.writeName("groupBy");
            BuildersHelper.encodeValue(writer, this.groupBy, codecRegistry2);
            writer.writeStartArray("boundaries");
            for (TBoundary boundary : this.boundaries) {
                BuildersHelper.encodeValue(writer, boundary, codecRegistry2);
            }
            writer.writeEndArray();
            if (this.options.getDefaultBucket() != null) {
                writer.writeName("default");
                BuildersHelper.encodeValue(writer, this.options.getDefaultBucket(), codecRegistry2);
            }
            Aggregates.writeBucketOutput(codecRegistry2, writer, this.options.getOutput());
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public String toString() {
            return "Stage{name='$bucket'boundaries=" + this.boundaries + ", groupBy=" + this.groupBy + ", options=" + this.options + '}';
        }
    }

    private static class SimplePipelineStage
    implements Bson {
        private final String name;
        private final Bson value;

        public SimplePipelineStage(String name, Bson value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry2) {
            return new BsonDocument(this.name, this.value.toBsonDocument(documentClass, codecRegistry2));
        }

        public String toString() {
            return "Stage{name='" + this.name + '\'' + ", value=" + this.value + '}';
        }
    }
}

