/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.ConnectionString;
import com.mongodb.annotations.Immutable;
import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.event.ServerListener;
import com.mongodb.event.ServerMonitorListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

@Immutable
public class ServerSettings {
    private final long heartbeatFrequencyMS;
    private final long minHeartbeatFrequencyMS;
    private final List<ServerListener> serverListeners;
    private final List<ServerMonitorListener> serverMonitorListeners;

    public static Builder builder() {
        return new Builder();
    }

    public long getHeartbeatFrequency(TimeUnit timeUnit) {
        return timeUnit.convert(this.heartbeatFrequencyMS, TimeUnit.MILLISECONDS);
    }

    public long getMinHeartbeatFrequency(TimeUnit timeUnit) {
        return timeUnit.convert(this.minHeartbeatFrequencyMS, TimeUnit.MILLISECONDS);
    }

    public List<ServerListener> getServerListeners() {
        return Collections.unmodifiableList(this.serverListeners);
    }

    public List<ServerMonitorListener> getServerMonitorListeners() {
        return Collections.unmodifiableList(this.serverMonitorListeners);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerSettings that = (ServerSettings)o;
        if (this.heartbeatFrequencyMS != that.heartbeatFrequencyMS) {
            return false;
        }
        if (this.minHeartbeatFrequencyMS != that.minHeartbeatFrequencyMS) {
            return false;
        }
        if (!this.serverListeners.equals(that.serverListeners)) {
            return false;
        }
        return this.serverMonitorListeners.equals(that.serverMonitorListeners);
    }

    public int hashCode() {
        int result2 = (int)(this.heartbeatFrequencyMS ^ this.heartbeatFrequencyMS >>> 32);
        result2 = 31 * result2 + (int)(this.minHeartbeatFrequencyMS ^ this.minHeartbeatFrequencyMS >>> 32);
        result2 = 31 * result2 + this.serverListeners.hashCode();
        result2 = 31 * result2 + this.serverMonitorListeners.hashCode();
        return result2;
    }

    public String toString() {
        return "ServerSettings{heartbeatFrequencyMS=" + this.heartbeatFrequencyMS + ", minHeartbeatFrequencyMS=" + this.minHeartbeatFrequencyMS + ", serverListeners='" + this.serverListeners + '\'' + ", serverMonitorListeners='" + this.serverMonitorListeners + '\'' + '}';
    }

    ServerSettings(Builder builder) {
        this.heartbeatFrequencyMS = builder.heartbeatFrequencyMS;
        this.minHeartbeatFrequencyMS = builder.minHeartbeatFrequencyMS;
        this.serverListeners = builder.serverListeners;
        this.serverMonitorListeners = builder.serverMonitorListeners;
    }

    @NotThreadSafe
    public static class Builder {
        private long heartbeatFrequencyMS = 10000L;
        private long minHeartbeatFrequencyMS = 500L;
        private final List<ServerListener> serverListeners = new ArrayList<ServerListener>();
        private final List<ServerMonitorListener> serverMonitorListeners = new ArrayList<ServerMonitorListener>();

        public Builder heartbeatFrequency(long heartbeatFrequency, TimeUnit timeUnit) {
            this.heartbeatFrequencyMS = TimeUnit.MILLISECONDS.convert(heartbeatFrequency, timeUnit);
            return this;
        }

        public Builder minHeartbeatFrequency(long minHeartbeatFrequency, TimeUnit timeUnit) {
            this.minHeartbeatFrequencyMS = TimeUnit.MILLISECONDS.convert(minHeartbeatFrequency, timeUnit);
            return this;
        }

        public Builder addServerListener(ServerListener serverListener) {
            Assertions.notNull("serverListener", serverListener);
            this.serverListeners.add(serverListener);
            return this;
        }

        public Builder addServerMonitorListener(ServerMonitorListener serverMonitorListener) {
            Assertions.notNull("serverMonitorListener", serverMonitorListener);
            this.serverMonitorListeners.add(serverMonitorListener);
            return this;
        }

        public Builder applyConnectionString(ConnectionString connectionString2) {
            if (connectionString2.getHeartbeatFrequency() != null) {
                this.heartbeatFrequencyMS = connectionString2.getHeartbeatFrequency().intValue();
            }
            return this;
        }

        public ServerSettings build() {
            return new ServerSettings(this);
        }
    }
}

