/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.DuplicateKeyException;
import com.mongodb.ErrorCategory;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoException;
import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernException;
import com.mongodb.WriteConcernResult;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncWriteBinding;
import com.mongodb.binding.WriteBinding;
import com.mongodb.bulk.BulkWriteError;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.WriteRequest;
import com.mongodb.connection.AsyncConnection;
import com.mongodb.connection.Connection;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.operation.AsyncWriteOperation;
import com.mongodb.operation.OperationHelper;
import com.mongodb.operation.WriteOperation;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;

public abstract class BaseWriteOperation
implements AsyncWriteOperation<WriteConcernResult>,
WriteOperation<WriteConcernResult> {
    private final WriteConcern writeConcern;
    private final MongoNamespace namespace;
    private final boolean ordered;
    private Boolean bypassDocumentValidation;

    public BaseWriteOperation(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern2) {
        this.ordered = ordered;
        this.namespace = Assertions.notNull("namespace", namespace);
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern2);
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public BaseWriteOperation bypassDocumentValidation(Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    @Override
    public WriteConcernResult execute(WriteBinding binding) {
        return OperationHelper.withConnection(binding, new OperationHelper.CallableWithConnection<WriteConcernResult>(){

            @Override
            public WriteConcernResult call(Connection connection) {
                try {
                    OperationHelper.checkBypassDocumentValidationIsSupported(connection, BaseWriteOperation.this.bypassDocumentValidation, BaseWriteOperation.this.writeConcern);
                    if (BaseWriteOperation.this.writeConcern.isAcknowledged() && OperationHelper.serverIsAtLeastVersionTwoDotSix(connection.getDescription())) {
                        return BaseWriteOperation.this.translateBulkWriteResult(BaseWriteOperation.this.executeCommandProtocol(connection));
                    }
                    return BaseWriteOperation.this.executeProtocol(connection);
                }
                catch (MongoBulkWriteException e) {
                    throw BaseWriteOperation.this.convertBulkWriteException(e);
                }
            }
        });
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, final SingleResultCallback<WriteConcernResult> callback) {
        OperationHelper.withConnection(binding, new OperationHelper.AsyncCallableWithConnection(){

            @Override
            public void call(AsyncConnection connection, Throwable t) {
                final SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else {
                    OperationHelper.checkBypassDocumentValidationIsSupported(connection, BaseWriteOperation.this.bypassDocumentValidation, BaseWriteOperation.this.writeConcern, new OperationHelper.AsyncCallableWithConnection(){

                        @Override
                        public void call(AsyncConnection connection, Throwable t1) {
                            if (t1 != null) {
                                OperationHelper.releasingCallback(errHandlingCallback, connection).onResult(null, t1);
                            } else {
                                final SingleResultCallback wrappedCallback = OperationHelper.releasingCallback(errHandlingCallback, connection);
                                if (BaseWriteOperation.this.writeConcern.isAcknowledged() && OperationHelper.serverIsAtLeastVersionTwoDotSix(connection.getDescription())) {
                                    BaseWriteOperation.this.executeCommandProtocolAsync(connection, new SingleResultCallback<BulkWriteResult>(){

                                        @Override
                                        public void onResult(BulkWriteResult result2, Throwable t) {
                                            if (t != null) {
                                                wrappedCallback.onResult(null, BaseWriteOperation.this.translateException(t));
                                            } else {
                                                wrappedCallback.onResult(BaseWriteOperation.this.translateBulkWriteResult(result2), null);
                                            }
                                        }
                                    });
                                } else {
                                    BaseWriteOperation.this.executeProtocolAsync(connection, new SingleResultCallback<WriteConcernResult>(){

                                        @Override
                                        public void onResult(WriteConcernResult result2, Throwable t) {
                                            if (t != null) {
                                                wrappedCallback.onResult(null, BaseWriteOperation.this.translateException(t));
                                            } else {
                                                wrappedCallback.onResult(result2, null);
                                            }
                                        }
                                    });
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    protected abstract WriteConcernResult executeProtocol(Connection var1);

    protected abstract void executeProtocolAsync(AsyncConnection var1, SingleResultCallback<WriteConcernResult> var2);

    protected abstract BulkWriteResult executeCommandProtocol(Connection var1);

    protected abstract void executeCommandProtocolAsync(AsyncConnection var1, SingleResultCallback<BulkWriteResult> var2);

    private MongoException translateException(Throwable t) {
        MongoException checkedError = MongoException.fromThrowable(t);
        if (t instanceof MongoBulkWriteException) {
            checkedError = this.convertBulkWriteException((MongoBulkWriteException)t);
        }
        return checkedError;
    }

    private MongoException convertBulkWriteException(MongoBulkWriteException e) {
        BulkWriteError lastError = this.getLastError(e);
        if (lastError != null) {
            if (ErrorCategory.fromErrorCode(lastError.getCode()) == ErrorCategory.DUPLICATE_KEY) {
                return new DuplicateKeyException(this.manufactureGetLastErrorResponse(e), e.getServerAddress(), this.translateBulkWriteResult(e.getWriteResult()));
            }
            return new WriteConcernException(this.manufactureGetLastErrorResponse(e), e.getServerAddress(), this.translateBulkWriteResult(e.getWriteResult()));
        }
        return new WriteConcernException(this.manufactureGetLastErrorResponse(e), e.getServerAddress(), this.translateBulkWriteResult(e.getWriteResult()));
    }

    private BsonDocument manufactureGetLastErrorResponse(MongoBulkWriteException e) {
        BsonDocument response = new BsonDocument();
        this.addBulkWriteResultToResponse(e.getWriteResult(), response);
        if (e.getWriteConcernError() != null) {
            response.putAll(e.getWriteConcernError().getDetails());
        }
        if (this.getLastError(e) != null) {
            response.put("err", new BsonString(this.getLastError(e).getMessage()));
            response.put("code", new BsonInt32(this.getLastError(e).getCode()));
            response.putAll(this.getLastError(e).getDetails());
        } else if (e.getWriteConcernError() != null) {
            response.put("err", new BsonString(e.getWriteConcernError().getMessage()));
            response.put("code", new BsonInt32(e.getWriteConcernError().getCode()));
        }
        return response;
    }

    private void addBulkWriteResultToResponse(BulkWriteResult bulkWriteResult, BsonDocument response) {
        response.put("ok", new BsonInt32(1));
        if (this.getType() == WriteRequest.Type.INSERT) {
            response.put("n", new BsonInt32(0));
        } else if (this.getType() == WriteRequest.Type.DELETE) {
            response.put("n", new BsonInt32(bulkWriteResult.getDeletedCount()));
        } else if (this.getType() == WriteRequest.Type.UPDATE || this.getType() == WriteRequest.Type.REPLACE) {
            response.put("n", new BsonInt32(bulkWriteResult.getMatchedCount() + bulkWriteResult.getUpserts().size()));
            if (bulkWriteResult.getUpserts().isEmpty()) {
                response.put("updatedExisting", BsonBoolean.TRUE);
            } else {
                response.put("updatedExisting", BsonBoolean.FALSE);
                response.put("upserted", bulkWriteResult.getUpserts().get(0).getId());
            }
        }
    }

    private WriteConcernResult translateBulkWriteResult(BulkWriteResult bulkWriteResult) {
        return WriteConcernResult.acknowledged(this.getCount(bulkWriteResult), this.getUpdatedExisting(bulkWriteResult), bulkWriteResult.getUpserts().isEmpty() ? null : bulkWriteResult.getUpserts().get(0).getId());
    }

    protected abstract WriteRequest.Type getType();

    protected abstract int getCount(BulkWriteResult var1);

    protected boolean getUpdatedExisting(BulkWriteResult bulkWriteResult) {
        return false;
    }

    private BulkWriteError getLastError(MongoBulkWriteException e) {
        return e.getWriteErrors().isEmpty() ? null : e.getWriteErrors().get(e.getWriteErrors().size() - 1);
    }
}

