/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.MongoWriteConcernException;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcernResult;
import com.mongodb.bulk.WriteConcernError;
import com.mongodb.operation.BsonDocumentWrapperHelper;
import com.mongodb.operation.CommandOperationHelper;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;

final class FindAndModifyHelper {
    static <T> CommandOperationHelper.CommandTransformer<BsonDocument, T> transformer() {
        return new CommandOperationHelper.CommandTransformer<BsonDocument, T>(){

            @Override
            public T apply(BsonDocument result2, ServerAddress serverAddress) {
                if (result2.containsKey("writeConcernError")) {
                    throw new MongoWriteConcernException(FindAndModifyHelper.createWriteConcernError(result2.getDocument("writeConcernError")), FindAndModifyHelper.createWriteConcernResult(result2.getDocument("lastErrorObject", new BsonDocument())), serverAddress);
                }
                if (!result2.isDocument("value")) {
                    return null;
                }
                return BsonDocumentWrapperHelper.toDocument(result2.getDocument("value", null));
            }
        };
    }

    private static WriteConcernError createWriteConcernError(BsonDocument writeConcernErrorDocument) {
        return new WriteConcernError(writeConcernErrorDocument.getNumber("code").intValue(), writeConcernErrorDocument.getString("errmsg").getValue(), writeConcernErrorDocument.getDocument("errInfo", new BsonDocument()));
    }

    private static WriteConcernResult createWriteConcernResult(BsonDocument result2) {
        BsonBoolean updatedExisting = result2.getBoolean("updatedExisting", BsonBoolean.FALSE);
        return WriteConcernResult.acknowledged(result2.getNumber("n", new BsonInt32(0)).intValue(), updatedExisting.getValue(), result2.get("upserted"));
    }

    private FindAndModifyHelper() {
    }
}

