/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.rdd.partitioner;

import com.mongodb.MongoClient;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoDatabase;
import com.mongodb.spark.MongoConnector;
import com.mongodb.spark.annotation.DeveloperApi;
import com.mongodb.spark.config.MongoCollectionConfig;
import com.mongodb.spark.config.ReadConfig;
import com.mongodb.spark.rdd.partitioner.MongoPartition;
import org.bson.BsonDocument;
import org.bson.BsonMaxKey;
import org.bson.BsonMinKey;
import org.bson.BsonString;
import org.bson.BsonValue;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;

@DeveloperApi
public final class PartitionerHelper$ {
    public static final PartitionerHelper$ MODULE$;

    static {
        new PartitionerHelper$();
    }

    public BsonDocument createBoundaryQuery(String key, BsonValue lower, BsonValue upper) {
        return new BsonDocument(key, new BsonDocument("$gte", lower).append("$lt", upper));
    }

    public MongoPartition[] createPartitions(String partitionKey, Seq<BsonValue> splitKeys, Seq<String> locations2, boolean addMinMax) {
        Seq<BsonValue> seq;
        Tuple2<BsonMinKey, BsonMaxKey> minKeyMaxKeys = new Tuple2<BsonMinKey, BsonMaxKey>(new BsonMinKey(), new BsonMaxKey());
        if (addMinMax) {
            BsonMinKey bsonMinKey = minKeyMaxKeys._1();
            seq = ((SeqLike)splitKeys.$plus$colon(bsonMinKey, Seq$.MODULE$.canBuildFrom())).$colon$plus(minKeyMaxKeys._2(), Seq$.MODULE$.canBuildFrom());
        } else {
            seq = splitKeys;
        }
        Seq<BsonValue> minToMaxSplitKeys = seq;
        Seq partitionPairs = minToMaxSplitKeys.zip((GenIterable)minToMaxSplitKeys.tail(), Seq$.MODULE$.canBuildFrom());
        return (MongoPartition[])((TraversableOnce)((TraversableLike)partitionPairs.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map(new Serializable(partitionKey, locations2){
            public static final long serialVersionUID = 0L;
            private final String partitionKey$1;
            private final Seq locations$1;

            public final MongoPartition apply(Tuple2<Tuple2<BsonValue, BsonValue>, Object> x0$1) {
                Tuple2<Tuple2<BsonValue, BsonValue>, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Tuple2<BsonValue, BsonValue> tuple22 = tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    if (tuple22 != null) {
                        BsonValue min2 = tuple22._1();
                        BsonValue max2 = tuple22._2();
                        if (min2 != null) {
                            BsonValue bsonValue = min2;
                            if (max2 != null) {
                                BsonValue bsonValue2 = max2;
                                int n = i;
                                MongoPartition mongoPartition = new MongoPartition(n, PartitionerHelper$.MODULE$.createBoundaryQuery(this.partitionKey$1, bsonValue, bsonValue2), this.locations$1);
                                return mongoPartition;
                            }
                        }
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                this.partitionKey$1 = partitionKey$1;
                this.locations$1 = locations$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(MongoPartition.class));
    }

    public Seq<String> createPartitions$default$3() {
        return Nil$.MODULE$;
    }

    public boolean createPartitions$default$4() {
        return true;
    }

    public Seq<String> locations(MongoConnector connector) {
        return connector.withMongoClientDo(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Buffer<String> apply(MongoClient mongoClient) {
                return (Buffer)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(mongoClient.getAllAddress()).asScala()).map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(ServerAddress x$2) {
                        return x$2.getHost();
                    }
                }, Buffer$.MODULE$.canBuildFrom())).distinct();
            }
        });
    }

    public BsonDocument collStats(MongoConnector connector, ReadConfig readConfig) {
        BsonDocument collStatsCommand = new BsonDocument("collStats", new BsonString(readConfig.collectionName()));
        return connector.withDatabaseDo((MongoCollectionConfig)readConfig, new Serializable(readConfig, collStatsCommand){
            public static final long serialVersionUID = 0L;
            private final ReadConfig readConfig$1;
            private final BsonDocument collStatsCommand$1;

            public final BsonDocument apply(MongoDatabase db) {
                return db.runCommand(this.collStatsCommand$1, this.readConfig$1.readPreference(), BsonDocument.class);
            }
            {
                this.readConfig$1 = readConfig$1;
                this.collStatsCommand$1 = collStatsCommand$1;
            }
        });
    }

    public BsonDocument matchQuery(BsonDocument[] pipeline) {
        Option option;
        block4: {
            BsonDocument bsonDocument;
            block3: {
                BsonDocument defaultQuery;
                block2: {
                    defaultQuery = new BsonDocument();
                    option = Predef$.MODULE$.refArrayOps((Object[])pipeline).headOption();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    BsonDocument document = (BsonDocument)some.x();
                    bsonDocument = document.getDocument("$match", defaultQuery);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                bsonDocument = defaultQuery;
            }
            return bsonDocument;
        }
        throw new MatchError(option);
    }

    public Tuple2<BsonValue, BsonValue> getSplitVectorRangeQuery(String partitionKey, BsonDocument[] pipeline) {
        Option option;
        block4: {
            BsonDocument bsonDocument;
            block3: {
                block2: {
                    Some some;
                    BsonDocument document;
                    option = Predef$.MODULE$.refArrayOps((Object[])pipeline).headOption();
                    if (!(option instanceof Some) || (document = (BsonDocument)(some = (Some)option).x()) == null) break block2;
                    BsonDocument bsonDocument2 = document;
                    bsonDocument = this.getNestedDocument((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"$match", partitionKey})), bsonDocument2);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                bsonDocument = new BsonDocument();
            }
            BsonDocument filter2 = bsonDocument;
            return new Tuple2<BsonValue, BsonValue>(filter2.get("$gte", new BsonMinKey()), filter2.get("$lt", new BsonMaxKey()));
        }
        throw new MatchError(option);
    }

    public MongoPartition[] setLastBoundaryToLessThanOrEqualTo(String partitionKey, MongoPartition[] partitions2) {
        MongoPartition lastPartition = (MongoPartition)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])partitions2).reverse()).head();
        BsonDocument partitionQuery = lastPartition.queryBounds().getDocument(partitionKey);
        partitionQuery.append("$lte", partitionQuery.remove("$lt"));
        return partitions2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private BsonDocument getNestedDocument(Seq<String> keys, BsonDocument document) {
        BsonDocument bsonDocument;
        while (keys.nonEmpty() && document.containsKey(keys.head())) {
            BsonValue bsonValue = document.get(keys.head());
            if (!bsonValue.isDocument()) {
                bsonDocument = new BsonDocument();
                return bsonDocument;
            }
            BsonDocument subDoc = bsonValue.asDocument();
            if (((SeqLike)keys.tail()).isEmpty()) {
                bsonDocument = subDoc;
                return bsonDocument;
            }
            document = subDoc;
            keys = (Seq)keys.tail();
        }
        bsonDocument = new BsonDocument();
        return bsonDocument;
    }

    private PartitionerHelper$() {
        MODULE$ = this;
    }
}

