/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import org.bson.BsonType;
import org.bson.assertions.Assertions;
import org.bson.codecs.BsonTypeClassMap;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecRegistry;

public class BsonTypeCodecMap {
    private final Codec<?>[] codecs = new Codec[256];

    public BsonTypeCodecMap(BsonTypeClassMap bsonTypeClassMap, CodecRegistry codecRegistry2) {
        Assertions.notNull("bsonTypeClassMap", bsonTypeClassMap);
        Assertions.notNull("codecRegistry", codecRegistry2);
        for (BsonType cur : bsonTypeClassMap.keys()) {
            Class<?> clazz = bsonTypeClassMap.get(cur);
            if (clazz == null) continue;
            this.codecs[cur.getValue()] = codecRegistry2.get(clazz);
        }
    }

    public Codec<?> get(BsonType bsonType) {
        return this.codecs[bsonType.getValue()];
    }
}

