/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.UpdatePartitionSpec;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.BoundReference;
import org.apache.iceberg.expressions.BoundTerm;
import org.apache.iceberg.expressions.BoundTransform;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.transforms.PartitionSpecVisitor;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.transforms.UnknownTransform;
import org.apache.iceberg.util.Pair;

class BaseUpdatePartitionSpec
implements UpdatePartitionSpec {
    private final TableOperations ops;
    private final TableMetadata base;
    private final int formatVersion;
    private final PartitionSpec spec;
    private final Schema schema;
    private final Map<String, PartitionField> nameToField;
    private final Map<Pair<Integer, String>, PartitionField> transformToField;
    private final List<PartitionField> adds = Lists.newArrayList();
    private final Map<Integer, PartitionField> addedTimeFields = Maps.newHashMap();
    private final Map<Pair<Integer, String>, PartitionField> transformToAddedField = Maps.newHashMap();
    private final Map<String, PartitionField> nameToAddedField = Maps.newHashMap();
    private final Set<Object> deletes = Sets.newHashSet();
    private final Map<String, String> renames = Maps.newHashMap();
    private boolean caseSensitive;
    private int lastAssignedPartitionId;

    BaseUpdatePartitionSpec(TableOperations ops) {
        this.ops = ops;
        this.caseSensitive = true;
        this.base = ops.current();
        this.formatVersion = this.base.formatVersion();
        this.spec = this.base.spec();
        this.schema = this.spec.schema();
        this.nameToField = BaseUpdatePartitionSpec.indexSpecByName(this.spec);
        this.transformToField = BaseUpdatePartitionSpec.indexSpecByTransform(this.spec);
        this.lastAssignedPartitionId = this.base.lastAssignedPartitionId();
        this.spec.fields().stream().filter(field -> field.transform() instanceof UnknownTransform).findAny().ifPresent(field -> {
            throw new IllegalArgumentException("Cannot update partition spec with unknown transform: " + field);
        });
    }

    @VisibleForTesting
    BaseUpdatePartitionSpec(int formatVersion, PartitionSpec spec) {
        this(formatVersion, spec, spec.fields().stream().mapToInt(PartitionField::fieldId).max().orElse(999));
    }

    @VisibleForTesting
    BaseUpdatePartitionSpec(int formatVersion, PartitionSpec spec, int lastAssignedPartitionId) {
        this.ops = null;
        this.base = null;
        this.formatVersion = formatVersion;
        this.caseSensitive = true;
        this.spec = spec;
        this.schema = spec.schema();
        this.nameToField = BaseUpdatePartitionSpec.indexSpecByName(spec);
        this.transformToField = BaseUpdatePartitionSpec.indexSpecByTransform(spec);
        this.lastAssignedPartitionId = lastAssignedPartitionId;
    }

    private int assignFieldId() {
        ++this.lastAssignedPartitionId;
        return this.lastAssignedPartitionId;
    }

    @Override
    public UpdatePartitionSpec caseSensitive(boolean isCaseSensitive) {
        this.caseSensitive = isCaseSensitive;
        return this;
    }

    @Override
    public BaseUpdatePartitionSpec addField(String sourceName) {
        return this.addField(Expressions.ref(sourceName));
    }

    @Override
    public BaseUpdatePartitionSpec addField(Term term) {
        return this.addField(null, term);
    }

    private BaseUpdatePartitionSpec rewriteDeleteAndAddField(PartitionField existing, String name, Pair<Integer, Transform<?, ?>> sourceTransform) {
        this.deletes.remove(existing.fieldId());
        if (name == null || existing.name().equals(name)) {
            return this;
        }
        return this.renameField(existing.name(), name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public BaseUpdatePartitionSpec addField(String name, Term term) {
        PartitionField alreadyAdded = this.nameToAddedField.get(name);
        Preconditions.checkArgument(alreadyAdded == null, "Cannot add duplicate partition field: %s", (Object)alreadyAdded);
        Pair<Integer, Transform<?, ?>> sourceTransform = this.resolve(term);
        Pair<Integer, String> validationKey = Pair.of(sourceTransform.first(), sourceTransform.second().toString());
        PartitionField existing = this.transformToField.get(validationKey);
        if (existing != null && this.deletes.contains(existing.fieldId()) && existing.transform().equals(sourceTransform.second())) {
            return this.rewriteDeleteAndAddField(existing, name, sourceTransform);
        }
        Preconditions.checkArgument(existing == null || this.deletes.contains(existing.fieldId()) && !existing.transform().toString().equals(sourceTransform.second().toString()), "Cannot add duplicate partition field %s=%s, conflicts with %s", (Object)name, (Object)term, (Object)existing);
        PartitionField added = this.transformToAddedField.get(validationKey);
        Preconditions.checkArgument(added == null, "Cannot add duplicate partition field %s=%s, already added: %s", (Object)name, (Object)term, (Object)added);
        PartitionField newField = new PartitionField(sourceTransform.first(), this.assignFieldId(), name, sourceTransform.second());
        if (newField.name() == null) {
            String partitionName = PartitionSpecVisitor.visit(this.schema, newField, PartitionNameGenerator.INSTANCE);
            newField = new PartitionField(newField.sourceId(), newField.fieldId(), partitionName, newField.transform());
        }
        this.checkForRedundantAddedPartitions(newField);
        this.transformToAddedField.put(validationKey, newField);
        PartitionField existingField = this.nameToField.get(newField.name());
        if (existingField != null && !this.deletes.contains(existingField.fieldId())) {
            if (!this.isVoidTransform(existingField)) throw new IllegalArgumentException(String.format("Cannot add duplicate partition field name: %s", name));
            this.renameField(existingField.name(), existingField.name() + "_" + existingField.fieldId());
        } else if (existingField != null && this.deletes.contains(existingField.fieldId())) {
            this.renames.put(existingField.name(), existingField.name() + "_" + existingField.fieldId());
        }
        this.nameToAddedField.put(newField.name(), newField);
        this.adds.add(newField);
        return this;
    }

    @Override
    public BaseUpdatePartitionSpec removeField(String name) {
        PartitionField alreadyAdded = this.nameToAddedField.get(name);
        Preconditions.checkArgument(alreadyAdded == null, "Cannot delete newly added field: %s", (Object)alreadyAdded);
        Preconditions.checkArgument(this.renames.get(name) == null, "Cannot rename and delete partition field: %s", (Object)name);
        PartitionField field = this.nameToField.get(name);
        Preconditions.checkArgument(field != null, "Cannot find partition field to remove: %s", (Object)name);
        this.deletes.add(field.fieldId());
        return this;
    }

    @Override
    public BaseUpdatePartitionSpec removeField(Term term) {
        Pair<Integer, Transform<?, ?>> sourceTransform = this.resolve(term);
        Pair<Integer, String> key = Pair.of(sourceTransform.first(), sourceTransform.second().toString());
        PartitionField added = this.transformToAddedField.get(key);
        Preconditions.checkArgument(added == null, "Cannot delete newly added field: %s", (Object)added);
        PartitionField field = this.transformToField.get(key);
        Preconditions.checkArgument(field != null, "Cannot find partition field to remove: %s", (Object)term);
        Preconditions.checkArgument(this.renames.get(field.name()) == null, "Cannot rename and delete partition field: %s", (Object)field.name());
        this.deletes.add(field.fieldId());
        return this;
    }

    @Override
    public BaseUpdatePartitionSpec renameField(String name, String newName) {
        PartitionField added;
        PartitionField existingField = this.nameToField.get(newName);
        if (existingField != null && this.isVoidTransform(existingField)) {
            this.renameField(existingField.name(), existingField.name() + "_" + existingField.fieldId());
        }
        Preconditions.checkArgument((added = this.nameToAddedField.get(name)) == null, "Cannot rename newly added partition field: %s", (Object)name);
        PartitionField field = this.nameToField.get(name);
        Preconditions.checkArgument(field != null, "Cannot find partition field to rename: %s", (Object)name);
        Preconditions.checkArgument(!this.deletes.contains(field.fieldId()), "Cannot delete and rename partition field: %s", (Object)name);
        this.renames.put(name, newName);
        return this;
    }

    @Override
    public PartitionSpec apply() {
        PartitionSpec.Builder builder = PartitionSpec.builderFor(this.schema);
        for (PartitionField field : this.spec.fields()) {
            String newName;
            if (!this.deletes.contains(field.fieldId())) {
                newName = this.renames.get(field.name());
                if (newName != null) {
                    builder.add(field.sourceId(), field.fieldId(), newName, field.transform());
                    continue;
                }
                builder.add(field.sourceId(), field.fieldId(), field.name(), field.transform());
                continue;
            }
            if (this.formatVersion >= 2) continue;
            newName = this.renames.get(field.name());
            if (newName != null) {
                builder.add(field.sourceId(), field.fieldId(), newName, Transforms.alwaysNull());
                continue;
            }
            builder.add(field.sourceId(), field.fieldId(), field.name(), Transforms.alwaysNull());
        }
        for (PartitionField newField : this.adds) {
            builder.add(newField.sourceId(), newField.fieldId(), newField.name(), newField.transform());
        }
        return builder.build();
    }

    @Override
    public void commit() {
        TableMetadata update = this.base.updatePartitionSpec(this.apply());
        this.ops.commit(this.base, update);
    }

    private Pair<Integer, Transform<?, ?>> resolve(Term term) {
        Preconditions.checkArgument(term instanceof UnboundTerm, "Term must be unbound");
        BoundTerm boundTerm = (BoundTerm)((UnboundTerm)term).bind(this.schema.asStruct(), this.caseSensitive);
        int sourceId = boundTerm.ref().fieldId();
        Transform<?, ?> transform = this.toTransform(boundTerm);
        return Pair.of(sourceId, transform);
    }

    private Transform<?, ?> toTransform(BoundTerm<?> term) {
        if (term instanceof BoundReference) {
            return Transforms.identity(term.type());
        }
        if (term instanceof BoundTransform) {
            return ((BoundTransform)term).transform();
        }
        throw new ValidationException("Invalid term: %s, expected either a bound reference or transform", term);
    }

    private void checkForRedundantAddedPartitions(PartitionField field) {
        if (this.isTimeTransform(field)) {
            PartitionField timeField = this.addedTimeFields.get(field.sourceId());
            Preconditions.checkArgument(timeField == null, "Cannot add redundant partition field: %s conflicts with %s", (Object)timeField, (Object)field);
            this.addedTimeFields.put(field.sourceId(), field);
        }
    }

    private static Map<String, PartitionField> indexSpecByName(PartitionSpec spec) {
        ImmutableMap.Builder<String, PartitionField> builder = ImmutableMap.builder();
        List<PartitionField> fields = spec.fields();
        for (PartitionField field : fields) {
            builder.put(field.name(), field);
        }
        return builder.build();
    }

    private static Map<Pair<Integer, String>, PartitionField> indexSpecByTransform(PartitionSpec spec) {
        HashMap<Pair<Integer, String>, PartitionField> indexSpecs = Maps.newHashMap();
        List<PartitionField> fields = spec.fields();
        for (PartitionField field : fields) {
            indexSpecs.put(Pair.of(field.sourceId(), field.transform().toString()), field);
        }
        return indexSpecs;
    }

    private boolean isTimeTransform(PartitionField field) {
        return PartitionSpecVisitor.visit(this.schema, field, IsTimeTransform.INSTANCE);
    }

    private boolean isVoidTransform(PartitionField field) {
        return PartitionSpecVisitor.visit(this.schema, field, IsVoidTransform.INSTANCE);
    }

    private static class PartitionNameGenerator
    implements PartitionSpecVisitor<String> {
        private static final PartitionNameGenerator INSTANCE = new PartitionNameGenerator();

        private PartitionNameGenerator() {
        }

        @Override
        public String identity(int fieldId, String sourceName, int sourceId) {
            return sourceName;
        }

        @Override
        public String bucket(int fieldId, String sourceName, int sourceId, int numBuckets) {
            return sourceName + "_bucket_" + numBuckets;
        }

        @Override
        public String truncate(int fieldId, String sourceName, int sourceId, int width) {
            return sourceName + "_trunc_" + width;
        }

        @Override
        public String year(int fieldId, String sourceName, int sourceId) {
            return sourceName + "_year";
        }

        @Override
        public String month(int fieldId, String sourceName, int sourceId) {
            return sourceName + "_month";
        }

        @Override
        public String day(int fieldId, String sourceName, int sourceId) {
            return sourceName + "_day";
        }

        @Override
        public String hour(int fieldId, String sourceName, int sourceId) {
            return sourceName + "_hour";
        }

        @Override
        public String alwaysNull(int fieldId, String sourceName, int sourceId) {
            return sourceName + "_null";
        }
    }

    private static class IsVoidTransform
    implements PartitionSpecVisitor<Boolean> {
        private static final IsVoidTransform INSTANCE = new IsVoidTransform();

        private IsVoidTransform() {
        }

        @Override
        public Boolean identity(int fieldId, String sourceName, int sourceId) {
            return false;
        }

        @Override
        public Boolean bucket(int fieldId, String sourceName, int sourceId, int numBuckets) {
            return false;
        }

        @Override
        public Boolean truncate(int fieldId, String sourceName, int sourceId, int width) {
            return false;
        }

        @Override
        public Boolean year(int fieldId, String sourceName, int sourceId) {
            return false;
        }

        @Override
        public Boolean month(int fieldId, String sourceName, int sourceId) {
            return false;
        }

        @Override
        public Boolean day(int fieldId, String sourceName, int sourceId) {
            return false;
        }

        @Override
        public Boolean hour(int fieldId, String sourceName, int sourceId) {
            return false;
        }

        @Override
        public Boolean alwaysNull(int fieldId, String sourceName, int sourceId) {
            return true;
        }

        @Override
        public Boolean unknown(int fieldId, String sourceName, int sourceId, String transform) {
            return false;
        }
    }

    private static class IsTimeTransform
    implements PartitionSpecVisitor<Boolean> {
        private static final IsTimeTransform INSTANCE = new IsTimeTransform();

        private IsTimeTransform() {
        }

        @Override
        public Boolean identity(int fieldId, String sourceName, int sourceId) {
            return false;
        }

        @Override
        public Boolean bucket(int fieldId, String sourceName, int sourceId, int numBuckets) {
            return false;
        }

        @Override
        public Boolean truncate(int fieldId, String sourceName, int sourceId, int width) {
            return false;
        }

        @Override
        public Boolean year(int fieldId, String sourceName, int sourceId) {
            return true;
        }

        @Override
        public Boolean month(int fieldId, String sourceName, int sourceId) {
            return true;
        }

        @Override
        public Boolean day(int fieldId, String sourceName, int sourceId) {
            return true;
        }

        @Override
        public Boolean hour(int fieldId, String sourceName, int sourceId) {
            return true;
        }

        @Override
        public Boolean alwaysNull(int fieldId, String sourceName, int sourceId) {
            return false;
        }

        @Override
        public Boolean unknown(int fieldId, String sourceName, int sourceId, String transform) {
            return false;
        }
    }
}

