/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.iceberg.DataTableScan;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.events.IncrementalScanEvent;
import org.apache.iceberg.events.Listeners;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.FluentIterable;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.iceberg.util.ThreadPools;

class IncrementalDataTableScan
extends DataTableScan {
    IncrementalDataTableScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
        super(ops, table, schema, context.useSnapshotId(null));
        IncrementalDataTableScan.validateSnapshotIds(table, context.fromSnapshotId(), context.toSnapshotId());
    }

    @Override
    public TableScan asOfTime(long timestampMillis) {
        throw new UnsupportedOperationException(String.format("Cannot scan table as of time %s: configured for incremental data in snapshots (%s, %s]", timestampMillis, this.context().fromSnapshotId(), this.context().toSnapshotId()));
    }

    @Override
    public TableScan useSnapshot(long scanSnapshotId) {
        throw new UnsupportedOperationException(String.format("Cannot scan table using scan snapshot id %s: configured for incremental data in snapshots (%s, %s]", scanSnapshotId, this.context().fromSnapshotId(), this.context().toSnapshotId()));
    }

    @Override
    public TableScan appendsBetween(long fromSnapshotId, long toSnapshotId) {
        this.validateSnapshotIdsRefinement(fromSnapshotId, toSnapshotId);
        return new IncrementalDataTableScan(this.tableOps(), this.table(), this.schema(), this.context().fromSnapshotId(fromSnapshotId).toSnapshotId(toSnapshotId));
    }

    @Override
    public TableScan appendsAfter(long newFromSnapshotId) {
        Snapshot currentSnapshot = this.table().currentSnapshot();
        Preconditions.checkState(currentSnapshot != null, "Cannot scan appends after %s, there is no current snapshot", newFromSnapshotId);
        return this.appendsBetween(newFromSnapshotId, currentSnapshot.snapshotId());
    }

    @Override
    public CloseableIterable<FileScanTask> planFiles() {
        List<Snapshot> snapshots = IncrementalDataTableScan.snapshotsWithin(this.table(), this.context().fromSnapshotId(), this.context().toSnapshotId());
        HashSet snapshotIds = Sets.newHashSet(Iterables.transform(snapshots, Snapshot::snapshotId));
        ImmutableSet<ManifestFile> manifests = FluentIterable.from(snapshots).transformAndConcat(Snapshot::dataManifests).filter(manifestFile -> snapshotIds.contains(manifestFile.snapshotId())).toSet();
        ManifestGroup manifestGroup = new ManifestGroup(this.tableOps().io(), manifests).caseSensitive(this.isCaseSensitive()).select(this.colStats() ? SCAN_WITH_STATS_COLUMNS : SCAN_COLUMNS).filterData(this.filter()).filterManifestEntries(manifestEntry -> snapshotIds.contains(manifestEntry.snapshotId()) && manifestEntry.status() == ManifestEntry.Status.ADDED).specsById(this.tableOps().current().specsById()).ignoreDeleted();
        if (this.shouldIgnoreResiduals()) {
            manifestGroup = manifestGroup.ignoreResiduals();
        }
        Listeners.notifyAll(new IncrementalScanEvent(this.table().name(), this.context().fromSnapshotId(), this.context().toSnapshotId(), this.context().rowFilter(), this.schema()));
        if (PLAN_SCANS_WITH_WORKER_POOL && manifests.size() > 1) {
            manifestGroup = manifestGroup.planWith(ThreadPools.getWorkerPool());
        }
        return manifestGroup.planFiles();
    }

    @Override
    protected TableScan newRefinedScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
        return new IncrementalDataTableScan(ops, table, schema, context);
    }

    private static List<Snapshot> snapshotsWithin(Table table, long fromSnapshotId, long toSnapshotId) {
        ArrayList<Snapshot> snapshots = Lists.newArrayList();
        for (Snapshot snapshot : SnapshotUtil.ancestorsBetween(toSnapshotId, fromSnapshotId, table::snapshot)) {
            if (snapshot.operation().equals("append")) {
                snapshots.add(snapshot);
                continue;
            }
            if (!snapshot.operation().equals("overwrite")) continue;
            throw new UnsupportedOperationException(String.format("Found %s operation, cannot support incremental data in snapshots (%s, %s]", "overwrite", fromSnapshotId, toSnapshotId));
        }
        return snapshots;
    }

    private void validateSnapshotIdsRefinement(long newFromSnapshotId, long newToSnapshotId) {
        HashSet<Long> snapshotIdsRange = Sets.newHashSet(SnapshotUtil.ancestorIdsBetween(this.context().toSnapshotId(), this.context().fromSnapshotId(), this.table()::snapshot));
        snapshotIdsRange.add(this.context().fromSnapshotId());
        Preconditions.checkArgument(snapshotIdsRange.contains(newFromSnapshotId), "from snapshot id %s not in existing snapshot ids range (%s, %s]", (Object)newFromSnapshotId, (Object)this.context().fromSnapshotId(), (Object)newToSnapshotId);
        Preconditions.checkArgument(snapshotIdsRange.contains(newToSnapshotId), "to snapshot id %s not in existing snapshot ids range (%s, %s]", (Object)newToSnapshotId, (Object)this.context().fromSnapshotId(), (Object)this.context().toSnapshotId());
    }

    private static void validateSnapshotIds(Table table, long fromSnapshotId, long toSnapshotId) {
        Preconditions.checkArgument(fromSnapshotId != toSnapshotId, "from and to snapshot ids cannot be the same");
        Preconditions.checkArgument(table.snapshot(fromSnapshotId) != null, "from snapshot %s does not exist", fromSnapshotId);
        Preconditions.checkArgument(table.snapshot(toSnapshotId) != null, "to snapshot %s does not exist", toSnapshotId);
        Preconditions.checkArgument(SnapshotUtil.isAncestorOf(table, toSnapshotId, fromSnapshotId), "from snapshot %s is not an ancestor of to snapshot  %s", fromSnapshotId, toSnapshotId);
    }
}

