/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Map;
import java.util.Set;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.types.Types;

public class MetadataColumns {
    public static final Types.NestedField FILE_PATH = Types.NestedField.required(0x7FFFFFFE, "_file", Types.StringType.get(), "Path of the file in which a row is stored");
    public static final Types.NestedField ROW_POSITION = Types.NestedField.required(0x7FFFFFFD, "_pos", Types.LongType.get(), "Ordinal position of a row in the source data file");
    public static final Types.NestedField IS_DELETED = Types.NestedField.required(0x7FFFFFFC, "_deleted", Types.BooleanType.get(), "Whether the row has been deleted");
    public static final Types.NestedField SPEC_ID = Types.NestedField.required(0x7FFFFFFB, "_spec_id", Types.IntegerType.get(), "Spec ID used to track the file containing a row");
    public static final int PARTITION_COLUMN_ID = 0x7FFFFFFA;
    public static final String PARTITION_COLUMN_NAME = "_partition";
    public static final String PARTITION_COLUMN_DOC = "Partition to which a row belongs to";
    public static final Types.NestedField DELETE_FILE_PATH = Types.NestedField.required(2147483546, "file_path", Types.StringType.get(), "Path of a file in which a deleted row is stored");
    public static final Types.NestedField DELETE_FILE_POS = Types.NestedField.required(0x7FFFFF99, "pos", Types.LongType.get(), "Ordinal position of a deleted row in the data file");
    public static final String DELETE_FILE_ROW_FIELD_NAME = "row";
    public static final int DELETE_FILE_ROW_FIELD_ID = 2147483544;
    public static final String DELETE_FILE_ROW_DOC = "Deleted row values";
    private static final Map<String, Types.NestedField> META_COLUMNS = ImmutableMap.of(FILE_PATH.name(), FILE_PATH, ROW_POSITION.name(), ROW_POSITION, IS_DELETED.name(), IS_DELETED, SPEC_ID.name(), SPEC_ID);
    private static final Set<Integer> META_IDS = ImmutableSet.of(Integer.valueOf(FILE_PATH.fieldId()), Integer.valueOf(ROW_POSITION.fieldId()), Integer.valueOf(IS_DELETED.fieldId()), Integer.valueOf(SPEC_ID.fieldId()), Integer.valueOf(0x7FFFFFFA));

    private MetadataColumns() {
    }

    public static Set<Integer> metadataFieldIds() {
        return META_IDS;
    }

    public static Types.NestedField metadataColumn(Table table, String name) {
        if (name.equals(PARTITION_COLUMN_NAME)) {
            return Types.NestedField.optional(0x7FFFFFFA, PARTITION_COLUMN_NAME, Partitioning.partitionType(table), PARTITION_COLUMN_DOC);
        }
        return META_COLUMNS.get(name);
    }

    public static boolean isMetadataColumn(String name) {
        return name.equals(PARTITION_COLUMN_NAME) || META_COLUMNS.containsKey(name);
    }

    public static boolean nonMetadataColumn(String name) {
        return !MetadataColumns.isMetadataColumn(name);
    }
}

