/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Map;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataTableScan;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ManifestGroup;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StaticDataTask;
import org.apache.iceberg.StaticTableScan;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.SystemProperties;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Projections;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeWrapper;
import org.apache.iceberg.util.ThreadPools;

public class PartitionsTable
extends BaseMetadataTable {
    private final Schema schema;
    static final boolean PLAN_SCANS_WITH_WORKER_POOL = SystemProperties.getBoolean("iceberg.scan.plan-in-worker-pool", true);

    PartitionsTable(TableOperations ops, Table table) {
        this(ops, table, table.name() + ".partitions");
    }

    PartitionsTable(TableOperations ops, Table table, String name) {
        super(ops, table, name);
        this.schema = new Schema(Types.NestedField.required(1, "partition", table.spec().partitionType()), Types.NestedField.required(2, "record_count", Types.LongType.get()), Types.NestedField.required(3, "file_count", Types.IntegerType.get()));
    }

    @Override
    public TableScan newScan() {
        return new PartitionsScan(this.operations(), this.table());
    }

    @Override
    public Schema schema() {
        if (this.table().spec().fields().size() < 1) {
            return this.schema.select("record_count", "file_count");
        }
        return this.schema;
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.PARTITIONS;
    }

    private DataTask task(StaticTableScan scan) {
        TableOperations ops = this.operations();
        Iterable<Partition> partitions = PartitionsTable.partitions(scan);
        if (this.table().spec().fields().size() < 1) {
            return StaticDataTask.of(this.io().newInputFile(ops.current().metadataFileLocation()), this.schema(), scan.schema(), partitions, root -> StaticDataTask.Row.of(((Partition)root).recordCount, ((Partition)root).fileCount));
        }
        return StaticDataTask.of(this.io().newInputFile(ops.current().metadataFileLocation()), this.schema(), scan.schema(), partitions, PartitionsTable::convertPartition);
    }

    private static StaticDataTask.Row convertPartition(Partition partition) {
        return StaticDataTask.Row.of(partition.key, partition.recordCount, partition.fileCount);
    }

    private static Iterable<Partition> partitions(StaticTableScan scan) {
        CloseableIterable<FileScanTask> tasks = PartitionsTable.planFiles(scan);
        PartitionMap partitions = new PartitionMap(scan.table().spec().partitionType());
        for (FileScanTask task : tasks) {
            partitions.get(task.file().partition()).update(task.file());
        }
        return partitions.all();
    }

    @VisibleForTesting
    static CloseableIterable<FileScanTask> planFiles(StaticTableScan scan) {
        Table table = scan.table();
        Snapshot snapshot = table.snapshot(scan.snapshot().snapshotId());
        boolean caseSensitive = scan.isCaseSensitive();
        Expression partitionFilter = Projections.inclusive(PartitionsTable.transformSpec(scan.schema(), table.spec(), "partition."), caseSensitive).project(scan.filter());
        ManifestGroup manifestGroup = new ManifestGroup(table.io(), snapshot.dataManifests(), snapshot.deleteManifests()).caseSensitive(caseSensitive).filterPartitions(partitionFilter).select(scan.colStats() ? DataTableScan.SCAN_WITH_STATS_COLUMNS : DataTableScan.SCAN_COLUMNS).specsById(scan.table().specs()).ignoreDeleted();
        if (scan.shouldIgnoreResiduals()) {
            manifestGroup = manifestGroup.ignoreResiduals();
        }
        if (PLAN_SCANS_WITH_WORKER_POOL && scan.snapshot().dataManifests().size() > 1) {
            manifestGroup = manifestGroup.planWith(ThreadPools.getWorkerPool());
        }
        return manifestGroup.planFiles();
    }

    static class Partition {
        private final StructLike key;
        private long recordCount;
        private int fileCount;

        Partition(StructLike key) {
            this.key = key;
            this.recordCount = 0L;
            this.fileCount = 0;
        }

        void update(DataFile file) {
            this.recordCount += file.recordCount();
            ++this.fileCount;
        }
    }

    static class PartitionMap {
        private final Map<StructLikeWrapper, Partition> partitions = Maps.newHashMap();
        private final Types.StructType type;
        private final StructLikeWrapper reused;

        PartitionMap(Types.StructType type) {
            this.type = type;
            this.reused = StructLikeWrapper.forType(type);
        }

        Partition get(StructLike key) {
            Partition partition = this.partitions.get(this.reused.set(key));
            if (partition == null) {
                partition = new Partition(key);
                this.partitions.put(StructLikeWrapper.forType(this.type).set(key), partition);
            }
            return partition;
        }

        Iterable<Partition> all() {
            return this.partitions.values();
        }
    }

    private class PartitionsScan
    extends StaticTableScan {
        PartitionsScan(TableOperations ops, Table table) {
            super(ops, table, PartitionsTable.this.schema(), PartitionsTable.this.metadataTableType().name(), x$0 -> PartitionsTable.this.task(x$0));
        }
    }
}

