/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.MetadataUpdate;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SortField;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.TableProperties;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Objects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.PropertyUtil;

public class TableMetadata
implements Serializable {
    static final long INITIAL_SEQUENCE_NUMBER = 0L;
    static final long INVALID_SEQUENCE_NUMBER = -1L;
    static final int DEFAULT_TABLE_FORMAT_VERSION = 1;
    static final int SUPPORTED_TABLE_FORMAT_VERSION = 2;
    static final int INITIAL_SPEC_ID = 0;
    static final int INITIAL_SORT_ORDER_ID = 1;
    static final int INITIAL_SCHEMA_ID = 0;
    private static final long ONE_MINUTE = TimeUnit.MINUTES.toMillis(1L);
    private final String metadataFileLocation;
    private final int formatVersion;
    private final String uuid;
    private final String location;
    private final long lastSequenceNumber;
    private final long lastUpdatedMillis;
    private final int lastColumnId;
    private final int currentSchemaId;
    private final List<Schema> schemas;
    private final int defaultSpecId;
    private final List<PartitionSpec> specs;
    private final int lastAssignedPartitionId;
    private final int defaultSortOrderId;
    private final List<SortOrder> sortOrders;
    private final Map<String, String> properties;
    private final long currentSnapshotId;
    private final List<Snapshot> snapshots;
    private final Map<Long, Snapshot> snapshotsById;
    private final Map<Integer, Schema> schemasById;
    private final Map<Integer, PartitionSpec> specsById;
    private final Map<Integer, SortOrder> sortOrdersById;
    private final List<HistoryEntry> snapshotLog;
    private final List<MetadataLogEntry> previousFiles;
    private final List<MetadataUpdate> changes;

    public static TableMetadata newTableMetadata(Schema schema, PartitionSpec spec, SortOrder sortOrder, String location, Map<String, String> properties) {
        int formatVersion = PropertyUtil.propertyAsInt(properties, "format-version", 1);
        return TableMetadata.newTableMetadata(schema, spec, sortOrder, location, TableMetadata.unreservedProperties(properties), formatVersion);
    }

    public static TableMetadata newTableMetadata(Schema schema, PartitionSpec spec, String location, Map<String, String> properties) {
        SortOrder sortOrder = SortOrder.unsorted();
        int formatVersion = PropertyUtil.propertyAsInt(properties, "format-version", 1);
        return TableMetadata.newTableMetadata(schema, spec, sortOrder, location, TableMetadata.unreservedProperties(properties), formatVersion);
    }

    private static Map<String, String> unreservedProperties(Map<String, String> rawProperties) {
        return rawProperties.entrySet().stream().filter(e -> !TableProperties.RESERVED_PROPERTIES.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    static TableMetadata newTableMetadata(Schema schema, PartitionSpec spec, SortOrder sortOrder, String location, Map<String, String> properties, int formatVersion) {
        Preconditions.checkArgument(properties.keySet().stream().noneMatch(TableProperties.RESERVED_PROPERTIES::contains), "Table properties should not contain reserved properties, but got %s", properties);
        AtomicInteger lastColumnId = new AtomicInteger(0);
        Schema freshSchema = TypeUtil.assignFreshIds(0, schema, lastColumnId::incrementAndGet);
        PartitionSpec.Builder specBuilder = PartitionSpec.builderFor(freshSchema).withSpecId(0);
        for (PartitionField field : spec.fields()) {
            String sourceName = schema.findColumnName(field.sourceId());
            specBuilder.add(freshSchema.findField(sourceName).fieldId(), field.name(), field.transform().toString());
        }
        PartitionSpec freshSpec = specBuilder.build();
        int freshSortOrderId = sortOrder.isUnsorted() ? sortOrder.orderId() : 1;
        SortOrder freshSortOrder = TableMetadata.freshSortOrder(freshSortOrderId, freshSchema, sortOrder);
        MetricsConfig.fromProperties(properties).validateReferencedColumns(schema);
        return new TableMetadata(null, formatVersion, UUID.randomUUID().toString(), location, 0L, System.currentTimeMillis(), lastColumnId.get(), freshSchema.schemaId(), ImmutableList.of(freshSchema), freshSpec.specId(), ImmutableList.of(freshSpec), freshSpec.lastAssignedFieldId(), freshSortOrderId, ImmutableList.of(freshSortOrder), ImmutableMap.copyOf(properties), -1L, ImmutableList.of(), ImmutableList.of(), ImmutableList.of(), ImmutableList.of());
    }

    TableMetadata(String metadataFileLocation, int formatVersion, String uuid, String location, long lastSequenceNumber, long lastUpdatedMillis, int lastColumnId, int currentSchemaId, List<Schema> schemas, int defaultSpecId, List<PartitionSpec> specs, int lastAssignedPartitionId, int defaultSortOrderId, List<SortOrder> sortOrders, Map<String, String> properties, long currentSnapshotId, List<Snapshot> snapshots, List<HistoryEntry> snapshotLog, List<MetadataLogEntry> previousFiles, List<MetadataUpdate> changes) {
        Preconditions.checkArgument(specs != null && !specs.isEmpty(), "Partition specs cannot be null or empty");
        Preconditions.checkArgument(sortOrders != null && !sortOrders.isEmpty(), "Sort orders cannot be null or empty");
        Preconditions.checkArgument(formatVersion <= 2, "Unsupported format version: v%s", formatVersion);
        Preconditions.checkArgument(formatVersion == 1 || uuid != null, "UUID is required in format v%s", formatVersion);
        Preconditions.checkArgument(formatVersion > 1 || lastSequenceNumber == 0L, "Sequence number must be 0 in v1: %s", lastSequenceNumber);
        Preconditions.checkArgument(metadataFileLocation == null || changes.isEmpty(), "Cannot create TableMetadata with a metadata location and changes");
        this.metadataFileLocation = metadataFileLocation;
        this.formatVersion = formatVersion;
        this.uuid = uuid;
        this.location = location;
        this.lastSequenceNumber = lastSequenceNumber;
        this.lastUpdatedMillis = lastUpdatedMillis;
        this.lastColumnId = lastColumnId;
        this.currentSchemaId = currentSchemaId;
        this.schemas = schemas;
        this.specs = specs;
        this.defaultSpecId = defaultSpecId;
        this.lastAssignedPartitionId = lastAssignedPartitionId;
        this.defaultSortOrderId = defaultSortOrderId;
        this.sortOrders = sortOrders;
        this.properties = properties;
        this.currentSnapshotId = currentSnapshotId;
        this.snapshots = snapshots;
        this.snapshotLog = snapshotLog;
        this.previousFiles = previousFiles;
        this.changes = changes;
        this.snapshotsById = TableMetadata.indexAndValidateSnapshots(snapshots, lastSequenceNumber);
        this.schemasById = this.indexSchemas();
        this.specsById = TableMetadata.indexSpecs(specs);
        this.sortOrdersById = TableMetadata.indexSortOrders(sortOrders);
        HistoryEntry last = null;
        for (HistoryEntry logEntry : snapshotLog) {
            if (last != null) {
                Preconditions.checkArgument(logEntry.timestampMillis() - last.timestampMillis() >= -ONE_MINUTE, "[BUG] Expected sorted snapshot log entries.");
            }
            last = logEntry;
        }
        if (last != null) {
            Preconditions.checkArgument(lastUpdatedMillis - last.timestampMillis() >= -ONE_MINUTE, "Invalid update timestamp %s: before last snapshot log entry at %s", lastUpdatedMillis, last.timestampMillis());
        }
        MetadataLogEntry previous = null;
        for (MetadataLogEntry metadataEntry : previousFiles) {
            if (previous != null) {
                Preconditions.checkArgument(metadataEntry.timestampMillis() - previous.timestampMillis() >= -ONE_MINUTE, "[BUG] Expected sorted previous metadata log entries.");
            }
            previous = metadataEntry;
        }
        if (previous != null) {
            Preconditions.checkArgument(lastUpdatedMillis - previous.timestampMillis >= -ONE_MINUTE, "Invalid update timestamp %s: before the latest metadata log entry timestamp %s", lastUpdatedMillis, previous.timestampMillis);
        }
        Preconditions.checkArgument(currentSnapshotId < 0L || this.snapshotsById.containsKey(currentSnapshotId), "Invalid table metadata: Cannot find current version");
    }

    public int formatVersion() {
        return this.formatVersion;
    }

    public String metadataFileLocation() {
        return this.metadataFileLocation;
    }

    public String uuid() {
        return this.uuid;
    }

    public long lastSequenceNumber() {
        return this.lastSequenceNumber;
    }

    public long nextSequenceNumber() {
        return this.formatVersion > 1 ? this.lastSequenceNumber + 1L : 0L;
    }

    public long lastUpdatedMillis() {
        return this.lastUpdatedMillis;
    }

    public int lastColumnId() {
        return this.lastColumnId;
    }

    public Schema schema() {
        return this.schemasById.get(this.currentSchemaId);
    }

    public List<Schema> schemas() {
        return this.schemas;
    }

    public Map<Integer, Schema> schemasById() {
        return this.schemasById;
    }

    public int currentSchemaId() {
        return this.currentSchemaId;
    }

    public PartitionSpec spec() {
        return this.specsById.get(this.defaultSpecId);
    }

    public PartitionSpec spec(int id) {
        return this.specsById.get(id);
    }

    public List<PartitionSpec> specs() {
        return this.specs;
    }

    public Map<Integer, PartitionSpec> specsById() {
        return this.specsById;
    }

    int lastAssignedPartitionId() {
        return this.lastAssignedPartitionId;
    }

    public int defaultSpecId() {
        return this.defaultSpecId;
    }

    public int defaultSortOrderId() {
        return this.defaultSortOrderId;
    }

    public SortOrder sortOrder() {
        return this.sortOrdersById.get(this.defaultSortOrderId);
    }

    public List<SortOrder> sortOrders() {
        return this.sortOrders;
    }

    public Map<Integer, SortOrder> sortOrdersById() {
        return this.sortOrdersById;
    }

    public String location() {
        return this.location;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public String property(String property, String defaultValue) {
        return this.properties.getOrDefault(property, defaultValue);
    }

    public boolean propertyAsBoolean(String property, boolean defaultValue) {
        return PropertyUtil.propertyAsBoolean(this.properties, property, defaultValue);
    }

    public int propertyAsInt(String property, int defaultValue) {
        return PropertyUtil.propertyAsInt(this.properties, property, defaultValue);
    }

    public long propertyAsLong(String property, long defaultValue) {
        return PropertyUtil.propertyAsLong(this.properties, property, defaultValue);
    }

    public Snapshot snapshot(long snapshotId) {
        return this.snapshotsById.get(snapshotId);
    }

    public Snapshot currentSnapshot() {
        return this.snapshotsById.get(this.currentSnapshotId);
    }

    public List<Snapshot> snapshots() {
        return this.snapshots;
    }

    public List<HistoryEntry> snapshotLog() {
        return this.snapshotLog;
    }

    public List<MetadataLogEntry> previousFiles() {
        return this.previousFiles;
    }

    public List<MetadataUpdate> changes() {
        return this.changes;
    }

    public TableMetadata withUUID() {
        return new Builder(this).assignUUID().build();
    }

    public TableMetadata updateSchema(Schema newSchema, int newLastColumnId) {
        return new Builder(this).setCurrentSchema(newSchema, newLastColumnId).build();
    }

    public TableMetadata updatePartitionSpec(PartitionSpec newPartitionSpec) {
        return new Builder(this).setDefaultPartitionSpec(newPartitionSpec).build();
    }

    public TableMetadata replaceSortOrder(SortOrder newOrder) {
        return new Builder(this).setDefaultSortOrder(newOrder).build();
    }

    public TableMetadata addStagedSnapshot(Snapshot snapshot) {
        return new Builder(this).addSnapshot(snapshot).build();
    }

    public TableMetadata replaceCurrentSnapshot(Snapshot snapshot) {
        return new Builder(this).setCurrentSnapshot(snapshot).build();
    }

    public TableMetadata removeSnapshotsIf(Predicate<Snapshot> removeIf) {
        List<Snapshot> toRemove = this.snapshots.stream().filter(removeIf).collect(Collectors.toList());
        return new Builder(this).removeSnapshots(toRemove).build();
    }

    public TableMetadata replaceProperties(Map<String, String> rawProperties) {
        ValidationException.check(rawProperties != null, "Cannot set properties to null", new Object[0]);
        Map<String, String> newProperties = TableMetadata.unreservedProperties(rawProperties);
        HashSet<String> removed = Sets.newHashSet(this.properties.keySet());
        HashMap<String, String> updated = Maps.newHashMap();
        for (Map.Entry<String, String> entry : newProperties.entrySet()) {
            removed.remove(entry.getKey());
            String current = this.properties.get(entry.getKey());
            if (current != null && current.equals(entry.getValue())) continue;
            updated.put(entry.getKey(), entry.getValue());
        }
        int newFormatVersion = PropertyUtil.propertyAsInt(rawProperties, "format-version", this.formatVersion);
        return new Builder(this).setProperties(updated).removeProperties(removed).upgradeFormatVersion(newFormatVersion).build();
    }

    private PartitionSpec reassignPartitionIds(PartitionSpec partitionSpec, TypeUtil.NextID nextID) {
        PartitionSpec.Builder specBuilder = PartitionSpec.builderFor(partitionSpec.schema()).withSpecId(partitionSpec.specId());
        if (this.formatVersion > 1) {
            Map<Pair, Integer> transformToFieldId = this.specs.stream().flatMap(spec -> spec.fields().stream()).collect(Collectors.toMap(field -> Pair.of(field.sourceId(), field.transform().toString()), PartitionField::fieldId, Math::max));
            for (PartitionField field2 : partitionSpec.fields()) {
                int partitionFieldId = transformToFieldId.computeIfAbsent(Pair.of(field2.sourceId(), field2.transform().toString()), k -> nextID.get());
                specBuilder.add(field2.sourceId(), partitionFieldId, field2.name(), field2.transform());
            }
        } else {
            LinkedHashMap<Pair<Integer, String>, PartitionField> newFields = Maps.newLinkedHashMap();
            for (PartitionField newField : partitionSpec.fields()) {
                newFields.put(Pair.of(newField.sourceId(), newField.transform().toString()), newField);
            }
            List newFieldNames = newFields.values().stream().map(PartitionField::name).collect(Collectors.toList());
            for (PartitionField field3 : this.spec().fields()) {
                PartitionField newField = (PartitionField)newFields.remove(Pair.of(field3.sourceId(), field3.transform().toString()));
                if (newField != null) {
                    specBuilder.add(newField.sourceId(), field3.fieldId(), newField.name(), newField.transform());
                    continue;
                }
                String voidName = newFieldNames.contains(field3.name()) ? field3.name() + "_" + field3.fieldId() : field3.name();
                specBuilder.add(field3.sourceId(), field3.fieldId(), voidName, Transforms.alwaysNull());
            }
            for (PartitionField newField : newFields.values()) {
                specBuilder.add(newField.sourceId(), nextID.get(), newField.name(), newField.transform());
            }
        }
        return specBuilder.build();
    }

    public TableMetadata buildReplacement(Schema updatedSchema, PartitionSpec updatedPartitionSpec, SortOrder updatedSortOrder, String newLocation, Map<String, String> updatedProperties) {
        ValidationException.check(this.formatVersion > 1 || PartitionSpec.hasSequentialIds(updatedPartitionSpec), "Spec does not use sequential IDs that are required in v1: %s", updatedPartitionSpec);
        AtomicInteger newLastColumnId = new AtomicInteger(this.lastColumnId);
        Schema freshSchema = TypeUtil.assignFreshIds(updatedSchema, this.schema(), newLastColumnId::incrementAndGet);
        PartitionSpec freshSpec = this.reassignPartitionIds(TableMetadata.freshSpec(0, freshSchema, updatedPartitionSpec), new AtomicInteger(this.lastAssignedPartitionId)::incrementAndGet);
        SortOrder freshSortOrder = TableMetadata.freshSortOrder(1, freshSchema, updatedSortOrder);
        int newFormatVersion = PropertyUtil.propertyAsInt(updatedProperties, "format-version", this.formatVersion);
        return new Builder(this).upgradeFormatVersion(newFormatVersion).setCurrentSnapshot(null).setCurrentSchema(freshSchema, newLastColumnId.get()).setDefaultPartitionSpec(freshSpec).setDefaultSortOrder(freshSortOrder).setLocation(newLocation).setProperties(TableMetadata.unreservedProperties(updatedProperties)).build();
    }

    public TableMetadata updateLocation(String newLocation) {
        return new Builder(this).setLocation(newLocation).build();
    }

    public TableMetadata upgradeToFormatVersion(int newFormatVersion) {
        return new Builder(this).upgradeFormatVersion(newFormatVersion).build();
    }

    private static PartitionSpec updateSpecSchema(Schema schema, PartitionSpec partitionSpec) {
        PartitionSpec.Builder specBuilder = PartitionSpec.builderFor(schema).withSpecId(partitionSpec.specId());
        for (PartitionField field : partitionSpec.fields()) {
            specBuilder.add(field.sourceId(), field.fieldId(), field.name(), field.transform());
        }
        return specBuilder.buildUnchecked();
    }

    private static SortOrder updateSortOrderSchema(Schema schema, SortOrder sortOrder) {
        SortOrder.Builder builder = SortOrder.builderFor(schema).withOrderId(sortOrder.orderId());
        for (SortField field : sortOrder.fields()) {
            builder.addSortField(field.transform(), field.sourceId(), field.direction(), field.nullOrder());
        }
        return builder.buildUnchecked();
    }

    private static PartitionSpec freshSpec(int specId, Schema schema, PartitionSpec partitionSpec) {
        PartitionSpec.Builder specBuilder = PartitionSpec.builderFor(schema).withSpecId(specId);
        for (PartitionField field : partitionSpec.fields()) {
            String sourceName = partitionSpec.schema().findColumnName(field.sourceId());
            specBuilder.add(schema.findField(sourceName).fieldId(), field.fieldId(), field.name(), field.transform().toString());
        }
        return specBuilder.build();
    }

    private static SortOrder freshSortOrder(int orderId, Schema schema, SortOrder sortOrder) {
        SortOrder.Builder builder = SortOrder.builderFor(schema);
        if (sortOrder.isSorted()) {
            builder.withOrderId(orderId);
        }
        for (SortField field : sortOrder.fields()) {
            String sourceName = sortOrder.schema().findColumnName(field.sourceId());
            int newSourceId = schema.findField(sourceName).fieldId();
            builder.addSortField(field.transform().toString(), newSourceId, field.direction(), field.nullOrder());
        }
        return builder.build();
    }

    private static Map<Long, Snapshot> indexAndValidateSnapshots(List<Snapshot> snapshots, long lastSequenceNumber) {
        ImmutableMap.Builder<Long, Snapshot> builder = ImmutableMap.builder();
        for (Snapshot snap : snapshots) {
            ValidationException.check(snap.sequenceNumber() <= lastSequenceNumber, "Invalid snapshot with sequence number %s greater than last sequence number %s", snap.sequenceNumber(), lastSequenceNumber);
            builder.put(snap.snapshotId(), snap);
        }
        return builder.build();
    }

    private Map<Integer, Schema> indexSchemas() {
        ImmutableMap.Builder<Integer, Schema> builder = ImmutableMap.builder();
        for (Schema schema : this.schemas) {
            builder.put(schema.schemaId(), schema);
        }
        return builder.build();
    }

    private static Map<Integer, PartitionSpec> indexSpecs(List<PartitionSpec> specs) {
        ImmutableMap.Builder<Integer, PartitionSpec> builder = ImmutableMap.builder();
        for (PartitionSpec spec : specs) {
            builder.put(spec.specId(), spec);
        }
        return builder.build();
    }

    private static Map<Integer, SortOrder> indexSortOrders(List<SortOrder> sortOrders) {
        ImmutableMap.Builder<Integer, SortOrder> builder = ImmutableMap.builder();
        for (SortOrder sortOrder : sortOrders) {
            builder.put(sortOrder.orderId(), sortOrder);
        }
        return builder.build();
    }

    public static Builder buildFrom(TableMetadata base) {
        return new Builder(base);
    }

    public static class Builder {
        private final TableMetadata base;
        private int formatVersion;
        private String uuid;
        private Long lastUpdatedMillis;
        private String location;
        private long lastSequenceNumber;
        private int lastColumnId;
        private int currentSchemaId;
        private final List<Schema> schemas;
        private int defaultSpecId;
        private List<PartitionSpec> specs;
        private int lastAssignedPartitionId;
        private int defaultSortOrderId;
        private List<SortOrder> sortOrders;
        private final Map<String, String> properties;
        private long currentSnapshotId;
        private List<Snapshot> snapshots;
        private final List<MetadataUpdate> changes;
        private final int startingChangeCount;
        private boolean discardChanges = false;
        private final List<HistoryEntry> snapshotLog;
        private final String previousFileLocation;
        private final List<MetadataLogEntry> previousFiles;
        private final Map<Long, Snapshot> snapshotsById;
        private final Map<Integer, Schema> schemasById;
        private final Map<Integer, PartitionSpec> specsById;
        private final Map<Integer, SortOrder> sortOrdersById;

        private Builder(TableMetadata base) {
            this.base = base;
            this.formatVersion = base.formatVersion;
            this.uuid = base.uuid;
            this.lastUpdatedMillis = null;
            this.location = base.location;
            this.lastSequenceNumber = base.lastSequenceNumber;
            this.lastColumnId = base.lastColumnId;
            this.currentSchemaId = base.currentSchemaId;
            this.schemas = Lists.newArrayList(base.schemas);
            this.defaultSpecId = base.defaultSpecId;
            this.specs = Lists.newArrayList(base.specs);
            this.lastAssignedPartitionId = base.lastAssignedPartitionId;
            this.defaultSortOrderId = base.defaultSortOrderId;
            this.sortOrders = Lists.newArrayList(base.sortOrders);
            this.properties = Maps.newHashMap(base.properties);
            this.currentSnapshotId = base.currentSnapshotId;
            this.snapshots = Lists.newArrayList(base.snapshots);
            this.changes = Lists.newArrayList(base.changes);
            this.startingChangeCount = this.changes.size();
            this.snapshotLog = Lists.newArrayList(base.snapshotLog);
            this.previousFileLocation = base.metadataFileLocation;
            this.previousFiles = base.previousFiles;
            this.snapshotsById = Maps.newHashMap(base.snapshotsById);
            this.schemasById = Maps.newHashMap(base.schemasById);
            this.specsById = Maps.newHashMap(base.specsById);
            this.sortOrdersById = Maps.newHashMap(base.sortOrdersById);
        }

        public Builder assignUUID() {
            if (this.uuid == null) {
                this.uuid = UUID.randomUUID().toString();
                this.changes.add(new MetadataUpdate.AssignUUID(this.uuid));
            }
            return this;
        }

        public Builder upgradeFormatVersion(int newFormatVersion) {
            Preconditions.checkArgument(newFormatVersion <= 2, "Cannot upgrade table to unsupported format version: v%s (supported: v%s)", newFormatVersion, 2);
            Preconditions.checkArgument(newFormatVersion >= this.formatVersion, "Cannot downgrade v%s table to v%s", this.formatVersion, newFormatVersion);
            if (newFormatVersion == this.formatVersion) {
                return this;
            }
            this.formatVersion = newFormatVersion;
            this.changes.add(new MetadataUpdate.UpgradeFormatVersion(newFormatVersion));
            return this;
        }

        public Builder setCurrentSchema(Schema newSchema, int newLastColumnId) {
            this.setCurrentSchema(this.addSchemaInternal(newSchema, newLastColumnId));
            return this;
        }

        public Builder setCurrentSchema(int schemaId) {
            if (this.currentSchemaId == schemaId) {
                return this;
            }
            Schema schema = this.schemasById.get(schemaId);
            Preconditions.checkArgument(schema != null, "Cannot set current schema to unknown schema: %s", schemaId);
            this.specs = Lists.newArrayList(Iterables.transform(this.specs, spec -> TableMetadata.updateSpecSchema(schema, spec)));
            this.specsById.clear();
            this.specsById.putAll(TableMetadata.indexSpecs(this.specs));
            this.sortOrders = Lists.newArrayList(Iterables.transform(this.sortOrders, order -> TableMetadata.updateSortOrderSchema(schema, order)));
            this.sortOrdersById.clear();
            this.sortOrdersById.putAll(TableMetadata.indexSortOrders(this.sortOrders));
            this.currentSchemaId = schemaId;
            this.changes.add(new MetadataUpdate.SetCurrentSchema(schemaId));
            return this;
        }

        public Builder addSchema(Schema schema, int newLastColumnId) {
            this.addSchemaInternal(schema, newLastColumnId);
            return this;
        }

        public Builder setDefaultPartitionSpec(PartitionSpec spec) {
            this.setDefaultPartitionSpec(this.addPartitionSpecInternal(spec));
            return this;
        }

        public Builder setDefaultPartitionSpec(int specId) {
            if (this.defaultSpecId == specId) {
                return this;
            }
            this.defaultSpecId = specId;
            this.changes.add(new MetadataUpdate.SetDefaultPartitionSpec(specId));
            return this;
        }

        public Builder addPartitionSpec(PartitionSpec spec) {
            this.addPartitionSpecInternal(spec);
            return this;
        }

        public Builder setDefaultSortOrder(SortOrder order) {
            this.setDefaultSortOrder(this.addSortOrderInternal(order));
            return this;
        }

        public Builder setDefaultSortOrder(int sortOrderId) {
            if (sortOrderId == this.defaultSortOrderId) {
                return this;
            }
            this.defaultSortOrderId = sortOrderId;
            this.changes.add(new MetadataUpdate.SetDefaultSortOrder(sortOrderId));
            return this;
        }

        public Builder addSortOrder(SortOrder order) {
            this.addSortOrderInternal(order);
            return this;
        }

        public Builder addSnapshot(Snapshot snapshot) {
            if (snapshot == null || this.snapshotsById.containsKey(snapshot.snapshotId())) {
                return this;
            }
            ValidationException.check(this.formatVersion == 1 || snapshot.sequenceNumber() > this.lastSequenceNumber, "Cannot add snapshot with sequence number %s older than last sequence number %s", snapshot.sequenceNumber(), this.lastSequenceNumber);
            this.lastUpdatedMillis = snapshot.timestampMillis();
            this.lastSequenceNumber = snapshot.sequenceNumber();
            this.snapshots.add(snapshot);
            this.snapshotsById.put(snapshot.snapshotId(), snapshot);
            this.changes.add(new MetadataUpdate.AddSnapshot(snapshot));
            return this;
        }

        public Builder setCurrentSnapshot(Snapshot snapshot) {
            this.addSnapshot(snapshot);
            this.setCurrentSnapshot(snapshot, null);
            return this;
        }

        public Builder setCurrentSnapshot(long snapshotId) {
            if (this.currentSnapshotId == snapshotId) {
                return this;
            }
            Snapshot snapshot = this.snapshotsById.get(snapshotId);
            ValidationException.check(snapshot != null, "Cannot set current snapshot to unknown: %s", snapshotId);
            this.setCurrentSnapshot(snapshot, System.currentTimeMillis());
            return this;
        }

        public Builder removeSnapshots(List<Snapshot> snapshotsToRemove) {
            Set idsToRemove = snapshotsToRemove.stream().map(Snapshot::snapshotId).collect(Collectors.toSet());
            ArrayList<Snapshot> retainedSnapshots = Lists.newArrayListWithExpectedSize(this.snapshots.size() - idsToRemove.size());
            for (Snapshot snapshot : this.snapshots) {
                long snapshotId = snapshot.snapshotId();
                if (idsToRemove.contains(snapshotId)) {
                    this.snapshotsById.remove(snapshotId);
                    this.changes.add(new MetadataUpdate.RemoveSnapshot(snapshotId));
                    continue;
                }
                retainedSnapshots.add(snapshot);
            }
            this.snapshots = retainedSnapshots;
            if (!this.snapshotsById.containsKey(this.currentSnapshotId)) {
                this.setCurrentSnapshot(null, System.currentTimeMillis());
            }
            return this;
        }

        public Builder setProperties(Map<String, String> updated) {
            if (updated.isEmpty()) {
                return this;
            }
            this.properties.putAll(updated);
            this.changes.add(new MetadataUpdate.SetProperties(updated));
            return this;
        }

        public Builder removeProperties(Set<String> removed) {
            if (removed.isEmpty()) {
                return this;
            }
            removed.forEach(this.properties::remove);
            this.changes.add(new MetadataUpdate.RemoveProperties(removed));
            return this;
        }

        public Builder setLocation(String newLocation) {
            if (this.location != null && this.location.equals(newLocation)) {
                return this;
            }
            this.location = newLocation;
            this.changes.add(new MetadataUpdate.SetLocation(newLocation));
            return this;
        }

        public Builder discardChanges() {
            this.discardChanges = true;
            return this;
        }

        public TableMetadata build() {
            if (!(this.changes.size() != this.startingChangeCount || this.discardChanges && this.changes.size() > 0)) {
                return this.base;
            }
            if (this.lastUpdatedMillis == null) {
                this.lastUpdatedMillis = System.currentTimeMillis();
            }
            Schema schema = this.schemasById.get(this.currentSchemaId);
            PartitionSpec.checkCompatibility(this.specsById.get(this.defaultSpecId), schema);
            SortOrder.checkCompatibility(this.sortOrdersById.get(this.defaultSortOrderId), schema);
            List<MetadataLogEntry> metadataHistory = Builder.addPreviousFile(this.previousFiles, this.previousFileLocation, this.base.lastUpdatedMillis(), this.properties);
            List<HistoryEntry> newSnapshotLog = Builder.updateSnapshotLog(this.snapshotLog, this.snapshotsById, this.currentSnapshotId, this.changes);
            return new TableMetadata(null, this.formatVersion, this.uuid, this.location, this.lastSequenceNumber, this.lastUpdatedMillis, this.lastColumnId, this.currentSchemaId, ImmutableList.copyOf(this.schemas), this.defaultSpecId, ImmutableList.copyOf(this.specs), this.lastAssignedPartitionId, this.defaultSortOrderId, ImmutableList.copyOf(this.sortOrders), ImmutableMap.copyOf(this.properties), this.currentSnapshotId, ImmutableList.copyOf(this.snapshots), ImmutableList.copyOf(newSnapshotLog), ImmutableList.copyOf(metadataHistory), this.discardChanges ? ImmutableList.of() : ImmutableList.copyOf(this.changes));
        }

        private int addSchemaInternal(Schema schema, int newLastColumnId) {
            Preconditions.checkArgument(newLastColumnId >= this.lastColumnId, "Invalid last column ID: %s < %s (previous last column ID)", newLastColumnId, this.lastColumnId);
            int newSchemaId = this.reuseOrCreateNewSchemaId(schema);
            boolean schemaFound = this.schemasById.containsKey(newSchemaId);
            if (schemaFound && newLastColumnId == this.lastColumnId) {
                return newSchemaId;
            }
            this.lastColumnId = newLastColumnId;
            Schema newSchema = newSchemaId != schema.schemaId() ? new Schema(newSchemaId, schema.columns(), schema.identifierFieldIds()) : schema;
            if (!schemaFound) {
                this.schemas.add(newSchema);
                this.schemasById.put(newSchema.schemaId(), newSchema);
            }
            this.changes.add(new MetadataUpdate.AddSchema(newSchema, this.lastColumnId));
            return newSchemaId;
        }

        private int reuseOrCreateNewSchemaId(Schema newSchema) {
            int newSchemaId = this.currentSchemaId;
            for (Schema schema : this.schemas) {
                if (schema.sameSchema(newSchema)) {
                    return schema.schemaId();
                }
                if (schema.schemaId() < newSchemaId) continue;
                newSchemaId = schema.schemaId() + 1;
            }
            return newSchemaId;
        }

        private int addPartitionSpecInternal(PartitionSpec spec) {
            int newSpecId = this.reuseOrCreateNewSpecId(spec);
            if (this.specsById.containsKey(newSpecId)) {
                return newSpecId;
            }
            Schema schema = this.schemasById.get(this.currentSchemaId);
            PartitionSpec.checkCompatibility(spec, schema);
            ValidationException.check(this.formatVersion > 1 || PartitionSpec.hasSequentialIds(spec), "Spec does not use sequential IDs that are required in v1: %s", spec);
            PartitionSpec newSpec = TableMetadata.freshSpec(newSpecId, schema, spec);
            this.lastAssignedPartitionId = Math.max(this.lastAssignedPartitionId, newSpec.lastAssignedFieldId());
            this.specs.add(newSpec);
            this.specsById.put(newSpecId, newSpec);
            this.changes.add(new MetadataUpdate.AddPartitionSpec(newSpec));
            return newSpecId;
        }

        private int reuseOrCreateNewSpecId(PartitionSpec newSpec) {
            int newSpecId = 0;
            for (PartitionSpec spec : this.specs) {
                if (newSpec.compatibleWith(spec)) {
                    return spec.specId();
                }
                if (newSpecId > spec.specId()) continue;
                newSpecId = spec.specId() + 1;
            }
            return newSpecId;
        }

        private int addSortOrderInternal(SortOrder order) {
            int newOrderId = this.reuseOrCreateNewSortOrderId(order);
            if (this.sortOrdersById.containsKey(newOrderId)) {
                return newOrderId;
            }
            Schema schema = this.schemasById.get(this.currentSchemaId);
            SortOrder.checkCompatibility(order, schema);
            SortOrder newOrder = order.isUnsorted() ? SortOrder.unsorted() : TableMetadata.freshSortOrder(newOrderId, schema, order);
            this.sortOrders.add(newOrder);
            this.sortOrdersById.put(newOrderId, newOrder);
            this.changes.add(new MetadataUpdate.AddSortOrder(newOrder));
            return newOrderId;
        }

        private int reuseOrCreateNewSortOrderId(SortOrder newOrder) {
            if (newOrder.isUnsorted()) {
                return SortOrder.unsorted().orderId();
            }
            int newOrderId = 1;
            for (SortOrder order : this.sortOrders) {
                if (order.sameOrder(newOrder)) {
                    return order.orderId();
                }
                if (newOrderId > order.orderId()) continue;
                newOrderId = order.orderId() + 1;
            }
            return newOrderId;
        }

        private void setCurrentSnapshot(Snapshot snapshot, Long currentTimestampMillis) {
            if (snapshot == null) {
                this.currentSnapshotId = -1L;
                this.snapshotLog.clear();
                this.changes.add(new MetadataUpdate.SetCurrentSnapshot(null));
                return;
            }
            if (this.currentSnapshotId == snapshot.snapshotId()) {
                return;
            }
            ValidationException.check(this.formatVersion == 1 || snapshot.sequenceNumber() <= this.lastSequenceNumber, "Last sequence number %s is less than existing snapshot sequence number %s", this.lastSequenceNumber, snapshot.sequenceNumber());
            this.lastUpdatedMillis = currentTimestampMillis != null ? currentTimestampMillis.longValue() : snapshot.timestampMillis();
            this.currentSnapshotId = snapshot.snapshotId();
            this.snapshotLog.add(new SnapshotLogEntry(this.lastUpdatedMillis, snapshot.snapshotId()));
            this.changes.add(new MetadataUpdate.SetCurrentSnapshot(snapshot.snapshotId()));
        }

        private static List<MetadataLogEntry> addPreviousFile(List<MetadataLogEntry> previousFiles, String previousFileLocation, long timestampMillis, Map<String, String> properties) {
            ArrayList<MetadataLogEntry> newMetadataLog;
            if (previousFileLocation == null) {
                return previousFiles;
            }
            int maxSize = Math.max(1, PropertyUtil.propertyAsInt(properties, "write.metadata.previous-versions-max", 100));
            if (previousFiles.size() >= maxSize) {
                int removeIndex = previousFiles.size() - maxSize + 1;
                newMetadataLog = Lists.newArrayList(previousFiles.subList(removeIndex, previousFiles.size()));
            } else {
                newMetadataLog = Lists.newArrayList(previousFiles);
            }
            newMetadataLog.add(new MetadataLogEntry(timestampMillis, previousFileLocation));
            return newMetadataLog;
        }

        private static Set<Long> intermediateSnapshotIdSet(List<MetadataUpdate> changes, long currentSnapshotId) {
            HashSet<Long> addedSnapshotIds = Sets.newHashSet();
            HashSet<Long> intermediateSnapshotIds = Sets.newHashSet();
            for (MetadataUpdate update : changes) {
                Long snapshotId;
                if (update instanceof MetadataUpdate.AddSnapshot) {
                    MetadataUpdate.AddSnapshot addSnapshot = (MetadataUpdate.AddSnapshot)update;
                    addedSnapshotIds.add(addSnapshot.snapshot().snapshotId());
                    continue;
                }
                if (!(update instanceof MetadataUpdate.SetCurrentSnapshot) || (snapshotId = ((MetadataUpdate.SetCurrentSnapshot)update).snapshotId()) == null || !addedSnapshotIds.contains(snapshotId) || snapshotId == currentSnapshotId) continue;
                intermediateSnapshotIds.add(snapshotId);
            }
            return intermediateSnapshotIds;
        }

        private static List<HistoryEntry> updateSnapshotLog(List<HistoryEntry> snapshotLog, Map<Long, Snapshot> snapshotsById, long currentSnapshotId, List<MetadataUpdate> changes) {
            Set<Long> intermediateSnapshotIds = Builder.intermediateSnapshotIdSet(changes, currentSnapshotId);
            ArrayList<HistoryEntry> newSnapshotLog = Lists.newArrayList();
            for (HistoryEntry logEntry : snapshotLog) {
                long snapshotId = logEntry.snapshotId();
                if (snapshotsById.containsKey(snapshotId) && !intermediateSnapshotIds.contains(snapshotId)) {
                    newSnapshotLog.add(logEntry);
                    continue;
                }
                newSnapshotLog.clear();
            }
            if (snapshotsById.get(currentSnapshotId) != null) {
                ValidationException.check(((HistoryEntry)Iterables.getLast(newSnapshotLog)).snapshotId() == currentSnapshotId, "Cannot set invalid snapshot log: latest entry is not the current snapshot", new Object[0]);
            }
            return newSnapshotLog;
        }
    }

    public static class MetadataLogEntry {
        private final long timestampMillis;
        private final String file;

        MetadataLogEntry(long timestampMillis, String file) {
            this.timestampMillis = timestampMillis;
            this.file = file;
        }

        public long timestampMillis() {
            return this.timestampMillis;
        }

        public String file() {
            return this.file;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MetadataLogEntry)) {
                return false;
            }
            MetadataLogEntry that = (MetadataLogEntry)other;
            return this.timestampMillis == that.timestampMillis && java.util.Objects.equals(this.file, that.file);
        }

        public int hashCode() {
            return Objects.hashCode(this.timestampMillis, this.file);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("timestampMillis", this.timestampMillis).add("file", this.file).toString();
        }
    }

    public static class SnapshotLogEntry
    implements HistoryEntry {
        private final long timestampMillis;
        private final long snapshotId;

        SnapshotLogEntry(long timestampMillis, long snapshotId) {
            this.timestampMillis = timestampMillis;
            this.snapshotId = snapshotId;
        }

        @Override
        public long timestampMillis() {
            return this.timestampMillis;
        }

        @Override
        public long snapshotId() {
            return this.snapshotId;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SnapshotLogEntry)) {
                return false;
            }
            SnapshotLogEntry that = (SnapshotLogEntry)other;
            return this.timestampMillis == that.timestampMillis && this.snapshotId == that.snapshotId;
        }

        public int hashCode() {
            return Objects.hashCode(this.timestampMillis, this.snapshotId);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("timestampMillis", this.timestampMillis).add("snapshotId", this.snapshotId).toString();
        }
    }
}

