/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hadoop;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.hadoop.HadoopStreams;
import org.apache.iceberg.hadoop.Util;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.SeekableInputStream;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

public class HadoopInputFile
implements InputFile {
    public static final String[] NO_LOCATION_PREFERENCE = new String[0];
    private final String location;
    private final FileSystem fs;
    private final Path path;
    private final Configuration conf;
    private FileStatus stat = null;
    private Long length = null;

    public static HadoopInputFile fromLocation(CharSequence location, Configuration conf) {
        FileSystem fs = Util.getFs(new Path(location.toString()), conf);
        return new HadoopInputFile(fs, location.toString(), conf);
    }

    public static HadoopInputFile fromLocation(CharSequence location, long length, Configuration conf) {
        FileSystem fs = Util.getFs(new Path(location.toString()), conf);
        return new HadoopInputFile(fs, location.toString(), length, conf);
    }

    public static HadoopInputFile fromLocation(CharSequence location, FileSystem fs) {
        return new HadoopInputFile(fs, location.toString(), fs.getConf());
    }

    public static HadoopInputFile fromLocation(CharSequence location, long length, FileSystem fs) {
        return new HadoopInputFile(fs, location.toString(), length, fs.getConf());
    }

    public static HadoopInputFile fromPath(Path path, Configuration conf) {
        FileSystem fs = Util.getFs(path, conf);
        return HadoopInputFile.fromPath(path, fs, conf);
    }

    public static HadoopInputFile fromPath(Path path, long length, Configuration conf) {
        FileSystem fs = Util.getFs(path, conf);
        return HadoopInputFile.fromPath(path, length, fs, conf);
    }

    public static HadoopInputFile fromPath(Path path, FileSystem fs) {
        return HadoopInputFile.fromPath(path, fs, fs.getConf());
    }

    public static HadoopInputFile fromPath(Path path, long length, FileSystem fs) {
        return HadoopInputFile.fromPath(path, length, fs, fs.getConf());
    }

    public static HadoopInputFile fromPath(Path path, FileSystem fs, Configuration conf) {
        return new HadoopInputFile(fs, path, conf);
    }

    public static HadoopInputFile fromPath(Path path, long length, FileSystem fs, Configuration conf) {
        return new HadoopInputFile(fs, path, length, conf);
    }

    public static HadoopInputFile fromStatus(FileStatus stat, Configuration conf) {
        FileSystem fs = Util.getFs(stat.getPath(), conf);
        return HadoopInputFile.fromStatus(stat, fs, conf);
    }

    public static HadoopInputFile fromStatus(FileStatus stat, FileSystem fs) {
        return HadoopInputFile.fromStatus(stat, fs, fs.getConf());
    }

    public static HadoopInputFile fromStatus(FileStatus stat, FileSystem fs, Configuration conf) {
        return new HadoopInputFile(fs, stat, conf);
    }

    private HadoopInputFile(FileSystem fs, String location, Configuration conf) {
        this.fs = fs;
        this.location = location;
        this.path = new Path(location);
        this.conf = conf;
    }

    private HadoopInputFile(FileSystem fs, String location, long length, Configuration conf) {
        Preconditions.checkArgument(length >= 0L, "Invalid file length: %s", length);
        this.fs = fs;
        this.location = location;
        this.path = new Path(location);
        this.conf = conf;
        this.length = length;
    }

    private HadoopInputFile(FileSystem fs, Path path, Configuration conf) {
        this.fs = fs;
        this.path = path;
        this.location = path.toString();
        this.conf = conf;
    }

    private HadoopInputFile(FileSystem fs, Path path, long length, Configuration conf) {
        Preconditions.checkArgument(length >= 0L, "Invalid file length: %s", length);
        this.fs = fs;
        this.path = path;
        this.location = path.toString();
        this.conf = conf;
        this.length = length;
    }

    private HadoopInputFile(FileSystem fs, FileStatus stat, Configuration conf) {
        this.fs = fs;
        this.path = stat.getPath();
        this.location = this.path.toString();
        this.stat = stat;
        this.conf = conf;
        this.length = stat.getLen();
    }

    private FileStatus lazyStat() {
        if (this.stat == null) {
            try {
                this.stat = this.fs.getFileStatus(this.path);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to get status for file: %s", this.path);
            }
        }
        return this.stat;
    }

    @Override
    public long getLength() {
        if (this.length == null) {
            this.length = this.lazyStat().getLen();
        }
        return this.length;
    }

    @Override
    public SeekableInputStream newStream() {
        try {
            return HadoopStreams.wrap(this.fs.open(this.path));
        }
        catch (FileNotFoundException e) {
            throw new NotFoundException(e, "Failed to open input stream for file: %s", this.path);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to open input stream for file: %s", this.path);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public FileStatus getStat() {
        return this.lazyStat();
    }

    public Path getPath() {
        return this.path;
    }

    public String[] getBlockLocations(long start, long end) {
        ArrayList hosts = Lists.newArrayList();
        try {
            for (BlockLocation bl : this.fs.getFileBlockLocations(this.path, start, end)) {
                Collections.addAll(hosts, bl.getHosts());
            }
            return hosts.toArray(NO_LOCATION_PREFERENCE);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to get block locations for path: %s", this.path);
        }
    }

    @Override
    public String location() {
        return this.location;
    }

    @Override
    public boolean exists() {
        try {
            return this.fs.exists(this.path);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to check existence for file: %s", this.path);
        }
    }

    public String toString() {
        return this.path.toString();
    }
}

