/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.util.ArrayList;
import java.util.List;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortDirection;
import org.apache.iceberg.SortField;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.transforms.Bucket;
import org.apache.iceberg.transforms.Dates;
import org.apache.iceberg.transforms.Identity;
import org.apache.iceberg.transforms.Timestamps;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.Truncate;
import org.apache.iceberg.transforms.UnknownTransform;

public interface SortOrderVisitor<T> {
    public T field(String var1, int var2, SortDirection var3, NullOrder var4);

    public T bucket(String var1, int var2, int var3, SortDirection var4, NullOrder var5);

    public T truncate(String var1, int var2, int var3, SortDirection var4, NullOrder var5);

    public T year(String var1, int var2, SortDirection var3, NullOrder var4);

    public T month(String var1, int var2, SortDirection var3, NullOrder var4);

    public T day(String var1, int var2, SortDirection var3, NullOrder var4);

    public T hour(String var1, int var2, SortDirection var3, NullOrder var4);

    default public T unknown(String sourceName, int sourceId, String transform, SortDirection direction, NullOrder nullOrder) {
        throw new UnsupportedOperationException(String.format("Unknown transform %s is not supported", transform));
    }

    public static <R> List<R> visit(SortOrder sortOrder, SortOrderVisitor<R> visitor) {
        Schema schema = sortOrder.schema();
        ArrayList<R> results = Lists.newArrayListWithExpectedSize(sortOrder.fields().size());
        for (SortField field : sortOrder.fields()) {
            String sourceName = schema.findColumnName(field.sourceId());
            Transform transform = field.transform();
            if (transform == null || transform instanceof Identity) {
                results.add(visitor.field(sourceName, field.sourceId(), field.direction(), field.nullOrder()));
                continue;
            }
            if (transform instanceof Bucket) {
                int numBuckets = ((Bucket)transform).numBuckets();
                results.add(visitor.bucket(sourceName, field.sourceId(), numBuckets, field.direction(), field.nullOrder()));
                continue;
            }
            if (transform instanceof Truncate) {
                int width = ((Truncate)transform).width();
                results.add(visitor.truncate(sourceName, field.sourceId(), width, field.direction(), field.nullOrder()));
                continue;
            }
            if (transform == Dates.YEAR || transform == Timestamps.YEAR) {
                results.add(visitor.year(sourceName, field.sourceId(), field.direction(), field.nullOrder()));
                continue;
            }
            if (transform == Dates.MONTH || transform == Timestamps.MONTH) {
                results.add(visitor.month(sourceName, field.sourceId(), field.direction(), field.nullOrder()));
                continue;
            }
            if (transform == Dates.DAY || transform == Timestamps.DAY) {
                results.add(visitor.day(sourceName, field.sourceId(), field.direction(), field.nullOrder()));
                continue;
            }
            if (transform == Timestamps.HOUR) {
                results.add(visitor.hour(sourceName, field.sourceId(), field.direction(), field.nullOrder()));
                continue;
            }
            if (!(transform instanceof UnknownTransform)) continue;
            results.add(visitor.unknown(sourceName, field.sourceId(), transform.toString(), field.direction(), field.nullOrder()));
        }
        return results;
    }
}

