/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Iterators;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.CharSequenceWrapper;

public class CharSequenceSet
implements Set<CharSequence>,
Serializable {
    private static final ThreadLocal<CharSequenceWrapper> wrappers = ThreadLocal.withInitial(() -> CharSequenceWrapper.wrap(null));
    private final Set<CharSequenceWrapper> wrapperSet;

    public static CharSequenceSet of(Iterable<CharSequence> charSequences) {
        return new CharSequenceSet(charSequences);
    }

    public static CharSequenceSet empty() {
        return new CharSequenceSet(ImmutableList.of());
    }

    private CharSequenceSet(Iterable<CharSequence> charSequences) {
        this.wrapperSet = Sets.newHashSet(Iterables.transform(charSequences, CharSequenceWrapper::wrap));
    }

    @Override
    public int size() {
        return this.wrapperSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapperSet.isEmpty();
    }

    @Override
    public boolean contains(Object obj) {
        if (obj instanceof CharSequence) {
            CharSequenceWrapper wrapper = wrappers.get();
            boolean result = this.wrapperSet.contains(wrapper.set((CharSequence)obj));
            wrapper.set(null);
            return result;
        }
        return false;
    }

    @Override
    public Iterator<CharSequence> iterator() {
        return Iterators.transform(this.wrapperSet.iterator(), CharSequenceWrapper::get);
    }

    @Override
    public Object[] toArray() {
        return Iterators.toArray(this.iterator(), CharSequence.class);
    }

    @Override
    public <T> T[] toArray(T[] destArray) {
        int size = this.wrapperSet.size();
        if (destArray.length < size) {
            return this.toArray();
        }
        Iterator<CharSequence> iter = this.iterator();
        int ind = 0;
        while (iter.hasNext()) {
            destArray[ind] = iter.next();
            ++ind;
        }
        if (destArray.length > size) {
            destArray[size] = null;
        }
        return destArray;
    }

    @Override
    public boolean add(CharSequence charSequence) {
        return this.wrapperSet.add(CharSequenceWrapper.wrap(charSequence));
    }

    @Override
    public boolean remove(Object obj) {
        if (obj instanceof CharSequence) {
            CharSequenceWrapper wrapper = wrappers.get();
            boolean result = this.wrapperSet.remove(wrapper.set((CharSequence)obj));
            wrapper.set(null);
            return result;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        if (objects != null) {
            return Iterables.all(objects, this::contains);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends CharSequence> charSequences) {
        if (charSequences != null) {
            return Iterables.addAll(this.wrapperSet, Iterables.transform(charSequences, CharSequenceWrapper::wrap));
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        if (objects != null) {
            return Iterables.removeAll(this.wrapperSet, objects);
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        if (objects != null) {
            return Iterables.removeAll(this.wrapperSet, objects);
        }
        return false;
    }

    @Override
    public void clear() {
        this.wrapperSet.clear();
    }
}

