/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.spark.http.source;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.config.TypesafeConfigUtils;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.spark.SparkEnvironment;
import org.apache.seatunnel.spark.batch.SparkBatchSource;
import org.apache.seatunnel.spark.http.source.util.HttpClientResult;
import org.apache.seatunnel.spark.http.source.util.HttpClientUtils;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http
extends SparkBatchSource {
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final int INITIAL_CAPACITY = 16;
    private static Logger LOG = LoggerFactory.getLogger(Http.class);

    public CheckResult checkConfig() {
        return CheckConfigUtil.checkAllExists((Config)this.config, (String[])new String[]{"url"});
    }

    public void prepare(SparkEnvironment prepareEnv) {
    }

    public Dataset<Row> getData(SparkEnvironment env) {
        SparkSession spark = env.getSparkSession();
        String url = this.config.getString("url");
        String method = (String)TypesafeConfigUtils.getConfig((Config)this.config, (String)"method", (Object)GET);
        String header = (String)TypesafeConfigUtils.getConfig((Config)this.config, (String)"header", (Object)"");
        String requestParams = (String)TypesafeConfigUtils.getConfig((Config)this.config, (String)"request_params", (Object)"");
        String syncPath = (String)TypesafeConfigUtils.getConfig((Config)this.config, (String)"sync_path", (Object)"");
        JavaSparkContext jsc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        Map requestMap = this.jsonToMap(requestParams);
        String syncValues = this.getSyncValues(jsc, syncPath);
        LOG.info("sync values->{}", (Object)syncValues);
        Map syncMap = this.jsonToMap(syncValues);
        if (!syncMap.isEmpty()) {
            requestMap.putAll(syncMap);
        }
        HttpClientResult response = new HttpClientResult();
        try {
            Map headerMap = this.jsonToMap(header);
            response = POST.equals(method) ? HttpClientUtils.doPost(url, headerMap, requestMap) : HttpClientUtils.doGet(url, headerMap, requestMap);
        }
        catch (Exception e) {
            LOG.error("http call error!", (Throwable)e);
        }
        LOG.info("http respond code->{}", (Object)response.getCode());
        ArrayList<String> array = new ArrayList<String>();
        array.add(response.getContent());
        JavaRDD javaRDD = jsc.parallelize(array);
        DataFrameReader reader = spark.read().format("json");
        return reader.json(javaRDD);
    }

    private String getSyncValues(JavaSparkContext jsc, String syncPath) {
        if (null == syncPath || syncPath.isEmpty()) {
            return "";
        }
        Configuration hadoopConf = jsc.hadoopConfiguration();
        List values = new ArrayList();
        try {
            FileSystem fs = FileSystem.get((Configuration)hadoopConf);
            Path path = new Path(syncPath);
            boolean exists = fs.exists(path);
            if (exists) {
                JavaRDD checkPoint = jsc.textFile(syncPath);
                values = checkPoint.collect();
            }
        }
        catch (IOException e) {
            LOG.error("getSyncValues error, syncPath is {}", (Object)syncPath, (Object)e);
        }
        return values.isEmpty() ? "" : (String)values.iterator().next();
    }

    private Map jsonToMap(String content) {
        HashMap map = new HashMap(16);
        if (null == content || content.isEmpty()) {
            return map;
        }
        try {
            return (Map)new ObjectMapper().readValue(content, HashMap.class);
        }
        catch (IOException e) {
            LOG.error("{} json to map error!", (Object)content, (Object)e);
            return map;
        }
    }
}

